/*******************************************************************************
*    ALMA - Atacama Large Millimiter Array
*    (c) Associated Universities Inc., 2002 *
*    (c) European Southern Observatory, 2002
*    Copyright by ESO (in the framework of the ALMA collaboration)
*    and Cosylab 2002, All rights reserved
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
*
*
* "@(#) $Id: acscourseMount1Impl.cpp,v 1.1 2004/01/28 11:38:34 bjeram Exp $"
*
*/
 
#include <isabellaLampImpl.h>

/* ----------------------------------------------------------------*/
Base_LampImpl::Base_LampImpl(PortableServer::POA_ptr poa, const ACE_CString &_name) :
    ACSComponentImpl(poa, _name)
{
    // ACS_TRACE is used for debugging purposes
    ACS_TRACE("::Base_LampImpl::Base_LampImpl");
}
/* ----------------------------------------------------------------*/
Base_LampImpl::~Base_LampImpl()
{
    // ACS_TRACE is used for debugging purposes
    ACS_TRACE("::Base_LampImpl::~Base_LampImpl");
    ACS_DEBUG_PARAM("::Base_LampImpl::~Base_LampImpl", "Destroying %s...", name());
}
/* --------------------- [ CORBA interface ] ----------------------*/
void 
Base_LampImpl::init ()
    throw (CORBA::SystemException)
{
    // ACS_TRACE is used for debugging purposes
    ACS_TRACE("::Base_LampImpl::~Base_LampImpl");
    ACS_DEBUG_PARAM("::Base_LampImpl::~Base_LampImpl", "Init %s...", name());
    cout << "Initialising Lamp "<< endl; 
}

void 
Base_LampImpl::on ()
    throw (CORBA::SystemException)
{
    cout << "ON Lamp"<< endl; 
}

void 
Base_LampImpl::off ()
    throw (CORBA::SystemException)
{
    cout << "OFF Lamp"<< endl; 
}

/* --------------- [ MACI DLL support functions ] -----------------*/
#include <maciACSComponentDefines.h>
MACI_DLL_SUPPORT_FUNCTIONS(Base_LampImpl)
/* ----------------------------------------------------------------*/


/*___oOo___*/


