#ifndef isabellaLampSmartLoopImpl_h
#define isabellaLampSmartLoopImpl_h
/*******************************************************************************
*    ALMA - Atacama Large Millimiter Array
*    (c) European Southern Observatory, 2002
*    Copyright by ESO (in the framework of the ALMA collaboration)
*    and Cosylab 2002, All rights reserved
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
*
* "@(#) $Id: acscourseMount2Impl.h,v 1.1 2004/01/28 11:20:01 bjeram Exp $"
*
*/

#ifndef __cplusplus
#error This is a C++ include file and cannot be used from plain C
#endif

#include <isabellasmartLampImpl.h>


/**
 *  POA_acsexmplHelloWorld::HelloWorld is obtained from this header file and is
 *  automatically generated from HelloWorld's Interface Definition File 
 *  (i.e., acsexmplHelloWorld.idl) by CORBA.
 */

/** @file acscourseMount2Impl.h
 */

/** @defgroup ACSCOURSEMOUNTDOC Mount2
 *  @{
 * @htmlonly
<hr size="2" width="100%">
<div align="left">
<h2>Description</h2>
The class Mount2 simulates the behaviour of an antenna interface.
&nbsp;It provides only one synchronous methods:
objfix(...). &nbsp;
<br>
<br>
<h2>What can I gain from this example?</h2>
<ul>
  <li>an example derived from the ACS::Component IDL interface.</li>
  <li>understanding of synchronous method implementation.</li>
</ul>
<br>
<br>
<h2>Links</h2>
<ul>
  <li><a href="classMount2.html">Mount2 Class Reference</a></li>
  <li><a href="interfaceMOUNT__ACS_1_1Mount2.html">Mount2 IDL Documentation</a></li>
  <li>Mount2 CDB XML Schema</li>
</ul>
</div>
 * @endhtmlonly
 * @}
 */

/** @class Mount2
 * The class Mount2 is a basic example of a component and simulates the behaviour of an antenna interface.
 * It provides one asynchronous methods: objfix.  The methods only writes the data into 
 * virtual properties.
 * @version "@(#) $Id: acscourseMount2Impl.h,v 1.1 2004/01/28 11:20:01 bjeram Exp $"
 */
class smart_LampLoopImpl: public smart_LampImpl
{
  public:
     /**
     * Constructor
     * @param poa Poa which will activate this and also all other components. 
     * @param name component's name. This is also the name that will be used to find the
     * configuration data for the component in the Configuration Database.
     */
    smart_LampLoopImpl(PortableServer::POA_ptr poa, const ACE_CString &name);
    
    /**
     * Destructor
     */
    virtual ~smart_LampLoopImpl();
    
    virtual void 
    on_async (const char *colour, 
              CORBA::Double brightness,
              ACS::CBdouble *completion,
              const ACS::CBDescIn &desc)
	throw (CORBA::SystemException);

     virtual ActionRequest 
     onAction (BACIComponent *cob_p, 
	       const int &callbackID,
	       const CBDescIn &descIn, 
	       BACIValue *value_p,
	       Completion &completion, 
	       CBDescOut &descOut);

     virtual ActionRequest 
     invokeAction (int function,
                   BACIComponent *cob_p, 
                   const int &callbackID, 
                   const CBDescIn &descIn, 
                   BACIValue *value_p, 
                   Completion &completion, 
                   CBDescOut &descOut);  
 

  private:

    ACS::CBdouble *cbID;
    ACS::CBDescIn  dsc;
    Completion     comp;
 
    BACIThread *thread;
 
    static void 
    brightnessControl(void *param_p);
    
    /**
     * ALMA C++ coding standards state copy operators should be disabled.
     */

    void operator=(const smart_LampImpl&);
};

#endif
