#ifndef isabellaLampSmartImpl_h
#define isabellaLampSmartImpl_h
/*******************************************************************************
*    ALMA - Atacama Large Millimiter Array
*    (c) European Southern Observatory, 2002
*    Copyright by ESO (in the framework of the ALMA collaboration)
*    and Cosylab 2002, All rights reserved
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
*
* "@(#) $Id: acscourseMount2Impl.h,v 1.1 2004/01/28 11:20:01 bjeram Exp $"
*
*/

#ifndef __cplusplus
#error This is a C++ include file and cannot be used from plain C
#endif

#include <baciCharacteristicComponentImpl.h>
#include <baciROdouble.h>
#include <baciRWdouble.h>
#include <baciROstring.h>


/**
 *  POA_acsexmplHelloWorld::HelloWorld is obtained from this header file and is
 *  automatically generated from HelloWorld's Interface Definition File 
 *  (i.e., acsexmplHelloWorld.idl) by CORBA.
 */
#include <isabellaLampS.h>

using namespace baci;


/** @file acscourseMount2Impl.h
 */

/** @defgroup ACSCOURSEMOUNTDOC Mount2
 *  @{
 * @htmlonly
<hr size="2" width="100%">
<div align="left">
<h2>Description</h2>
The class Mount2 simulates the behaviour of an antenna interface.
&nbsp;It provides only one synchronous methods:
objfix(...). &nbsp;
<br>
<br>
<h2>What can I gain from this example?</h2>
<ul>
  <li>an example derived from the ACS::Component IDL interface.</li>
  <li>understanding of synchronous method implementation.</li>
</ul>
<br>
<br>
<h2>Links</h2>
<ul>
  <li><a href="classMount2.html">Mount2 Class Reference</a></li>
  <li><a href="interfaceMOUNT__ACS_1_1Mount2.html">Mount2 IDL Documentation</a></li>
  <li>Mount2 CDB XML Schema</li>
</ul>
</div>
 * @endhtmlonly
 * @}
 */

/** @class Mount2
 * The class Mount2 is a basic example of a component and simulates the behaviour of an antenna interface.
 * It provides one asynchronous methods: objfix.  The methods only writes the data into 
 * virtual properties.
 * @version "@(#) $Id: acscourseMount2Impl.h,v 1.1 2004/01/28 11:20:01 bjeram Exp $"
 */
class smart_LampImpl: public virtual CharacteristicComponentImpl,
		      public virtual POA_ISABELLA_LAMP::smart_Lamp,
		      public ActionImplementator
{
  public:
     /**
     * Constructor
     * @param poa Poa which will activate this and also all other components. 
     * @param name component's name. This is also the name that will be used to find the
     * configuration data for the component in the Configuration Database.
     */
    smart_LampImpl(PortableServer::POA_ptr poa, const ACE_CString &name);
    
    /**
     * Destructor
     */
    virtual ~smart_LampImpl();
    
    /**
     * (Pre)sets a new non-moving position for the antenna.
     * The position coordinates are given in azimuth and elevation.
     * The actual az and elev values are written to the properties
     * cmdAz, cmdEl, actAz and actEl.
     *
     * @param az        position azimuth (degree)
     * @param elev      position elevation (degree)
     * @return void
     * @htmlonly
     * <br><hr>
     * @endhtmlonly
     */    
    virtual void 
    init ()
	throw (CORBA::SystemException);

    virtual void 
    on (const char *colour, CORBA::Double brightness)
	throw (CORBA::SystemException);


    virtual void 
    off ()
	throw (CORBA::SystemException);
      
    virtual ACS::ROdouble_ptr 
    state ()
	throw (CORBA::SystemException);

    virtual ACS::ROstring_ptr 
    colour ()
	throw (CORBA::SystemException);

    virtual ACS::RWdouble_ptr 
    brightness ()
	throw (CORBA::SystemException);
    

  protected:
    
    /**
     *  m_cmdAz_p is the antenna's commanded azimuth
     */
    ROdouble *m_state_p;

    /**
     *  m_cmdEl_p is the antenna's commanded elevation
     */
    ROstring *m_colour_p;

    /**
     *  m_actAz_p is the antenna's actual azimuth
     */
    RWdouble *m_brightness_p;


    void operator=(const smart_LampImpl&);
};

#endif
