/*******************************************************************************
*    ALMA - Atacama Large Millimiter Array
*    (c) European Southern Observatory, 2002
*    Copyright by ESO (in the framework of the ALMA collaboration)
*    and Cosylab 2002, All rights reserved
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
*
*
* "@(#) $Id: asmClientAlarm.cpp,v 1.88 2004/01/15 01:45:37 dfugate Exp $"
*
* who       when      what
* --------  --------  ----------------------------------------------
* david 2002-06-17 fixed client.init(argc,argv)
* naoj 2002-03-12 Added simulation of value changes of current
* gchiozzi 2002-02-13 Cleaned up and renamed
* gchiozzi 2002-01-23 Removed #define _POSIX_SOURCE 1. Gives problems on Solaris.
* almamgr 2002-01-22 Replaced old include files with new axsexmpl... files
* gchiozzi 2001-02-15 Merged: added tests for IFR and history.
* gchiozzi 2001-02-15 created standard header
* msekoran 2001-03-14 Changed namespace ESO to ACS 
* msekoran 2001-03-20 Added Alarmdouble (event) example
*/

#include <maciSimpleClient.h>
#include "asmCallback.h"
#include <acscourseAsmC.h>

ACE_RCSID(asmClient, asmClientAlarm, "$Id: asmClientAlarm.cpp,v 1.88 2004/01/15 01:45:37 dfugate Exp $")
using namespace maci;

/*----------------------------------------------------------------------------------------------
 *
 * Now onto the good stuff...
 */
int main(int argc, char *argv[]) 
{
    /*
     * Checks command line arguments.
     * We need:
     * - the name of the MOUNT device to get in touch with.
     * - the length of time the process it going to run
     * - the requested time intervalfor the monitor
     */
    if (argc < 4)
    {
        ACS_SHORT_LOG((LM_INFO, "Usage: %s <Component name> <length> <interval> <options>", argv[0]));
        return -1;
    }
    int length   = atoi(argv[2]);  // Time the client will stay logged in
    int interval = atoi(argv[3]);  // requested inteval for the monitor

    /*
     * Creates and initialyses the SimpleClient object
     */
    SimpleClient client;

    if (client.init(argc,argv) == 0)
    {
        ACE_DEBUG((LM_DEBUG,"Cannot init client"));
        return -1;
    }
    ACS_SHORT_LOG((LM_INFO, "Welcome to acsexmplClient!"));
    ACS_SHORT_LOG((LM_INFO, "Login into maciManager!"));
    client.login();



    try
    {
        ACS_SHORT_LOG((LM_INFO, "Getting COB: %s", argv[1]));
        CORBA::Object_var obj = client.get_object(argv[1], 0, true);

        if (!CORBA::is_nil(obj.in()))
        {
            ACSCOURSE_ASM::Asm2_var asmClient = ACSCOURSE_ASM::Asm2::_narrow(obj.in());
            if (CORBA::is_nil(asmClient.in())) 
            {
                ACS_SHORT_LOG((LM_INFO, "Failed to narrow Asm2 :-("));
                return 0;
            }
            ACS_SHORT_LOG((LM_INFO, "Asm2 narrowed."));

            /*
             * Get the reference to the  actTemp double property
             */
            ACS_SHORT_LOG((LM_INFO, "Trying to get actTemp... "));
            ACS::ROdouble_var actTemp = asmClient->actTemp();
            ACS_SHORT_LOG((LM_INFO, "OK"));

            if (actTemp.ptr() != ACS::ROdouble::_nil())
            {
                /*
                 * Get the current value of the property
                 */
                ACS::Completion_var completion;
                CORBA::Double val = actTemp->get_sync(completion.out());
                ACS_SHORT_LOG((LM_INFO,"Value: %f", val));


                ACS_SHORT_LOG((LM_INFO, "Trying to narrow CB for actTemp... "));
                MyCBdouble *mcb_p = new MyCBdouble("actTemp");
                ACS::CBdouble_var cb = mcb_p->_this(); 
                ACS_SHORT_LOG((LM_INFO, "OK"));

                ACS_SHORT_LOG((LM_INFO, "Trying to create monitor for actTemp..."));
                ACS::CBDescIn desc;
                ACS::Monitordouble_var md = actTemp->create_monitor(cb.in(), desc);
                if (md.ptr() != ACS::Monitordouble::_nil())
                {
                    ACS_SHORT_LOG((LM_INFO, "Set a %ds timer trigger for the monitor...", interval));
                    md->set_timer_trigger(interval*10000000);
                    ACS_SHORT_LOG((LM_INFO, "OK"));
                } 
                else
                {
                    ACS_SHORT_LOG((LM_INFO, "Failed"));
                }
                ACS_SHORT_LOG((LM_INFO, "Going in main loop for %ds...", length));
                ACE_Time_Value tv(length);
                client.run(tv);

                md->destroy();

            } /* end if property reference OK */
        } /* end if DO reference OK */
    } /* end main try section */
    catch(...)
    {
        ACE_ERROR((LM_ERROR,"Error!"));
    }

    /*
     * Another try section where we release our COB and logout from the Manager
     */
    try
    {
        ACS_SHORT_LOG((LM_INFO,"Releasing..."));
        client.manager()->release_component(client.handle(), argv[1]);  
        client.logout();
    }
    catch(...)
    {
        ACE_ERROR((LM_ERROR, "main"));
    }

    /*
     * sleep for 3 sec to allow everytihng to cleanup and stabilyse
     * so that the tests can be determinitstic.
     */
    ACE_OS::sleep(3);

    return 0;    
}

