/*******************************************************************************
*    ALMA - Atacama Large Millimiter Array
*    (c) Associated Universities Inc., 2002 *
*    (c) European Southern Observatory, 2002
*    Copyright by ESO (in the framework of the ALMA collaboration)
*    and Cosylab 2002, All rights reserved
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
*
*
* "@(#) $Id: acscourseAsm2LoopImpl.cpp,v 1.1 2004/01/28 11:38:34 bjeram Exp $"
*
*/
 
#include <acscourseAsm2LoopImpl.h>
const static int CTRL_INTERVAL  = 1;

/* ----------------------------------------------------------------*/
Asm2LoopImpl::Asm2LoopImpl(PortableServer::POA_ptr poa, const ACE_CString &_name) :
    CharacteristicComponentImpl(poa, _name),
    Asm2Impl(poa,_name)
{
    // ACS_TRACE is used for debugging purposes
    ACS_TRACE("::Asm2LoopImpl::Asm2LoopImpl");

    // Initialize control loop thread
    getComponent()->getThreadManager()->create("tempControl", 
					       (void *)	Asm2LoopImpl::tempControl, 
					       static_cast<void *>(this));

    ACS_SHORT_LOG((LM_INFO,"tempControl thread spawned.")); 
}

/* ----------------------------------------------------------------*/
Asm2LoopImpl::~Asm2LoopImpl()
{
    // ACS_TRACE is used for debugging purposes
    ACS_TRACE("::Asm2LoopImpl::~Asm2LoopImpl");
    ACS_DEBUG_PARAM("::Asm2LoopImpl::~Asm2LoopImpl", "Destroying %s...", name());
}


//
// Position control loop
// When the commanded position changes the actual position is moved to this
// new position.
//
void 
Asm2LoopImpl::tempControl (void *param_p) 
{
    
    if (param_p == 0) 
    {
        return;
    }


    ACS::Completion_var completion;

    //
    // TODO: Error/Exception handling
    // 

    BACIThreadParameter *baciParameter_p = static_cast<BACIThreadParameter *>(param_p);
    BACIThread *myself_p = baciParameter_p->getBACIThread();

    // The thread worker is a static method.
    // The instance comes with the param_p structure
    Asm2LoopImpl *mount_p = const_cast<Asm2LoopImpl *>(static_cast<const Asm2LoopImpl *>(baciParameter_p->getParameter()));

    ACS_SHORT_LOG((LM_INFO, "Starting Position control loop."));

    if (BACIThread::InitThread != 0) 
    {
        BACIThread::InitThread("tempControl");
    }

    int errcode;
    unsigned long long timestamp;

    // Control loop
    while(myself_p->check() == true)
    {
        if(myself_p->isSuspended() == false)
        {           
            double nbOfAveragedValues = mount_p->m_cmdNbOfAveragedValues_p->getDevIO()->read(errcode, timestamp);
            double actTemp = mount_p->m_actTemp_p->getDevIO()->read(errcode, timestamp);

            if (nbOfAveragedValues != actTemp)
            {
                // Simulated control
                ACS_SHORT_LOG((LM_INFO, "Set temperature to (%f)...", nbOfAveragedValues));
                mount_p->m_actTemp_p->getDevIO()->write(nbOfAveragedValues, errcode, timestamp);
            } 
            else 
            {
            }
            myself_p->sleep();
        }
        ACE_OS::sleep(CTRL_INTERVAL);
    }

    if (BACIThread::DoneThread != 0) 
    {
        BACIThread::DoneThread();
    }
    delete baciParameter_p;
    myself_p->setStopped();
    
}

void
Asm2Impl::setAverageValueAsync (CORBA::Double nbOfValues,
                                ACS::CBdouble_ptr callBack,
                                const ACS::CBDescIn &desc
                               )
    throw (CORBA::SystemException)
{
    Completion completion; 
    CBDescOut descOut;

    ACE_DEBUG((LM_DEBUG, "(Asm2Impl::setAverageValueAsync) %f\n",nbOfValues));
    // register the action in a queue so that control is returned immediately
    double *value = new double();
    *value=nbOfValues;

    callBack->working(1,completion, descOut);
    callBack->done(34,completion, descOut);
    
}


/* --------------- [ MACI DLL support functions ] -----------------*/
#include <maciACSComponentDefines.h>
MACI_DLL_SUPPORT_FUNCTIONS(Asm2LoopImpl)
/* ----------------------------------------------------------------*/

/*___oOo___*/


