#ifndef asmCallback_h
#define asmCallback_h
/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) Associated Universities Inc., 2004 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: asmCallback.h,v 1.2 2004/01/15 01:45:37 dfugate Exp $"
*
* who       when      what
* --------  --------  ----------------------------------------------
* dave  2004-01-13  created 
*/

#include <baciS.h>
#include <ace/SString.h>

class CommonCallback
{
  public:
    CommonCallback() {}
    
  protected:
    ACE_CString prop;
    
    unsigned int m_count;

  private:
    void operator=(const CommonCallback&);
};
//ClientAlarmThread 
//ClientAlarm
class MyAlarmdouble : public virtual POA_ACS::Alarmdouble, 
                      protected CommonCallback
{
  public:
    MyAlarmdouble(ACE_CString _prop) { prop = _prop; }
    
    void 
    alarm_raised (CORBA::Double value,
                  const ACS::Completion &c,
                  const ACS::CBDescOut &desc)
        throw (CORBA::SystemException);
        
    
    void 
    alarm_cleared (CORBA::Double value,
                   const ACS::Completion &c,
                   const ACS::CBDescOut &desc)
        throw (CORBA::SystemException);
        
    
    CORBA::Boolean 
    negotiate (ACS::TimeInterval time_to_transmit, const ACS::CBDescOut &desc) 
        throw (CORBA::SystemException)
        {
            return true;
        }

};
//ClientMonitor
//ClientGetAsync
//FridgeClient
//FridgeMonitorTemp
class MyCBdouble : public virtual POA_ACS::CBdouble, 
                   protected CommonCallback
{
   
  public:
    MyCBdouble(ACE_CString _prop)  { prop = _prop; m_count = 0; }
    
    void 
    working (CORBA::Double value, const ACS::Completion &c, const ACS::CBDescOut &desc)
        throw (CORBA::SystemException);
            
    void 
    done (CORBA::Double value, const ACS::Completion &c, const ACS::CBDescOut &desc)
        throw (CORBA::SystemException);
    
    CORBA::Boolean 
    negotiate (ACS::TimeInterval time_to_transmit, const ACS::CBDescOut &desc) 
        throw (CORBA::SystemException)
        {
            return true;
        }

};
//ClientWave
//DoorClient
class MyCBvoid: public virtual POA_ACS::CBvoid, 
                protected CommonCallback
{   
  public:
    MyCBvoid(ACE_CString _prop) { prop = _prop; }
    
    void 
    working (const ACS::Completion &c, const ACS::CBDescOut &desc) 
        throw (CORBA::SystemException);
    
    void 
    done (const ACS::Completion &c, const ACS::CBDescOut &desc) 
        throw (CORBA::SystemException);

    CORBA::Boolean 
    negotiate (ACS::TimeInterval time_to_transmit, const ACS::CBDescOut &desc) 
        throw (CORBA::SystemException)
        {
            return true;
        }
};

#endif
/*___oOo___*/
