#ifndef acscourseAsm2Impl_h
#define acscourseAsm2Impl_h
/*******************************************************************************
*    ALMA - Atacama Large Millimiter Array
*    (c) European Southern Observatory, 2002
*    Copyright by ESO (in the framework of the ALMA collaboration)
*    and Cosylab 2002, All rights reserved
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
*
* "@(#) $Id: acscourseAsm2Impl.h,v 1.1 2004/01/28 11:20:01 bjeram Exp $"
*
*/

#ifndef __cplusplus
#error This is a C++ include file and cannot be used from plain C
#endif

#include <baciCharacteristicComponentImpl.h>
#include <baciROdouble.h>
#include <baciRWdouble.h>

/**
 *  POA_acsexmplHelloWorld::HelloWorld is obtained from this header file and is
 *  automatically generated from HelloWorld's Interface Definition File 
 *  (i.e., acsexmplHelloWorld.idl) by CORBA.
 */
#include <acscourseAsmS.h>

using namespace baci;

/** @class Asm2
 * The class Asm2 is a basic example 
 */
class Asm2Impl: public virtual CharacteristicComponentImpl,
		  public virtual POA_ACSCOURSE_ASM::Asm2,
          public ActionImplementator
{
public:
    /**
     * Constructor
     * @param poa Poa which will activate this and also all other components. 
     * @param name component's name. This is also the name that will be used to find the
     * configuration data for the component in the Configuration Database.
     */
    Asm2Impl(PortableServer::POA_ptr poa, const ACE_CString &name);

    /**
     * Destructor
     */
    virtual ~Asm2Impl();

    virtual ActionRequest 
        invokeAction (int function,
                      BACIComponent *cob_p, 
                      const int &callbackID, 
                      const CBDescIn &descIn, 
                      BACIValue *value_p, 
                      Completion &completion, 
                      CBDescOut &descOut);

    virtual ActionRequest 
        setAverageValueAction (BACIComponent *cob_p, 
                               const int &callbackID,
                               const CBDescIn &descIn, 
                               BACIValue *value_p,
                               Completion &completion, 
                               CBDescOut &descOut);  

    void setAverageValue (CORBA::Double nbOfValues)
        throw (CORBA::SystemException);
    void setAverageValueAsync (CORBA::Double nbOfValues,
                               ACS::CBdouble_ptr callBack,
                               const ACS::CBDescIn &desc)
        throw (CORBA::SystemException);


    /**
     * Returns a reference to the cmdNbOfAveragedValues property
     * Implementation of IDL interface for the property.
     * @return pointer to read-only write property cmdNbOfAveragedValues
     * @htmlonly
     * <br><hr>
     * @endhtmlonly
     */
    virtual ACS::RWdouble_ptr 
        cmdNbOfAveragedValues ()
        throw (CORBA::SystemException);

    /**
     * Returns a reference to the actTemp property
     * Implementation of IDL interface for the property.
     * @return pointer to read-only double property actTemp
     * @htmlonly
     * <br><hr>
     * @endhtmlonly
     */   
    virtual ACS::ROdouble_ptr 
        actTemp ()
        throw (CORBA::SystemException);
    
  protected:
    
    RWdouble *m_cmdNbOfAveragedValues_p;
    ROdouble *m_actTemp_p;

    /**
     * ALMA C++ coding standards state copy operators should be disabled.
     */
    Asm2Impl& operator=(const Asm2Impl&);
    Asm2Impl (const Asm2Impl&);
};

#endif /*!acscourseAsm2Impl_H*/
