/*
 *    ALMA - Atacama Large Millimiter Array
 *   (c) Associated Universities Inc., 2002 
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 * MountConsumer.java
 *
 * Created on March 12, 2003, 2:33 PM
 */
////////////////////////////////////////////////////////////////////////////////
package alma.ACSVLT_MOUNT;
////////////////////////////////////////////////////////////////////////////////
import alma.acs.nc.Consumer;
import alma.ACSVLT_MOUNT.*;
////////////////////////////////////////////////////////////////////////////////
/** 
 * MountConsumer is a simple class that connects to the MOUNT_CHANNEL channel,
 * and prints events to standard out.
 * @author dfugate
 */
public class MountConsumer extends Consumer
{
    /** Creates a new instance of MountConsumer */
    public MountConsumer()
    {
        super(MOUNT_CHANNEL.value);
    }    
    ////////////////////////////////////////////////////////////////////////////
    /** 
     * <code>processEvent</code> <B>must</B> be overriden in Consumer subclasses to
     * do something useful.
     * 
     * @param corbaData CORBA data extracted from the event.
     */    
    public void processEvent(Object corbaData)
	{
	    //Cat to the correct type
	    MountEventData joe = (MountEventData)corbaData;

	    System.out.println("The commanded Az/El received by this consumer are:" + 
			       joe.Azimuth + 
			       "," + 
			       joe.Elevation);
	}
    ////////////////////////////////////////////////////////////////////////////
    /** Illustrates a simple example outside of the component/container model.
     * @param args Not used!
     */    
    public static void main(String[] args)
    {
        MountConsumer joe = new MountConsumer();
        try
        {
	    //Subscribe to an event type.
            joe.addSubscription(MountEventData.class);

            //After consumerReady() is invoked, processEvent(...) is invoked
            //by the channel.  That is, we have no control over when
            //that method is called.
            joe.consumerReady();

            System.out.println("Waiting for events...");
        }
        catch(Exception e)
        {
            System.err.println(e);
            joe.disconnect();
        }

        System.out.println("Done...");
	//This actually never exits because of a thread being spawned in the 
	//alma.acs.nc.Helper class.  To be cleaned-up later.
    }
    ////////////////////////////////////////////////////////////////////////////
}

