#!/usr/bin/env python
#*******************************************************************************
# ALMA - Atacama Large Millimiter Array
# (c) Associated Universities Inc., 2002 
# (c) European Southern Observatory, 2002
# Copyright by ESO (in the framework of the ALMA collaboration)
# and Cosylab 2002, All rights reserved
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
# MA 02111-1307  USA
#
# @(#) $Id: acspyexmplMountClient.py,v 1.5 2003/10/10 16:16:45 dfugate Exp $

from acspy.clients.simpleClient import PySimpleClient

simpleClient = PySimpleClient([])  #Make an instance of the PySimpleClient

try:
    mount  = simpleClient.getComponent("MOUNT2_LOOP")  #Get the Mount device

    actAzProperty = mount._get_actAz()         #Get the actAz property
    (azm, compl) = actAzProperty.get_sync()  #Get the current value of the property
    print "MOUNT actual azimuth: ", azm     
    
except Exception, e:
    print "Sorry, maybe there was no MOUNT object"
    print "The exception was:", e






