#!/usr/bin/env python
#*******************************************************************************
# ALMA - Atacama Large Millimiter Array
# (c) Associated Universities Inc., 2002 
# (c) European Southern Observatory, 2002
# Copyright by ESO (in the framework of the ALMA collaboration)
# and Cosylab 2002, All rights reserved
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
# MA 02111-1307  USA
#
# @(#) $Id: acspyexmplMountClient.py,v 1.5 2003/10/10 16:16:45 dfugate Exp $

from acspy.clients.simpleClient import PySimpleClient     # Import the acspy.PySimpleClient class
import MOUNT_ACS                       # Import the Python CORBA stubs for MOUNT
import ACS, ACS__POA                  # Import the Python CORBA stubs for BACI
from   omniORB.CORBA import TRUE, FALSE
from time import sleep

class MyMonitor(ACS__POA.CBdouble):
    '''This class defines method(s) that will be invoked asynchronously by the mount device'''
    #------------------------------------------------------------------------------
    def __init__ (self, propName = None): 
        if propName != None:
            self.propName = propName
        else:
            self.propName = "NoName"
    #------------------------------------------------------------------------------
    def __del__(self):
        '''Do nothing'''

    def working (self, value, completion, desc):
        '''
        Method that does all the real work.
        Parameters: value = the double we are interested in
                    completion = completion structure
                    desc = callback struct description
        '''
        print "Working: ", str(self.propName), " is ", str(value)
    #------------------------------------------------------------------------------
    def done (self, value, completion, desc):
        '''
        Invoked just before a monitor is destroyed.
        Parameters: value = the final value of the double we are interested in
                    completion = completion structure
                    desc = callback struct description
        '''
        print "Done: ", str(self.propName), " is ", str(value)

def negotiate (self, time_to_transmit, desc):
        '''For simplicities sake, we always return true. '''
        return TRUE
#------------------------------------------------------------------------------

simpleClient = PySimpleClient([])

try:
	mount = simpleClient.getComponent("MOUNT2_LOOP")  #Get the MOUNT1 Mount device
	actAzProperty = mount._get_actAz()  #Get the actAz property
	cbMon = MyMonitor("actAz")  #Create a callback monitor for the actAz Property
	cbMonServant = cbMon._this()  #Activate the callback monitor 
	desc = ACS.CBDescIn(0L, 0L, 0L)  #Create the real monitor registered with MOUNT1
	actMon = actAzProperty.create_monitor(cbMonServant, desc)
	actMon.set_timer_trigger(10000000)  #Working method gets invoked once per second
	sleep(10)  #Destroy the monitor after ten seconds
	actMon.destroy()

	# Release the component
	simpleClient.releaseComponent("MOUNT2_LOOP") 

except Exception, e:
    print "Sorry, I expected there to be a Mount in the system and"
    print "there isn't."
    print "The exception was:", e

