#ifndef acsVltMountImpl_h
#define acsVltMountImpl_h
/*******************************************************************************
*    ALMA - Atacama Large Millimiter Array
*    (c) European Southern Observatory, 2002
*    Copyright by ESO (in the framework of the ALMA collaboration)
*    and Cosylab 2002, All rights reserved
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
*
* "@(#) $Id: acsVltMountImpl.h,v 1.1 2004/01/28 11:20:01 bjeram Exp $"
*
*/

#ifndef __cplusplus
#error This is a C++ include file and cannot be used from plain C
#endif

#include <baciCharacteristicComponentImpl.h>
#include <baciROdouble.h>
#include <baciRWdouble.h>

/**
 *  POA_acsexmplHelloWorld::HelloWorld is obtained from this header file and is
 *  automatically generated from HelloWorld's Interface Definition File 
 *  (i.e., acsexmplHelloWorld.idl) by CORBA.
 */
#include <acsVltMountS.h>

#include <baciDevIO.h>

using namespace baci;


class DevIODBRead: public DevIO<CORBA::Double>
{
  public:

    DevIODBRead(char* dbAddr);
    virtual ~DevIODBRead(){}
    virtual bool initalizeValue() { return true; }
    double read(int& errcode, unsigned long long& timestamp);
    void write(const CORBA::Double &value, int& errcode, unsigned long long& timestamp);

  private:

    char m_dbAddr[256];
    double m_value;

    static BACIMutex m_dbAccessMutex;
};


/** @file acsVltMountImpl.h
 */

/** @defgroup ACSVLTMOUNTDOC Mount
 *  @{
 * @htmlonly
<hr size="2" width="100%">
<div align="left">
<h2>Description</h2>
The class Mount simulates the behaviour of an antenna interface.
&nbsp;It provides only one synchronous methods:
objfix(...). &nbsp;
<br>
<br>
<h2>What can I gain from this example?</h2>
<ul>
  <li>an example derived from the ACS::Component IDL interface.</li>
  <li>understanding of synchronous method implementation.</li>
</ul>
<br>
<br>
<h2>Links</h2>
<ul>
  <li><a href="classMount.html">Mount Class Reference</a></li>
  <li><a href="interfaceMOUNT__ACS_1_1Mount.html">Mount IDL Documentation</a></li>
  <li>Mount CDB XML Schema</li>
</ul>
</div>
 * @endhtmlonly
 * @}
 */

/** @class Mount
 * The class Mount is a basic example of a component and simulates the behaviour of an antenna interface.
 * It provides one asynchronous methods: objfix.  The methods only writes the data into 
 * virtual properties.
 * @version "@(#) $Id: acsVltMountImpl.h,v 1.1 2004/01/28 11:20:01 bjeram Exp $"
 */
class MountImpl: public virtual CharacteristicComponentImpl,
		  public virtual POA_ACSVLT_MOUNT::Mount
{
  public:
     /**
     * Constructor
     * @param poa Poa which will activate this and also all other components. 
     * @param name component's name. This is also the name that will be used to find the
     * configuration data for the component in the Configuration Database.
     */
    MountImpl(PortableServer::POA_ptr poa, const ACE_CString &name);
    
    /**
     * Destructor
     */
    virtual ~MountImpl();
    
    /**
     * (Pre)sets a new non-moving position for the antenna.
     * The position coordinates are given in azimuth and elevation.
     * The actual az and elev values are written to the properties
     * cmdAz, cmdEl, actAz and actEl.
     *
     * @param az        position azimuth (degree)
     * @param elev      position elevation (degree)
     * @return void
     * @htmlonly
     * <br><hr>
     * @endhtmlonly
     */    
    virtual void 
    objfix (CORBA::Double az,
	    CORBA::Double elev)
	throw (CORBA::SystemException);

    /**
     * Returns a reference to the cmdAz property
     * Implementation of IDL interface for the property.
     * @return pointer to read-write double property cmdAz
     * @htmlonly
     * <br><hr>
     * @endhtmlonly
     */ 
    virtual ACS::RWdouble_ptr 
    cmdAz ()
	throw (CORBA::SystemException);
    
    /**
     * Returns a reference to the cmdEl property
     * Implementation of IDL interface for the property.
     * @return pointer to read-only write property cmdEl
     * @htmlonly
     * <br><hr>
     * @endhtmlonly
     */
    virtual ACS::RWdouble_ptr 
    cmdEl ()
	throw (CORBA::SystemException);
    
    /**
     * Returns a reference to the actAzSpeed property
     * Implementation of IDL interface for the property.
     * @return pointer to read-only double property actAzSpeed
     * @htmlonly
     * <br><hr>
     * @endhtmlonly
     */   
    virtual ACS::ROdouble_ptr 
    actAzSpeed ()
	throw (CORBA::SystemException);
    
 
    /**
     * Returns a reference to the actAz property
     * Implementation of IDL interface for the property.
     * @return pointer to read-only double property actAz
     * @htmlonly
     * <br><hr>
     * @endhtmlonly
     */   
    virtual ACS::ROdouble_ptr 
    actAz ()
	throw (CORBA::SystemException);
    
    /**
     * Returns a reference to the actEl property
     * Implementation of IDL interface for the property.
     * @return pointer to read-only double property actEl
     * @htmlonly
     * <br><hr>
     * @endhtmlonly
     */    
    virtual ACS::ROdouble_ptr 
    actEl ()
	throw (CORBA::SystemException);
    

  protected:
    
    /**
     *  m_cmdAz_p is the antenna's commanded azimuth
     */
    RWdouble *m_cmdAz_p;

    /**
     *  m_cmdEl_p is the antenna's commanded elevation
     */
    RWdouble *m_cmdEl_p;

    /**
     *  m_actAz_p is the antenna's actual azimuth
     */
    ROdouble *m_actAz_p;

    /**
     *  m_actAzSpeed_p is the antenna's actual azimuth speed
     */
    ROdouble *m_actAzSpeed_p;

    /**
     *  m_actEl_p is the antenna's actual elevation
     */
    ROdouble *m_actEl_p;

    /**
     * ALMA C++ coding standards state copy operators should be disabled.
     */
    void operator=(const MountImpl&);
};

#endif /*!acsVltMountImpl_H*/



