/*
* Copyright (C) The Community OpenORB Project. All rights reserved.
*
* This software is published under the terms of The OpenORB Community Software
* License version 1.0, a copy of which has been included with this distribution
* in the LICENSE.txt file.
*/
package org.openorb.messaging;

import org.omg.Messaging.RELATIVE_REQ_TIMEOUT_POLICY_TYPE;
import org.omg.Messaging.RELATIVE_RT_TIMEOUT_POLICY_TYPE;
import org.omg.Messaging.REPLY_END_TIME_POLICY_TYPE;
import org.omg.Messaging.REPLY_START_TIME_POLICY_TYPE;
import org.omg.Messaging.REQUEST_END_TIME_POLICY_TYPE;
import org.omg.Messaging.REQUEST_START_TIME_POLICY_TYPE;
import org.omg.Messaging.RelativeRoundtripTimeoutPolicy;
import org.omg.Messaging.SYNC_SCOPE_POLICY_TYPE;
import org.omg.Messaging.SyncScopeHelper;
import org.omg.Messaging.SyncScopePolicy;

/**
 *
 * @author Chris Wood
 * @version $Revision: 1.9 $ $Date: 2002/07/14 19:12:36 $ 
 */
class PolicyFactoryImpl
    extends org.omg.CORBA.LocalObject
    implements org.omg.PortableInterceptor.PolicyFactory
{

    /** Creates new PolicyFactory */
    private PolicyFactoryImpl()
    {
    }

    private static PolicyFactoryImpl s_instance = null;

    static PolicyFactoryImpl getInstance()
    {
        if ( s_instance == null )
            s_instance = new PolicyFactoryImpl();

        return s_instance;
    }

    public org.omg.CORBA.Policy create_policy( int type, org.omg.CORBA.Any value )
        throws org.omg.CORBA.PolicyError
    {
        switch ( type )
        {

        case SYNC_SCOPE_POLICY_TYPE.value:
            if ( !value.type().equal( SyncScopeHelper.type() ) )
                throw new org.omg.CORBA.PolicyError( org.omg.CORBA.BAD_POLICY_TYPE.value );
            return new SyncScopePolicyImpl( SyncScopeHelper.extract( value ) );

        case RELATIVE_REQ_TIMEOUT_POLICY_TYPE.value:
            if ( !value.type().equal( org.omg.TimeBase.TimeTHelper.type() ) )
                throw new org.omg.CORBA.PolicyError( org.omg.CORBA.BAD_POLICY_TYPE.value );
            throw new org.omg.CORBA.NO_IMPLEMENT();

        case RELATIVE_RT_TIMEOUT_POLICY_TYPE.value:
            if ( !value.type().equal( org.omg.TimeBase.TimeTHelper.type() ) )
                throw new org.omg.CORBA.PolicyError( org.omg.CORBA.BAD_POLICY_TYPE.value );
            return new RelativeRoundtripTimeoutPolicyImpl(
                    org.omg.TimeBase.TimeTHelper.extract( value ) );

        case REPLY_END_TIME_POLICY_TYPE.value:
            if ( !value.type().equal( org.omg.TimeBase.UtcTHelper.type() ) )
                throw new org.omg.CORBA.PolicyError( org.omg.CORBA.BAD_POLICY_TYPE.value );

        case REPLY_START_TIME_POLICY_TYPE.value:
            if ( !value.type().equal( org.omg.TimeBase.UtcTHelper.type() ) )
                throw new org.omg.CORBA.PolicyError( org.omg.CORBA.BAD_POLICY_TYPE.value );

        case REQUEST_END_TIME_POLICY_TYPE.value:
            if ( !value.type().equal( org.omg.TimeBase.UtcTHelper.type() ) )
                throw new org.omg.CORBA.PolicyError( org.omg.CORBA.BAD_POLICY_TYPE.value );

        case REQUEST_START_TIME_POLICY_TYPE.value:
            if ( !value.type().equal( org.omg.TimeBase.UtcTHelper.type() ) )
                throw new org.omg.CORBA.PolicyError( org.omg.CORBA.BAD_POLICY_TYPE.value );
            throw new org.omg.CORBA.NO_IMPLEMENT();

        default:
            throw new org.omg.CORBA.PolicyError( org.omg.CORBA.BAD_POLICY.value );
        }
    }

    // Messaging: SyncScopePolicy

    private static class SyncScopePolicyImpl
                extends org.omg.CORBA.LocalObject
                implements SyncScopePolicy
    {
        SyncScopePolicyImpl( short val )
        {
            this.m_sync_scope = val;
        }

        private short m_sync_scope;
        public short synchronization()
        {
            return m_sync_scope;
        }

        public void destroy()
        {
        }

        public org.omg.CORBA.Policy copy()
        {
            return this;
        }

        public int policy_type()
        {
            return SYNC_SCOPE_POLICY_TYPE.value;
        }
    }

    private static SyncScopePolicyImpl [] s_pol_sync_scope = null;

    // Messaging: Timeout

    private static class RelativeRoundtripTimeoutPolicyImpl
                extends org.omg.CORBA.LocalObject
                implements RelativeRoundtripTimeoutPolicy
    {
        RelativeRoundtripTimeoutPolicyImpl( long val )
        {
            this.m_relative_expiry = val;
        }

        private long m_relative_expiry;

        public long relative_expiry()
        {
            return m_relative_expiry;
        }

        public void destroy()
        {
        }

        public org.omg.CORBA.Policy copy()
        {
            return this;
        }

        public int policy_type()
        {
            return RELATIVE_RT_TIMEOUT_POLICY_TYPE.value;
        }
    }

    private static RelativeRoundtripTimeoutPolicyImpl [] s_pol_rel_rt_timeout = null;
}

