/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Routine;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.types.Type;

public class Grantee
implements SchemaObject {
    boolean isRole;
    private boolean isAdminDirect = false;
    private boolean isAdmin = false;
    boolean isSchemaCreator = false;
    boolean isPublic = false;
    boolean isSystem = false;
    protected HsqlNameManager.HsqlName granteeName;
    private MultiValueHashMap directRightsMap;
    private HashMap fullRightsMap = new HashMap();
    OrderedHashSet roles;
    private MultiValueHashMap grantedRightsMap;
    protected GranteeManager granteeManager;
    protected Right ownerRights;

    Grantee(HsqlNameManager.HsqlName hsqlName, GranteeManager granteeManager) {
        this.directRightsMap = new MultiValueHashMap();
        this.grantedRightsMap = new MultiValueHashMap();
        this.granteeName = hsqlName;
        this.granteeManager = granteeManager;
        this.roles = new OrderedHashSet();
        this.ownerRights = new Right();
        this.ownerRights.isFull = true;
        this.ownerRights.grantor = GranteeManager.systemAuthorisation;
        this.ownerRights.grantee = this;
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.granteeName;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return null;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return null;
    }

    @Override
    public Grantee getOwner() {
        return null;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE").append(' ').append("ROLE");
        stringBuffer.append(' ').append(this.granteeName.statementName);
        return stringBuffer.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public String getNameString() {
        return this.granteeName.name;
    }

    public String getStatementName() {
        return this.granteeName.statementName;
    }

    public boolean isRole() {
        return this.isRole;
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public MultiValueHashMap getRights() {
        return this.directRightsMap;
    }

    public void grant(Grantee grantee) {
        this.roles.add(grantee);
    }

    public void revoke(Grantee grantee) {
        if (!this.hasRoleDirect(grantee)) {
            throw Error.error(2253, grantee.getNameString());
        }
        this.roles.remove(grantee);
    }

    public OrderedHashSet getDirectRoles() {
        return this.roles;
    }

    String getAllRolesAsString() {
        return this.roleMapToString(this.getAllRoles());
    }

    public String getDirectRolesAsString() {
        return this.roleMapToString(this.roles);
    }

    public String roleMapToString(OrderedHashSet orderedHashSet) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            Grantee grantee = (Grantee)orderedHashSet.get(i);
            stringBuffer.append(grantee.getStatementName());
        }
        return stringBuffer.toString();
    }

    public OrderedHashSet getAllRoles() {
        OrderedHashSet orderedHashSet = this.getGranteeAndAllRoles();
        orderedHashSet.remove(this);
        return orderedHashSet;
    }

    public OrderedHashSet getGranteeAndAllRoles() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        this.addGranteeAndRoles(orderedHashSet);
        return orderedHashSet;
    }

    public OrderedHashSet getGranteeAndAllRolesWithPublic() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        this.addGranteeAndRoles(orderedHashSet);
        orderedHashSet.add(this.granteeManager.publicRole);
        return orderedHashSet;
    }

    private OrderedHashSet addGranteeAndRoles(OrderedHashSet orderedHashSet) {
        orderedHashSet.add(this);
        for (int i = 0; i < this.roles.size(); ++i) {
            Grantee grantee = (Grantee)this.roles.get(i);
            if (orderedHashSet.contains(grantee)) continue;
            grantee.addGranteeAndRoles(orderedHashSet);
        }
        return orderedHashSet;
    }

    public void addAllRoles(HashMap hashMap) {
        for (int i = 0; i < this.roles.size(); ++i) {
            Grantee grantee = (Grantee)this.roles.get(i);
            hashMap.put(grantee.granteeName.name, grantee.roles);
        }
    }

    public boolean hasRoleDirect(Grantee grantee) {
        return this.roles.contains(grantee);
    }

    public boolean hasRole(Grantee grantee) {
        return this.getAllRoles().contains(grantee);
    }

    void grant(HsqlNameManager.HsqlName hsqlName, Right right, Grantee grantee, boolean bl) {
        Right right2 = grantee.getAllGrantableRights(hsqlName);
        Right right3 = null;
        if (right == Right.fullRights) {
            if (right2.isEmpty()) {
                return;
            }
            right = right2;
        } else if (!right2.contains(right)) {
            throw Error.error(2000);
        }
        Iterator iterator = this.directRightsMap.get(hsqlName);
        while (iterator.hasNext()) {
            Right right4 = (Right)iterator.next();
            if (right4.grantor != grantee) continue;
            right3 = right4;
            right3.add(right);
            break;
        }
        if (right3 == null) {
            right3 = right.duplicate();
            right3.grantor = grantee;
            right3.grantee = this;
            this.directRightsMap.put(hsqlName, right3);
        }
        if (bl) {
            if (right3.grantableRights == null) {
                right3.grantableRights = right.duplicate();
            } else {
                right3.grantableRights.add(right);
            }
        }
        if (!grantee.isSystem) {
            grantee.grantedRightsMap.put(hsqlName, right3);
        }
        this.updateAllRights();
    }

    void revoke(SchemaObject schemaObject, Right right, Grantee grantee, boolean bl) {
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        Iterator iterator = this.directRightsMap.get(hsqlName);
        Right right2 = null;
        while (iterator.hasNext()) {
            right2 = (Right)iterator.next();
            if (right2.grantor != grantee) continue;
        }
        if (right2 == null) {
            return;
        }
        if (right2.grantableRights != null) {
            right2.grantableRights.remove(schemaObject, right);
        }
        if (bl) {
            return;
        }
        if (right.isFull) {
            this.directRightsMap.remove(hsqlName, right2);
            grantee.grantedRightsMap.remove(hsqlName, right2);
            this.updateAllRights();
            return;
        }
        right2.remove(schemaObject, right);
        if (right2.isEmpty()) {
            this.directRightsMap.remove(hsqlName, right2);
            grantee.grantedRightsMap.remove(hsqlName, right2);
        }
        this.updateAllRights();
    }

    void revokeDbObject(HsqlNameManager.HsqlName hsqlName) {
        this.directRightsMap.remove(hsqlName);
        this.grantedRightsMap.remove(hsqlName);
        this.fullRightsMap.remove(hsqlName);
    }

    void clearPrivileges() {
        this.roles.clear();
        this.directRightsMap.clear();
        this.grantedRightsMap.clear();
        this.fullRightsMap.clear();
        this.isAdmin = false;
    }

    public OrderedHashSet getColumnsForAllPrivileges(Table table) {
        if (this.isFullyAccessibleByRole(table.getName())) {
            return table.getColumnNameSet();
        }
        Right right = (Right)this.fullRightsMap.get(table.getName());
        return right == null ? Right.emptySet : right.getColumnsForAllRights(table);
    }

    public OrderedHashSet getAllDirectPrivileges(SchemaObject schemaObject) {
        if (schemaObject.getOwner() == this) {
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            orderedHashSet.add(this.ownerRights);
            return orderedHashSet;
        }
        Iterator iterator = this.directRightsMap.get(schemaObject.getName());
        if (iterator.hasNext()) {
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            while (iterator.hasNext()) {
                orderedHashSet.add(iterator.next());
            }
            return orderedHashSet;
        }
        return Right.emptySet;
    }

    public OrderedHashSet getAllGrantedPrivileges(SchemaObject schemaObject) {
        Iterator iterator = this.grantedRightsMap.get(schemaObject.getName());
        if (iterator.hasNext()) {
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            while (iterator.hasNext()) {
                orderedHashSet.add(iterator.next());
            }
            return orderedHashSet;
        }
        return Right.emptySet;
    }

    public void checkSelect(Table table, boolean[] blArray) {
        if (this.isFullyAccessibleByRole(table.getName())) {
            return;
        }
        Right right = (Right)this.fullRightsMap.get(table.getName());
        if (right != null && right.canSelect(table, blArray)) {
            return;
        }
        throw Error.error(5501, table.getName().name);
    }

    public void checkInsert(Table table, boolean[] blArray) {
        if (this.isFullyAccessibleByRole(table.getName())) {
            return;
        }
        Right right = (Right)this.fullRightsMap.get(table.getName());
        if (right != null && right.canInsert(table, blArray)) {
            return;
        }
        throw Error.error(5501, table.getName().name);
    }

    public void checkUpdate(Table table, boolean[] blArray) {
        if (this.isFullyAccessibleByRole(table.getName())) {
            return;
        }
        Right right = (Right)this.fullRightsMap.get(table.getName());
        if (right != null && right.canUpdate(table, blArray)) {
            return;
        }
        throw Error.error(5501, table.getName().name);
    }

    public void checkReferences(Table table, boolean[] blArray) {
        if (this.isFullyAccessibleByRole(table.getName())) {
            return;
        }
        Right right = (Right)this.fullRightsMap.get(table.getName());
        if (right != null && right.canReference(table, blArray)) {
            return;
        }
        throw Error.error(5501, table.getName().name);
    }

    public void checkTrigger(Table table, boolean[] blArray) {
        if (this.isFullyAccessibleByRole(table.getName())) {
            return;
        }
        Right right = (Right)this.fullRightsMap.get(table.getName());
        if (right != null && right.canReference(table, blArray)) {
            return;
        }
        throw Error.error(5501, table.getName().name);
    }

    public void checkDelete(Table table) {
        if (this.isFullyAccessibleByRole(table.getName())) {
            return;
        }
        Right right = (Right)this.fullRightsMap.get(table.getName());
        if (right != null && right.canDelete()) {
            return;
        }
        throw Error.error(5501, table.getName().name);
    }

    public void checkAccess(SchemaObject schemaObject) {
        Right right;
        if (this.isFullyAccessibleByRole(schemaObject.getName())) {
            return;
        }
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        if ((right = (Right)this.fullRightsMap.get(hsqlName)) != null && !right.isEmpty()) {
            return;
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public void checkSchemaUpdateOrGrantRights(String string) {
        if (!this.hasSchemaUpdateOrGrantRights(string)) {
            throw Error.error(5501, string);
        }
    }

    public boolean hasSchemaUpdateOrGrantRights(String string) {
        if (this.isAdmin()) {
            return true;
        }
        Grantee grantee = this.granteeManager.database.schemaManager.toSchemaOwner(string);
        if (grantee == this) {
            return true;
        }
        return this.hasRole(grantee);
    }

    public boolean isGrantable(SchemaObject schemaObject, Right right) {
        if (this.isFullyAccessibleByRole(schemaObject.getName())) {
            return true;
        }
        Right right2 = this.getAllGrantableRights(schemaObject.getName());
        return right2.contains(right);
    }

    public boolean isGrantable(Grantee grantee) {
        return this.isAdmin;
    }

    public boolean isFullyAccessibleByRole(HsqlNameManager.HsqlName hsqlName) {
        if (this.isAdmin) {
            return true;
        }
        if (hsqlName.schema == null) {
            return false;
        }
        Grantee grantee = hsqlName.schema.owner;
        if (grantee == this) {
            return true;
        }
        return this.hasRole(grantee);
    }

    public void checkAdmin() {
        if (!this.isAdmin()) {
            throw Error.error(5507);
        }
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public boolean isSchemaCreator() {
        return this.isAdmin || this.hasRole(this.granteeManager.schemaRole);
    }

    public boolean canChangeAuthorisation() {
        return this.isAdmin || this.hasRole(this.granteeManager.changeAuthRole);
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    void setAdminDirect() {
        this.isAdminDirect = true;
        this.isAdmin = true;
    }

    boolean updateNestedRoles(Grantee grantee) {
        boolean bl = false;
        if (grantee != this) {
            for (int i = 0; i < this.roles.size(); ++i) {
                Grantee grantee2 = (Grantee)this.roles.get(i);
                bl |= grantee2.updateNestedRoles(grantee);
            }
        }
        if (bl) {
            this.updateAllRights();
        }
        return bl || grantee == this;
    }

    void updateAllRights() {
        this.fullRightsMap.clear();
        this.isAdmin = this.isAdminDirect;
        for (int i = 0; i < this.roles.size(); ++i) {
            Grantee grantee = (Grantee)this.roles.get(i);
            this.addToFullRights(grantee.fullRightsMap);
            this.isAdmin |= grantee.isAdmin();
        }
        this.addToFullRights(this.directRightsMap);
        if (!(this.isRole || this.isPublic || this.isSystem)) {
            this.addToFullRights(this.granteeManager.publicRole.fullRightsMap);
        }
    }

    void addToFullRights(HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Right right = (Right)hashMap.get(object);
            Right right2 = (Right)this.fullRightsMap.get(object);
            if (right2 == null) {
                right2 = right.duplicate();
                this.fullRightsMap.put(object, right2);
            } else {
                right2.add(right);
            }
            if (right.grantableRights == null) continue;
            if (right2.grantableRights == null) {
                right2.grantableRights = right.grantableRights.duplicate();
                continue;
            }
            right2.grantableRights.add(right.grantableRights);
        }
    }

    void addToFullRights(MultiValueHashMap multiValueHashMap) {
        Iterator iterator = multiValueHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Iterator iterator2 = multiValueHashMap.get(object);
            Right right = (Right)this.fullRightsMap.get(object);
            while (iterator2.hasNext()) {
                Right right2 = (Right)iterator2.next();
                if (right == null) {
                    right = right2.duplicate();
                    this.fullRightsMap.put(object, right);
                } else {
                    right.add(right2);
                }
                if (right2.grantableRights == null) continue;
                if (right.grantableRights == null) {
                    right.grantableRights = right2.grantableRights.duplicate();
                    continue;
                }
                right.grantableRights.add(right2.grantableRights);
            }
        }
    }

    public Set visibleGrantees() {
        HashSet hashSet = new HashSet();
        GranteeManager granteeManager = this.granteeManager;
        if (this.isAdmin()) {
            hashSet.addAll(granteeManager.getGrantees());
        } else {
            hashSet.add(this);
            Iterator iterator = this.getAllRoles().iterator();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
        }
        return hashSet;
    }

    public Set nonReservedVisibleGrantees(boolean bl) {
        Set set = this.visibleGrantees();
        GranteeManager granteeManager = this.granteeManager;
        set.remove(granteeManager.dbaRole);
        set.remove(GranteeManager.systemAuthorisation);
        if (!bl) {
            set.remove(granteeManager.publicRole);
        }
        return set;
    }

    public boolean hasNonSelectTableRight(Table table) {
        if (this.isFullyAccessibleByRole(table.getName())) {
            return true;
        }
        Right right = (Right)this.fullRightsMap.get(table.getName());
        if (right == null) {
            return false;
        }
        return right.isFull || right.isFullDelete || right.isFullInsert || right.isFullUpdate || right.isFullReferences || right.isFullTrigger;
    }

    public boolean hasTableRight(Table table) {
        if (this.isFullyAccessibleByRole(table.getName())) {
            return true;
        }
        Right right = (Right)this.fullRightsMap.get(table.getName());
        if (right == null) {
            return false;
        }
        return right.isFull || right.isFullDelete || right.isFullInsert || right.isFullUpdate || right.isFullReferences || right.isFullTrigger || right.isFullSelect;
    }

    public Iterator getAllDirectFullRights(SchemaObject schemaObject) {
        Grantee grantee = schemaObject.getOwner();
        if (grantee == this) {
            return new WrapperIterator(this.ownerRights);
        }
        return this.directRightsMap.get(schemaObject.getName());
    }

    public Right getAllGrantableRights(HsqlNameManager.HsqlName hsqlName) {
        if (this.isAdmin) {
            return hsqlName.schema.owner.ownerRights;
        }
        if (hsqlName.schema.owner == this) {
            return this.ownerRights;
        }
        if (this.roles.contains(hsqlName.schema.owner)) {
            return hsqlName.schema.owner.ownerRights;
        }
        OrderedHashSet orderedHashSet = this.getAllRoles();
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            Grantee grantee = (Grantee)orderedHashSet.get(i);
            if (hsqlName.schema.owner != grantee) continue;
            return grantee.ownerRights;
        }
        Right right = (Right)this.fullRightsMap.get(hsqlName);
        return right == null || right.grantableRights == null ? Right.noRights : right.grantableRights;
    }

    public boolean isAccessible(HsqlNameManager.HsqlName hsqlName, int n) {
        if (this.isFullyAccessibleByRole(hsqlName)) {
            return true;
        }
        Right right = (Right)this.fullRightsMap.get(hsqlName);
        if (right == null) {
            return false;
        }
        return right.canAccess(n);
    }

    public boolean isAccessible(SchemaObject schemaObject) {
        return this.isAccessible(schemaObject.getName());
    }

    public boolean isAccessible(HsqlNameManager.HsqlName hsqlName) {
        if (this.isFullyAccessibleByRole(hsqlName)) {
            return true;
        }
        Right right = (Right)this.fullRightsMap.get(hsqlName);
        if (right != null && !right.isEmpty()) {
            return true;
        }
        if (!this.isPublic) {
            return this.granteeManager.publicRole.isAccessible(hsqlName);
        }
        return false;
    }

    public HsqlArrayList getRightsSQL() {
        Object object;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        String string = this.getDirectRolesAsString();
        if (string.length() != 0) {
            object = new StringBuffer(128);
            ((StringBuffer)object).append("GRANT").append(' ').append(string);
            ((StringBuffer)object).append(' ').append("TO").append(' ');
            ((StringBuffer)object).append(this.getStatementName());
            hsqlArrayList.add(((StringBuffer)object).toString());
        }
        object = this.getRights();
        Iterator iterator = ((MultiValueHashMap)object).keySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            Iterator iterator2 = ((MultiValueHashMap)object).get(object2);
            while (iterator2.hasNext()) {
                Right right = (Right)iterator2.next();
                StringBuffer stringBuffer = new StringBuffer(128);
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)object2;
                switch (hsqlName.type) {
                    case 3: 
                    case 4: {
                        Table table = this.granteeManager.database.schemaManager.findUserTable(null, hsqlName.name, hsqlName.schema.name);
                        if (table == null) break;
                        stringBuffer.append("GRANT").append(' ');
                        stringBuffer.append(right.getTableRightsSQL(table));
                        stringBuffer.append(' ').append("ON").append(' ');
                        stringBuffer.append("TABLE").append(' ');
                        stringBuffer.append(hsqlName.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 7: {
                        NumberSequence numberSequence = (NumberSequence)this.granteeManager.database.schemaManager.findSchemaObject(hsqlName.name, hsqlName.schema.name, 7);
                        if (numberSequence == null) break;
                        stringBuffer.append("GRANT").append(' ');
                        stringBuffer.append("USAGE");
                        stringBuffer.append(' ').append("ON").append(' ');
                        stringBuffer.append("SEQUENCE").append(' ');
                        stringBuffer.append(hsqlName.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 13: {
                        Type type = (Type)this.granteeManager.database.schemaManager.findSchemaObject(hsqlName.name, hsqlName.schema.name, 13);
                        if (type == null) break;
                        stringBuffer.append("GRANT").append(' ');
                        stringBuffer.append("USAGE");
                        stringBuffer.append(' ').append("ON").append(' ');
                        stringBuffer.append("DOMAIN").append(' ');
                        stringBuffer.append(hsqlName.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 12: {
                        Type type = (Type)this.granteeManager.database.schemaManager.findSchemaObject(hsqlName.name, hsqlName.schema.name, 13);
                        if (type == null) break;
                        stringBuffer.append("GRANT").append(' ');
                        stringBuffer.append("USAGE");
                        stringBuffer.append(' ').append("ON").append(' ');
                        stringBuffer.append("TYPE").append(' ');
                        stringBuffer.append(hsqlName.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 16: 
                    case 17: 
                    case 24: {
                        SchemaObject schemaObject = this.granteeManager.database.schemaManager.findSchemaObject(hsqlName.name, hsqlName.schema.name, hsqlName.type);
                        if (schemaObject == null) break;
                        stringBuffer.append("GRANT").append(' ');
                        stringBuffer.append("EXECUTE").append(' ');
                        stringBuffer.append("ON").append(' ');
                        stringBuffer.append("SPECIFIC").append(' ');
                        if (schemaObject.getType() == 17) {
                            stringBuffer.append("PROCEDURE");
                        } else {
                            stringBuffer.append("FUNCTION");
                        }
                        stringBuffer.append(' ');
                        stringBuffer.append(hsqlName.getSchemaQualifiedStatementName());
                    }
                }
                if (stringBuffer.length() == 0) continue;
                stringBuffer.append(' ').append("TO").append(' ');
                stringBuffer.append(this.getStatementName());
                hsqlArrayList.add(stringBuffer.toString());
            }
        }
        return hsqlArrayList;
    }
}

