/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.LineGroupReader;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.persist.LobStore;
import org.hsqldb.persist.LobStoreInJar;
import org.hsqldb.persist.LobStoreMem;
import org.hsqldb.persist.LobStoreRAFile;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;

public class LobManager {
    static final String resourceFileName = "/org/hsqldb/resources/lob-schema.sql";
    static final String[] starters = new String[]{"/*"};
    Database database;
    LobStore lobStore;
    Session sysLobSession;
    int lobBlockSize;
    int totalBlockLimitCount = Integer.MAX_VALUE;
    int deletedLobCount;
    Statement getLob;
    Statement getLobPart;
    Statement deleteLobCall;
    Statement deleteLobPartCall;
    Statement divideLobPartCall;
    Statement createLob;
    Statement createLobPartCall;
    Statement updateLobLength;
    Statement updateLobUsage;
    Statement getNextLobId;
    Statement deleteUnusedLobs;
    Statement getLobCount;
    private static String initialiseBlocksSQL = "INSERT INTO SYSTEM_LOBS.BLOCKS VALUES(?,?,?)";
    private static String getLobSQL = "SELECT * FROM SYSTEM_LOBS.LOB_IDS WHERE LOB_ID = ?";
    private static String getLobPartSQL = "SELECT * FROM SYSTEM_LOBS.LOBS WHERE LOB_ID = ? AND BLOCK_OFFSET + BLOCK_COUNT > ? AND BLOCK_OFFSET < ? ORDER BY BLOCK_OFFSET";
    private static String deleteLobPartCallSQL = "CALL SYSTEM_LOBS.DELETE_BLOCKS(?,?,?,?)";
    private static String createLobSQL = "INSERT INTO SYSTEM_LOBS.LOB_IDS VALUES(?, ?, ?, ?)";
    private static String updateLobLengthSQL = "UPDATE SYSTEM_LOBS.LOB_IDS SET LOB_LENGTH = ? WHERE LOB_ID = ?";
    private static String createLobPartCallSQL = "CALL SYSTEM_LOBS.ALLOC_BLOCKS(?, ?, ?)";
    private static String divideLobPartCallSQL = "CALL SYSTEM_LOBS.DIVIDE_BLOCK(?, ?)";
    private static String getSpanningBlockSQL = "SELECT * FROM SYSTEM_LOBS.LOBS WHERE LOB_ID = ? AND ? > BLOCK_OFFSET AND ? < BLOCK_OFFSET + BLOCK_COUNT";
    private static String updateLobUsageSQL = "UPDATE SYSTEM_LOBS.LOB_IDS SET LOB_USAGE_COUNT = ? WHERE LOB_ID = ?";
    private static String getNextLobIdSQL = "VALUES NEXT VALUE FOR SYSTEM_LOBS.LOB_ID";
    private static String deleteLobCallSQL = "CALL SYSTEM_LOBS.DELETE_LOB(?, ?)";
    private static String deleteUnusedCallSQL = "CALL SYSTEM_LOBS.DELETE_UNUSED()";
    private static String getLobCountSQL = "SELECT COUNT(*) FROM SYSTEM_LOBS.LOB_IDS";

    public LobManager(Database database) {
        this.database = database;
    }

    public synchronized void createSchema() {
        this.sysLobSession = this.database.sessionManager.getSysLobSession();
        InputStream inputStream = this.getClass().getResourceAsStream(resourceFileName);
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "ISO-8859-1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        LineGroupReader lineGroupReader = new LineGroupReader(lineNumberReader, starters);
        HashMappedList hashMappedList = lineGroupReader.getAsMap();
        lineGroupReader.close();
        String string = (String)hashMappedList.get("/*lob_schema_definition*/");
        Statement statement = this.sysLobSession.compileStatement(string, 0);
        Result result = statement.execute(this.sysLobSession);
        if (result.isError()) {
            throw result.getException();
        }
        HsqlNameManager.HsqlName hsqlName = this.database.schemaManager.getSchemaHsqlName("SYSTEM_LOBS");
        Table table = this.database.schemaManager.getTable(this.sysLobSession, "BLOCKS", "SYSTEM_LOBS");
        this.getLob = this.sysLobSession.compileStatement(getLobSQL, 0);
        this.getLobPart = this.sysLobSession.compileStatement(getLobPartSQL, 0);
        this.createLob = this.sysLobSession.compileStatement(createLobSQL, 0);
        this.createLobPartCall = this.sysLobSession.compileStatement(createLobPartCallSQL, 0);
        this.divideLobPartCall = this.sysLobSession.compileStatement(divideLobPartCallSQL, 0);
        this.deleteLobCall = this.sysLobSession.compileStatement(deleteLobCallSQL, 0);
        this.deleteLobPartCall = this.sysLobSession.compileStatement(deleteLobPartCallSQL, 0);
        this.updateLobLength = this.sysLobSession.compileStatement(updateLobLengthSQL, 0);
        this.updateLobUsage = this.sysLobSession.compileStatement(updateLobUsageSQL, 0);
        this.getNextLobId = this.sysLobSession.compileStatement(getNextLobIdSQL, 0);
        this.deleteUnusedLobs = this.sysLobSession.compileStatement(deleteUnusedCallSQL, 0);
        this.getLobCount = this.sysLobSession.compileStatement(getLobCountSQL, 0);
    }

    public synchronized void initialiseLobSpace() {
        Statement statement = this.sysLobSession.compileStatement(initialiseBlocksSQL, 0);
        Object[] objectArray = new Object[]{ValuePool.INTEGER_0, ValuePool.getInt(this.totalBlockLimitCount), ValuePool.getLong(0L)};
        this.sysLobSession.executeCompiledStatement(statement, objectArray);
    }

    public synchronized void open() {
        this.lobBlockSize = this.database.logger.getLobBlockSize();
        this.lobStore = this.database.getType() == "res:" ? new LobStoreInJar(this.database, this.lobBlockSize) : (this.database.getType() == "file:" ? new LobStoreRAFile(this.database, this.lobBlockSize) : new LobStoreMem(this.lobBlockSize));
    }

    public synchronized void close() {
        this.lobStore.close();
    }

    LobStore getLobStore() {
        if (this.lobStore == null) {
            this.open();
        }
        return this.lobStore;
    }

    private long getNewLobID() {
        Result result = this.getNextLobId.execute(this.sysLobSession);
        if (result.isError()) {
            return 0L;
        }
        RowSetNavigator rowSetNavigator = result.getNavigator();
        boolean bl = rowSetNavigator.next();
        if (!bl) {
            rowSetNavigator.close();
            return 0L;
        }
        Object[] objectArray = rowSetNavigator.getCurrent();
        return (Long)objectArray[0];
    }

    private Object[] getLobHeader(long l) {
        ResultMetaData resultMetaData = this.getLob.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l);
        this.sysLobSession.sessionContext.pushDynamicArguments(objectArray);
        Result result = this.getLob.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        if (result.isError()) {
            return null;
        }
        RowSetNavigator rowSetNavigator = result.getNavigator();
        boolean bl = rowSetNavigator.next();
        if (!bl) {
            rowSetNavigator.close();
            return null;
        }
        Object[] objectArray2 = rowSetNavigator.getCurrent();
        return objectArray2;
    }

    public synchronized BlobData getBlob(long l) {
        Object[] objectArray = this.getLobHeader(l);
        if (objectArray == null) {
            return null;
        }
        BlobDataID blobDataID = new BlobDataID(l);
        return blobDataID;
    }

    public synchronized ClobData getClob(long l) {
        Object[] objectArray = this.getLobHeader(l);
        if (objectArray == null) {
            return null;
        }
        ClobDataID clobDataID = new ClobDataID(l);
        return clobDataID;
    }

    public synchronized long createBlob(long l) {
        long l2 = this.getNewLobID();
        ResultMetaData resultMetaData = this.createLob.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l2);
        objectArray[1] = ValuePool.getLong(l);
        objectArray[2] = ValuePool.INTEGER_0;
        objectArray[3] = ValuePool.getInt(30);
        Result result = this.sysLobSession.executeCompiledStatement(this.createLob, objectArray);
        return l2;
    }

    public synchronized long createClob(long l) {
        long l2 = this.getNewLobID();
        ResultMetaData resultMetaData = this.createLob.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l2);
        objectArray[1] = ValuePool.getLong(l);
        objectArray[2] = ValuePool.INTEGER_0;
        objectArray[3] = ValuePool.getInt(40);
        Result result = this.sysLobSession.executeCompiledStatement(this.createLob, objectArray);
        return l2;
    }

    public synchronized Result deleteLob(long l) {
        ResultMetaData resultMetaData = this.deleteLobCall.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l);
        objectArray[1] = ValuePool.getLong(0L);
        Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobCall, objectArray);
        return result;
    }

    public synchronized Result deleteUnusedLobs() {
        Result result = this.sysLobSession.executeCompiledStatement(this.deleteUnusedLobs, ValuePool.emptyObjectArray);
        this.deletedLobCount = 0;
        return result;
    }

    public synchronized Result getLength(long l) {
        try {
            Object[] objectArray = this.getLobHeader(l);
            if (objectArray == null) {
                throw Error.error(3474);
            }
            long l2 = (Long)objectArray[1];
            int n = (Integer)objectArray[3];
            return ResultLob.newLobSetResponse(l, l2);
        }
        catch (HsqlException hsqlException) {
            return Result.newErrorResult(hsqlException);
        }
    }

    public synchronized int compare(BlobData blobData, byte[] byArray) {
        Object[] objectArray = this.getLobHeader(blobData.getId());
        long l = (Long)objectArray[1];
        int[][] nArray = this.getBlockAddresses(blobData.getId(), 0, Integer.MAX_VALUE);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        do {
            int n4 = nArray[n][0] + n3;
            byte[] byArray2 = this.getLobStore().getBlockBytes(n4, 1);
            for (int i = 0; i < byArray2.length; ++i) {
                if (n2 + i >= byArray.length) {
                    if (l == (long)byArray.length) {
                        return 0;
                    }
                    return 1;
                }
                if (byArray2[i] == byArray[n2 + i]) continue;
                return (byArray2[i] & 0xFF) > (byArray[n2 + i] & 0xFF) ? 1 : -1;
            }
            n2 += this.lobBlockSize;
            if (++n3 != nArray[n][1]) continue;
            n3 = 0;
            ++n;
        } while (n != nArray.length);
        return -1;
    }

    public synchronized int compare(BlobData blobData, BlobData blobData2) {
        if (blobData.getId() == blobData2.getId()) {
            return 0;
        }
        Object[] objectArray = this.getLobHeader(blobData.getId());
        if (objectArray == null) {
            return 1;
        }
        long l = (Long)objectArray[1];
        objectArray = this.getLobHeader(blobData2.getId());
        if (objectArray == null) {
            return -1;
        }
        long l2 = (Long)objectArray[1];
        if (l > l2) {
            return 1;
        }
        if (l < l2) {
            return -1;
        }
        return this.compareBytes(blobData.getId(), blobData2.getId());
    }

    public synchronized int compare(ClobData clobData, String string) {
        Object[] objectArray = this.getLobHeader(clobData.getId());
        long l = (Long)objectArray[1];
        int[][] nArray = this.getBlockAddresses(clobData.getId(), 0, Integer.MAX_VALUE);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        do {
            String string2;
            int n4;
            int n5 = nArray[n][0] + n3;
            byte[] byArray = this.getLobStore().getBlockBytes(n5, 1);
            long l2 = l - (long)((nArray[n][2] + n3) * this.lobBlockSize / 2);
            if (l2 > (long)(this.lobBlockSize / 2)) {
                l2 = this.lobBlockSize / 2;
            }
            String string3 = new String(ArrayUtil.byteArrayToChars(byArray), 0, (int)l2);
            int n6 = string.length() - n2;
            if (n6 > this.lobBlockSize / 2) {
                n6 = this.lobBlockSize / 2;
            }
            if ((n4 = this.database.collation.compare(string3, string2 = string.substring(n2, n2 + n6))) != 0) {
                return n4;
            }
            n2 += this.lobBlockSize / 2;
            if (++n3 != nArray[n][1]) continue;
            n3 = 0;
            ++n;
        } while (n != nArray.length);
        return 0;
    }

    public synchronized int compare(ClobData clobData, ClobData clobData2) {
        if (clobData.getId() == clobData2.getId()) {
            return 0;
        }
        return this.compareText(clobData.getId(), clobData2.getId());
    }

    synchronized int compareBytes(long l, long l2) {
        int[][] nArray = this.getBlockAddresses(l, 0, Integer.MAX_VALUE);
        int[][] nArray2 = this.getBlockAddresses(l2, 0, Integer.MAX_VALUE);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        do {
            int n5 = nArray[n][0] + n3;
            int n6 = nArray2[n2][0] + n4;
            byte[] byArray = this.getLobStore().getBlockBytes(n5, 1);
            byte[] byArray2 = this.getLobStore().getBlockBytes(n6, 1);
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return (byArray[i] & 0xFF) > (byArray2[i] & 0xFF) ? 1 : -1;
            }
            ++n4;
            if (++n3 == nArray[n][1]) {
                n3 = 0;
                ++n;
            }
            if (n4 != nArray2[n2][1]) continue;
            n4 = 0;
            ++n2;
        } while (n != nArray.length);
        return 0;
    }

    synchronized int compareText(long l, long l2) {
        Object[] objectArray = this.getLobHeader(l);
        long l3 = (Long)objectArray[1];
        objectArray = this.getLobHeader(l2);
        long l4 = (Long)objectArray[1];
        int[][] nArray = this.getBlockAddresses(l, 0, Integer.MAX_VALUE);
        int[][] nArray2 = this.getBlockAddresses(l2, 0, Integer.MAX_VALUE);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        do {
            String string;
            String string2;
            int n5;
            long l5;
            int n6 = nArray[n][0] + n3;
            int n7 = nArray2[n2][0] + n4;
            byte[] byArray = this.getLobStore().getBlockBytes(n6, 1);
            byte[] byArray2 = this.getLobStore().getBlockBytes(n7, 1);
            long l6 = l3 - (long)((nArray[n][2] + n3) * this.lobBlockSize / 2);
            if (l6 > (long)(this.lobBlockSize / 2)) {
                l6 = this.lobBlockSize / 2;
            }
            if ((l5 = l4 - (long)((nArray2[n2][2] + n4) * this.lobBlockSize / 2)) > (long)(this.lobBlockSize / 2)) {
                l5 = this.lobBlockSize / 2;
            }
            if ((n5 = this.database.collation.compare(string2 = new String(ArrayUtil.byteArrayToChars(byArray), 0, (int)l6), string = new String(ArrayUtil.byteArrayToChars(byArray2), 0, (int)l5))) != 0) {
                return n5;
            }
            ++n4;
            if (++n3 == nArray[n][1]) {
                n3 = 0;
                ++n;
            }
            if (n4 != nArray2[n2][1]) continue;
            n4 = 0;
            ++n2;
        } while (n != nArray.length);
        return 0;
    }

    public synchronized Result getLob(long l, long l2, long l3) {
        throw Error.runtimeError(201, "LobManager");
    }

    public synchronized Result createDuplicateLob(long l) {
        long l2;
        Object[] objectArray = this.getLobHeader(l);
        if (objectArray == null) {
            return Result.newErrorResult(Error.error(3474));
        }
        long l3 = this.getNewLobID();
        Object[] objectArray2 = new Object[objectArray.length];
        objectArray2[0] = ValuePool.getLong(l3);
        objectArray2[1] = objectArray[1];
        objectArray2[2] = objectArray[2];
        objectArray2[3] = objectArray[3];
        Result result = this.sysLobSession.executeCompiledStatement(this.createLob, objectArray2);
        if (result.isError()) {
            return result;
        }
        long l4 = l2 = ((Long)objectArray[1]).longValue();
        int n = (Integer)objectArray[1];
        if (n == 40) {
            l4 *= 2L;
        }
        int n2 = (int)l4 / this.lobBlockSize;
        if (l4 % (long)this.lobBlockSize != 0L) {
            ++n2;
        }
        this.createBlockAddresses(l3, 0, n2);
        int[][] nArray = this.getBlockAddresses(l, 0, Integer.MAX_VALUE);
        int[][] nArray2 = this.getBlockAddresses(l3, 0, Integer.MAX_VALUE);
        try {
            this.copyBlockSet(nArray, nArray2);
        }
        catch (HsqlException hsqlException) {
            return Result.newErrorResult(hsqlException);
        }
        return ResultLob.newLobSetResponse(l3, l2);
    }

    private void copyBlockSet(int[][] nArray, int[][] nArray2) {
        int n = 0;
        int n2 = 0;
        do {
            int n3 = nArray[n][2] + n;
            int n4 = nArray2[n2][2] + n2;
            byte[] byArray = this.getLobStore().getBlockBytes(n3, 1);
            this.getLobStore().setBlockBytes(byArray, n4, 1);
            ++n4;
            if (++n3 == nArray[n][1]) {
                n3 = 0;
                ++n;
            }
            if (n4 != nArray2[n][1]) continue;
            n4 = 0;
            ++n2;
        } while (n != nArray.length);
    }

    public synchronized Result getChars(long l, long l2, int n) {
        Result result = this.getBytes(l, l2 * 2L, n * 2);
        if (result.isError()) {
            return result;
        }
        byte[] byArray = ((ResultLob)result).getByteArray();
        char[] cArray = ArrayUtil.byteArrayToChars(byArray);
        return ResultLob.newLobGetCharsResponse(l, l2, cArray);
    }

    public synchronized Result getBytes(long l, long l2, int n) {
        byte[] byArray;
        int n2 = (int)(l2 / (long)this.lobBlockSize);
        int n3 = (int)(l2 % (long)this.lobBlockSize);
        int n4 = (int)((l2 + (long)n) / (long)this.lobBlockSize);
        int n5 = (int)((l2 + (long)n) % (long)this.lobBlockSize);
        if (n5 == 0) {
            n5 = this.lobBlockSize;
        } else {
            ++n4;
        }
        int n6 = 0;
        byte[] byArray2 = new byte[n];
        int[][] nArray = this.getBlockAddresses(l, n2, n4);
        if (nArray.length == 0) {
            return Result.newErrorResult(Error.error(3474));
        }
        int n7 = 0;
        int n8 = nArray[n7][1] + nArray[n7][2] - n2;
        if (nArray[n7][1] + nArray[n7][2] > n4) {
            n8 -= nArray[n7][1] + nArray[n7][2] - n4;
        }
        try {
            byArray = this.getLobStore().getBlockBytes(nArray[n7][0] + n2, n8);
        }
        catch (HsqlException hsqlException) {
            return Result.newErrorResult(hsqlException);
        }
        int n9 = this.lobBlockSize * n8 - n3;
        if (n9 > n) {
            n9 = n;
        }
        System.arraycopy(byArray, n3, byArray2, n6, n9);
        n6 += n9;
        ++n7;
        while (n7 < nArray.length && n6 < n) {
            n8 = nArray[n7][1];
            if (nArray[n7][1] + nArray[n7][2] > n4) {
                n8 -= nArray[n7][1] + nArray[n7][2] - n4;
            }
            try {
                byArray = this.getLobStore().getBlockBytes(nArray[n7][0], n8);
            }
            catch (HsqlException hsqlException) {
                return Result.newErrorResult(hsqlException);
            }
            n9 = this.lobBlockSize * n8;
            if (n9 > n - n6) {
                n9 = n - n6;
            }
            System.arraycopy(byArray, 0, byArray2, n6, n9);
            n6 += n9;
            ++n7;
        }
        return ResultLob.newLobGetBytesResponse(l, l2, byArray2);
    }

    public synchronized Result setBytesBA(long l, byte[] byArray, long l2, int n) {
        int n2;
        int n3 = (int)(l2 / (long)this.lobBlockSize);
        int n4 = (int)(l2 % (long)this.lobBlockSize);
        int n5 = (int)((l2 + (long)n) / (long)this.lobBlockSize);
        int n6 = (int)((l2 + (long)n) % (long)this.lobBlockSize);
        if (n6 == 0) {
            n6 = this.lobBlockSize;
        } else {
            ++n5;
        }
        int[][] nArray = this.getBlockAddresses(l, n3, n5);
        byte[] byArray2 = new byte[(n5 - n3) * this.lobBlockSize];
        if (nArray.length > 0) {
            n2 = nArray[0][0] + (n3 - nArray[0][2]);
            try {
                byte[] byArray3 = this.getLobStore().getBlockBytes(n2, 1);
                System.arraycopy(byArray3, 0, byArray2, 0, this.lobBlockSize);
                if (nArray.length > 1) {
                    n2 = nArray[nArray.length - 1][0] + (n5 - nArray[nArray.length - 1][2] - 1);
                    byArray3 = this.getLobStore().getBlockBytes(n2, 1);
                    System.arraycopy(byArray3, 0, byArray2, n5 - n3 - 1, this.lobBlockSize);
                } else if (n5 - n3 > 1) {
                    n2 = nArray[0][0] + (n5 - nArray[0][2] - 1);
                    byArray3 = this.getLobStore().getBlockBytes(n2, 1);
                    System.arraycopy(byArray3, 0, byArray2, (n5 - n3 - 1) * this.lobBlockSize, this.lobBlockSize);
                }
            }
            catch (HsqlException hsqlException) {
                return Result.newErrorResult(hsqlException);
            }
            this.divideBlockAddresses(l, n3);
            this.divideBlockAddresses(l, n5);
            this.deleteBlockAddresses(l, n3, n5);
        }
        this.createBlockAddresses(l, n3, n5 - n3);
        System.arraycopy(byArray, 0, byArray2, n4, n);
        nArray = this.getBlockAddresses(l, n3, n5);
        try {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                this.getLobStore().setBlockBytes(byArray2, nArray[n2][0], nArray[n2][1]);
            }
        }
        catch (HsqlException hsqlException) {
            return Result.newErrorResult(hsqlException);
        }
        return ResultLob.newLobSetResponse(l, 0L);
    }

    private Result setBytesIS(long l, InputStream inputStream, long l2) {
        int n = (int)(l2 / (long)this.lobBlockSize);
        int n2 = (int)(l2 % (long)this.lobBlockSize);
        if (n2 == 0) {
            n2 = this.lobBlockSize;
        } else {
            ++n;
        }
        this.createBlockAddresses(l, 0, n);
        int[][] nArray = this.getBlockAddresses(l, 0, n);
        byte[] byArray = new byte[this.lobBlockSize];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i][1]; ++j) {
                int n3;
                int n4 = this.lobBlockSize;
                if (i == nArray.length - 1 && j == nArray[i][1] - 1) {
                    for (n3 = n4 = n2; n3 < this.lobBlockSize; ++n3) {
                        byArray[n3] = 0;
                    }
                }
                try {
                    n3 = 0;
                    while (n4 > 0) {
                        int n5 = inputStream.read(byArray, n3, n4);
                        if (n5 == -1) {
                            return Result.newErrorResult(new EOFException());
                        }
                        n4 -= n5;
                        n3 += n5;
                    }
                }
                catch (IOException iOException) {
                    return Result.newErrorResult(iOException);
                }
                try {
                    this.getLobStore().setBlockBytes(byArray, nArray[i][0] + j, 1);
                    continue;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException);
                }
            }
        }
        return ResultLob.newLobSetResponse(l, 0L);
    }

    public synchronized Result setBytes(long l, byte[] byArray, long l2) {
        if (byArray.length == 0) {
            return ResultLob.newLobSetResponse(l, 0L);
        }
        Object[] objectArray = this.getLobHeader(l);
        if (objectArray == null) {
            return Result.newErrorResult(Error.error(3474));
        }
        long l3 = (Long)objectArray[1];
        Result result = this.setBytesBA(l, byArray, l2, byArray.length);
        if (l2 + (long)byArray.length > l3) {
            this.setLength(l, l2 + (long)byArray.length);
        }
        return result;
    }

    public synchronized Result setBytesForNewBlob(long l, InputStream inputStream, long l2) {
        if (l2 == 0L) {
            return ResultLob.newLobSetResponse(l, 0L);
        }
        Result result = this.setBytesIS(l, inputStream, l2);
        return result;
    }

    public synchronized Result setChars(long l, long l2, char[] cArray) {
        if (cArray.length == 0) {
            return ResultLob.newLobSetResponse(l, 0L);
        }
        Object[] objectArray = this.getLobHeader(l);
        if (objectArray == null) {
            return Result.newErrorResult(Error.error(3474));
        }
        long l3 = (Long)objectArray[1];
        byte[] byArray = ArrayUtil.charArrayToBytes(cArray);
        Result result = this.setBytesBA(l, byArray, l2 * 2L, cArray.length * 2);
        if (result.isError()) {
            return result;
        }
        if (l2 + (long)cArray.length > l3 && (result = this.setLength(l, l2 + (long)cArray.length)).isError()) {
            return result;
        }
        return ResultLob.newLobSetResponse(l, 0L);
    }

    public synchronized Result setCharsForNewClob(long l, InputStream inputStream, long l2) {
        if (l2 == 0L) {
            return ResultLob.newLobSetResponse(l, 0L);
        }
        Result result = this.setBytesIS(l, inputStream, l2 * 2L);
        if (result.isError()) {
            return result;
        }
        return ResultLob.newLobSetResponse(l, 0L);
    }

    public synchronized Result truncate(long l, long l2) {
        Object[] objectArray = this.getLobHeader(l);
        if (objectArray == null) {
            return Result.newErrorResult(Error.error(3474));
        }
        long l3 = (Long)objectArray[1];
        int n = (int)(l2 / (long)this.lobBlockSize);
        ResultMetaData resultMetaData = this.deleteLobPartCall.getParametersMetaData();
        Object[] objectArray2 = new Object[resultMetaData.getColumnCount()];
        objectArray2[0] = ValuePool.getLong(l);
        objectArray2[1] = new Integer(n);
        objectArray2[2] = new Integer(Integer.MAX_VALUE);
        objectArray2[3] = ValuePool.getLong(this.sysLobSession.getTransactionTimestamp());
        Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobPartCall, objectArray2);
        this.setLength(l, l2);
        return ResultLob.newLobTruncateResponse(l);
    }

    synchronized Result setLength(long l, long l2) {
        ResultMetaData resultMetaData = this.updateLobLength.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l2);
        objectArray[1] = ValuePool.getLong(l);
        Result result = this.sysLobSession.executeCompiledStatement(this.updateLobLength, objectArray);
        return result;
    }

    public synchronized Result adjustUsageCount(long l, int n) {
        Object[] objectArray = this.getLobHeader(l);
        int n2 = ((Number)objectArray[2]).intValue();
        if (n2 + n == 0) {
            ++this.deletedLobCount;
        }
        ResultMetaData resultMetaData = this.updateLobUsage.getParametersMetaData();
        Object[] objectArray2 = new Object[resultMetaData.getColumnCount()];
        objectArray2[0] = ValuePool.getInt(n2 + n);
        objectArray2[1] = ValuePool.getLong(l);
        this.sysLobSession.sessionContext.pushDynamicArguments(objectArray2);
        Result result = this.updateLobUsage.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        return result;
    }

    private int[][] getBlockAddresses(long l, int n, int n2) {
        ResultMetaData resultMetaData = this.getLobPart.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l);
        objectArray[1] = ValuePool.getInt(n);
        objectArray[2] = ValuePool.getInt(n2);
        this.sysLobSession.sessionContext.pushDynamicArguments(objectArray);
        Result result = this.getLobPart.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        RowSetNavigator rowSetNavigator = result.getNavigator();
        int n3 = rowSetNavigator.getSize();
        int[][] nArray = new int[n3][3];
        for (int i = 0; i < n3; ++i) {
            rowSetNavigator.absolute(i);
            Object[] objectArray2 = rowSetNavigator.getCurrent();
            nArray[i][0] = (Integer)objectArray2[0];
            nArray[i][1] = (Integer)objectArray2[1];
            nArray[i][2] = (Integer)objectArray2[2];
        }
        rowSetNavigator.close();
        return nArray;
    }

    private void deleteBlockAddresses(long l, int n, int n2) {
        ResultMetaData resultMetaData = this.deleteLobPartCall.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l);
        objectArray[1] = ValuePool.getInt(n);
        objectArray[2] = ValuePool.getInt(n2);
        objectArray[3] = ValuePool.getLong(this.sysLobSession.getTransactionTimestamp());
        Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobPartCall, objectArray);
    }

    private void divideBlockAddresses(long l, int n) {
        ResultMetaData resultMetaData = this.divideLobPartCall.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getInt(n);
        objectArray[1] = ValuePool.getLong(l);
        Result result = this.sysLobSession.executeCompiledStatement(this.divideLobPartCall, objectArray);
    }

    private void createBlockAddresses(long l, int n, int n2) {
        ResultMetaData resultMetaData = this.createLobPartCall.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getInt(n2);
        objectArray[1] = ValuePool.getInt(n);
        objectArray[2] = ValuePool.getLong(l);
        Result result = this.sysLobSession.executeCompiledStatement(this.createLobPartCall, objectArray);
    }

    public synchronized int getLobCount() {
        this.sysLobSession.sessionContext.pushDynamicArguments(new Object[0]);
        Result result = this.getLobCount.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        RowSetNavigator rowSetNavigator = result.getNavigator();
        boolean bl = rowSetNavigator.next();
        if (!bl) {
            rowSetNavigator.close();
            return 0;
        }
        Object[] objectArray = rowSetNavigator.getCurrent();
        return ((Number)objectArray[0]).intValue();
    }

    private static interface UPDATE_LENGTH {
        public static final int LOB_LENGTH = 0;
        public static final int LOB_ID = 1;
    }

    private static interface UPDATE_USAGE {
        public static final int BLOCK_COUNT = 0;
        public static final int LOB_ID = 1;
    }

    private static interface ALLOC_BLOCKS {
        public static final int BLOCK_COUNT = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int LOB_ID = 2;
    }

    private static interface DELETE_BLOCKS {
        public static final int LOB_ID = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int BLOCK_LIMIT = 2;
        public static final int TX_ID = 3;
    }

    private static interface DIVIDE_BLOCK {
        public static final int BLOCK_OFFSET = 0;
        public static final int LOB_ID = 1;
    }

    private static interface GET_LOB_PART {
        public static final int LOB_ID = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int BLOCK_LIMIT = 2;
    }

    private static interface LOB_IDS {
        public static final int LOB_ID = 0;
        public static final int LOB_LENGTH = 1;
        public static final int LOB_USAGE_COUNT = 2;
        public static final int LOB_TYPE = 3;
    }

    private static interface LOBS {
        public static final int BLOCK_ADDR = 0;
        public static final int BLOCK_COUNT = 1;
        public static final int BLOCK_OFFSET = 2;
        public static final int LOB_ID = 3;
    }
}

