/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.types.Type;

public class ExpressionColumn
extends Expression {
    public static final ExpressionColumn[] emptyArray = new ExpressionColumn[0];
    ColumnSchema column;
    String schema;
    String tableName;
    String columnName;
    RangeVariable rangeVariable;
    NumberSequence sequence;
    boolean isWritable;
    boolean isParam;
    boolean strictReference;

    ExpressionColumn(String string, String string2, String string3, boolean bl) {
        super(2);
        this.schema = string;
        this.tableName = string2;
        this.columnName = string3;
        this.strictReference = bl;
    }

    ExpressionColumn(ColumnSchema columnSchema) {
        super(2);
        this.column = columnSchema;
        this.dataType = columnSchema.getDataType();
        this.columnName = columnSchema.getName().name;
    }

    ExpressionColumn(RangeVariable rangeVariable, int n) {
        super(2);
        this.columnIndex = n;
        this.setAutoAttributesAsColumn(rangeVariable, this.columnIndex);
    }

    ExpressionColumn(Expression expression, int n, int n2) {
        super(5);
        this.dataType = expression.dataType;
        this.columnIndex = n;
        this.alias = expression.alias;
        this.rangePosition = n2;
    }

    ExpressionColumn() {
        super(9);
    }

    ExpressionColumn(int n) {
        super(n);
        if (n == 8) {
            this.isParam = true;
        }
    }

    ExpressionColumn(Expression[] expressionArray, String string) {
        super(3);
        this.nodes = expressionArray;
        this.columnName = string;
    }

    ExpressionColumn(String string, String string2) {
        super(97);
        this.schema = string;
        this.tableName = string2;
    }

    ExpressionColumn(NumberSequence numberSequence) {
        super(10);
        this.sequence = numberSequence;
        this.dataType = numberSequence.getDataType();
    }

    void setAutoAttributesAsColumn(RangeVariable rangeVariable, int n) {
        this.columnIndex = n;
        this.column = rangeVariable.getColumn(n);
        this.dataType = this.column.getDataType();
        this.columnName = rangeVariable.getColumnAlias(n);
        this.tableName = rangeVariable.getTableAlias();
        this.rangeVariable = rangeVariable;
        this.rangeVariable.addColumn(this.columnIndex);
    }

    void setAttributesAsColumn(RangeVariable rangeVariable, int n) {
        if (rangeVariable.variables != null) {
            this.columnIndex = n;
            this.column = rangeVariable.getColumn(n);
            this.dataType = this.column.getDataType();
            this.rangeVariable = rangeVariable;
        } else {
            this.columnIndex = n;
            this.column = rangeVariable.getColumn(n);
            this.dataType = this.column.getDataType();
            this.rangeVariable = rangeVariable;
            this.rangeVariable.addColumn(this.columnIndex);
        }
    }

    @Override
    void setAttributesAsColumn(ColumnSchema columnSchema, boolean bl) {
        this.column = columnSchema;
        this.dataType = columnSchema.getDataType();
        this.isWritable = bl;
    }

    @Override
    HsqlNameManager.SimpleName getSimpleName() {
        if (this.alias != null) {
            return this.alias;
        }
        if (this.column != null) {
            return this.column.getName();
        }
        if (this.opType == 3) {
            return this.nodes[0].getSimpleName();
        }
        return null;
    }

    @Override
    String getAlias() {
        if (this.alias != null) {
            return this.alias.name;
        }
        if (this.opType == 2) {
            return this.columnName;
        }
        if (this.opType == 3) {
            return this.columnName;
        }
        return "";
    }

    public String getBaseColumnName() {
        if (this.opType == 2 && this.rangeVariable != null) {
            return this.rangeVariable.getTable().getColumn((int)this.columnIndex).getName().name;
        }
        return null;
    }

    public HsqlNameManager.HsqlName getBaseColumnHsqlName() {
        return this.column.getName();
    }

    @Override
    void collectObjectNames(Set set) {
        switch (this.opType) {
            case 10: {
                HsqlNameManager.HsqlName hsqlName = this.sequence.getName();
                set.add(hsqlName);
                return;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 97: {
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                set.add(this.column.getName());
                if (this.column.getName().parent != null) {
                    set.add(this.column.getName().parent);
                }
                return;
            }
        }
    }

    @Override
    String getColumnName() {
        if (this.opType == 2 && this.column != null) {
            return this.column.getName().name;
        }
        return this.getAlias();
    }

    @Override
    ColumnSchema getColumn() {
        return this.column;
    }

    String getSchemaName() {
        return this.schema;
    }

    @Override
    RangeVariable getRangeVariable() {
        return this.rangeVariable;
    }

    @Override
    public HsqlList resolveColumnReferences(RangeVariable[] rangeVariableArray, int n, HsqlList hsqlList, boolean bl) {
        switch (this.opType) {
            case 10: {
                if (bl) break;
                throw Error.error(5598);
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 97: {
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                boolean bl2;
                boolean bl3 = false;
                boolean bl4 = bl2 = this.tableName != null;
                if (this.rangeVariable != null) {
                    return hsqlList;
                }
                for (int i = 0; i < n; ++i) {
                    RangeVariable rangeVariable = rangeVariableArray[i];
                    if (rangeVariable == null) continue;
                    if (bl3) {
                        if (!this.resolvesDuplicateColumnReference(rangeVariable) || !this.strictReference) continue;
                        String string = this.getColumnName();
                        if (this.alias != null) {
                            StringBuffer stringBuffer = new StringBuffer(string);
                            stringBuffer.append(' ').append("AS").append(' ').append(this.alias.getStatementName());
                            string = stringBuffer.toString();
                        }
                        throw Error.error(5580, string);
                    }
                    if (!this.resolveColumnReference(rangeVariable)) continue;
                    if (bl2) {
                        return hsqlList;
                    }
                    bl3 = true;
                }
                if (bl3) {
                    return hsqlList;
                }
                if (hsqlList == null) {
                    hsqlList = new ArrayListIdentity();
                }
                hsqlList.add(this);
            }
        }
        return hsqlList;
    }

    public boolean resolveColumnReference(RangeVariable rangeVariable) {
        if (this.tableName == null) {
            ExpressionColumn expressionColumn = rangeVariable.getColumnExpression(this.columnName);
            if (expressionColumn != null) {
                this.opType = expressionColumn.opType;
                this.nodes = expressionColumn.nodes;
                this.dataType = expressionColumn.dataType;
                return true;
            }
            if (rangeVariable.variables != null) {
                int n = rangeVariable.findColumn(this.columnName);
                if (n == -1) {
                    return false;
                }
                ColumnSchema columnSchema = rangeVariable.getColumn(n);
                if (columnSchema.getParameterMode() == 4) {
                    return false;
                }
                this.opType = rangeVariable.isVariable ? 6 : 7;
                this.setAttributesAsColumn(rangeVariable, n);
                return true;
            }
        }
        if (!rangeVariable.resolvesTableName(this)) {
            return false;
        }
        int n = rangeVariable.findColumn(this.columnName);
        if (n != -1) {
            this.setAttributesAsColumn(rangeVariable, n);
            return true;
        }
        return false;
    }

    boolean resolvesDuplicateColumnReference(RangeVariable rangeVariable) {
        if (this.tableName == null) {
            ExpressionColumn expressionColumn = rangeVariable.getColumnExpression(this.columnName);
            if (expressionColumn != null) {
                return false;
            }
            if (rangeVariable.variables != null) {
                int n = rangeVariable.findColumn(this.columnName);
                if (n == -1) {
                    return false;
                }
                ColumnSchema columnSchema = rangeVariable.getColumn(n);
                return columnSchema.getParameterMode() != 4;
            }
        }
        if (!rangeVariable.resolvesTableName(this)) {
            return false;
        }
        int n = rangeVariable.findColumn(this.columnName);
        return n != -1;
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        switch (this.opType) {
            case 4: {
                if (expression == null || expression.opType == 25) break;
                throw Error.error(5544);
            }
            case 3: {
                Type type = null;
                for (int i = 0; i < this.nodes.length; ++i) {
                    type = Type.getAggregateType(this.nodes[i].dataType, type);
                }
                this.dataType = type;
                break;
            }
        }
    }

    @Override
    public Object getValue(Session session) {
        switch (this.opType) {
            case 4: {
                return null;
            }
            case 6: {
                return session.sessionContext.routineVariables[this.columnIndex];
            }
            case 7: {
                return session.sessionContext.routineArguments[this.columnIndex];
            }
            case 2: {
                Object[] objectArray = session.sessionContext.rangeIterators[this.rangeVariable.rangePosition].getCurrent();
                Object object = objectArray[this.columnIndex];
                if (this.dataType != this.column.dataType) {
                    object = this.dataType.convertToType(session, object, this.column.dataType);
                }
                return object;
            }
            case 5: {
                Object[] objectArray = session.sessionContext.rangeIterators[this.rangePosition].getCurrent();
                return objectArray[this.columnIndex];
            }
            case 3: {
                Object object = null;
                for (int i = 0; i < this.nodes.length; ++i) {
                    object = this.nodes[i].getValue(session, this.dataType);
                    if (object == null) continue;
                    return object;
                }
                return object;
            }
            case 8: {
                return session.sessionContext.dynamicArguments[this.parameterIndex];
            }
            case 10: {
                return session.sessionData.getSequenceValue(this.sequence);
            }
        }
        throw Error.runtimeError(201, "ExpressionColumn");
    }

    @Override
    public String getSQL() {
        switch (this.opType) {
            case 4: {
                return "DEFAULT";
            }
            case 8: {
                return "?";
            }
            case 9: {
                return "*";
            }
            case 3: {
                return this.alias.getStatementName();
            }
            case 2: 
            case 6: 
            case 7: {
                if (this.column == null) {
                    if (this.alias != null) {
                        return this.alias.getStatementName();
                    }
                    return this.columnName;
                }
                if (this.rangeVariable.tableAlias == null) {
                    return this.column.getName().getSchemaQualifiedStatementName();
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.rangeVariable.tableAlias.getStatementName());
                stringBuffer.append('.');
                stringBuffer.append(this.column.getName().statementName);
                return stringBuffer.toString();
            }
            case 97: {
                if (this.nodes.length == 0) {
                    return "*";
                }
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < this.nodes.length; ++i) {
                    Expression expression = this.nodes[i];
                    if (i > 0) {
                        stringBuffer.append(',');
                    }
                    String string = expression.getSQL();
                    stringBuffer.append(string);
                }
                return stringBuffer.toString();
            }
        }
        throw Error.runtimeError(201, "ExpressionColumn");
    }

    @Override
    protected String describe(Session session, int n) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        switch (this.opType) {
            case 4: {
                stringBuffer.append("DEFAULT");
                break;
            }
            case 9: {
                stringBuffer.append("OpTypes.ASTERISK ");
                break;
            }
            case 6: {
                stringBuffer.append("VARIABLE: ");
                stringBuffer.append(this.column.getName().name);
                break;
            }
            case 7: {
                stringBuffer.append("PARAMETER").append(": ");
                stringBuffer.append(this.column.getName().name);
                break;
            }
            case 3: {
                stringBuffer.append("COLUMN").append(": ");
                stringBuffer.append(this.columnName);
                if (this.alias == null) break;
                stringBuffer.append(" AS ").append(this.alias.name);
                break;
            }
            case 2: {
                stringBuffer.append("COLUMN").append(": ");
                stringBuffer.append(this.column.getName().getSchemaQualifiedStatementName());
                if (this.alias == null) break;
                stringBuffer.append(" AS ").append(this.alias.name);
                break;
            }
            case 8: {
                stringBuffer.append("DYNAMIC PARAM: ");
                stringBuffer.append(", TYPE = ").append(this.dataType.getNameString());
                break;
            }
            case 10: {
                stringBuffer.append("SEQUENCE").append(": ");
                stringBuffer.append(this.sequence.getName().name);
                break;
            }
        }
        return stringBuffer.toString();
    }

    String getTableName() {
        if (this.opType == 97) {
            return this.tableName;
        }
        if (this.opType == 2) {
            if (this.rangeVariable == null) {
                return this.tableName;
            }
            return this.rangeVariable.getTable().getName().name;
        }
        return "";
    }

    static void checkColumnsResolved(HsqlList hsqlList) {
        if (hsqlList != null && !hsqlList.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            Expression expression = (Expression)hsqlList.get(0);
            if (expression instanceof ExpressionColumn) {
                ExpressionColumn expressionColumn = (ExpressionColumn)expression;
                if (expressionColumn.schema != null) {
                    stringBuffer.append(expressionColumn.schema + '.');
                }
                if (expressionColumn.tableName != null) {
                    stringBuffer.append(expressionColumn.tableName + '.');
                }
                throw Error.error(5501, stringBuffer.toString() + expressionColumn.getColumnName());
            }
            throw Error.error(5501);
        }
    }

    @Override
    public OrderedHashSet getUnkeyedColumns(OrderedHashSet orderedHashSet) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            orderedHashSet = this.nodes[i].getUnkeyedColumns(orderedHashSet);
        }
        if (this.opType == 2 && !this.rangeVariable.hasKeyedColumnInGroupBy) {
            if (orderedHashSet == null) {
                orderedHashSet = new OrderedHashSet();
            }
            orderedHashSet.add(this);
        }
        return orderedHashSet;
    }

    @Override
    void collectRangeVariables(RangeVariable[] rangeVariableArray, Set set) {
        int n;
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n] == null) continue;
            this.nodes[n].collectRangeVariables(rangeVariableArray, set);
        }
        if (this.rangeVariable != null) {
            for (n = 0; n < rangeVariableArray.length; ++n) {
                if (rangeVariableArray[n] != this.rangeVariable) continue;
                set.add(this.rangeVariable);
                break;
            }
        }
    }

    @Override
    Expression replaceAliasInOrderBy(Expression[] expressionArray, int n) {
        int n2;
        for (n2 = 0; n2 < this.nodes.length; ++n2) {
            if (this.nodes[n2] == null) continue;
            this.nodes[n2] = this.nodes[n2].replaceAliasInOrderBy(expressionArray, n);
        }
        switch (this.opType) {
            case 2: 
            case 3: {
                for (n2 = 0; n2 < n; ++n2) {
                    String string;
                    HsqlNameManager.SimpleName simpleName = expressionArray[n2].alias;
                    String string2 = string = simpleName == null ? null : simpleName.name;
                    if (this.schema != null || this.tableName != null || !this.columnName.equals(string)) continue;
                    return expressionArray[n2];
                }
                for (n2 = 0; n2 < n; ++n2) {
                    if (!(expressionArray[n2] instanceof ExpressionColumn)) continue;
                    if (this.equals(expressionArray[n2])) {
                        return expressionArray[n2];
                    }
                    if (this.tableName != null || this.schema != null || !this.columnName.equals(((ExpressionColumn)expressionArray[n2]).columnName)) continue;
                    return expressionArray[n2];
                }
                break;
            }
        }
        return this;
    }

    @Override
    Expression replaceColumnReferences(RangeVariable rangeVariable, Expression[] expressionArray) {
        if (this.opType == 2 && this.rangeVariable == rangeVariable) {
            return expressionArray[this.columnIndex];
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceColumnReferences(rangeVariable, expressionArray);
        }
        return this;
    }

    @Override
    int findMatchingRangeVariableIndex(RangeVariable[] rangeVariableArray) {
        for (int i = 0; i < rangeVariableArray.length; ++i) {
            RangeVariable rangeVariable = rangeVariableArray[i];
            if (!rangeVariable.resolvesTableName(this)) continue;
            return i;
        }
        return -1;
    }

    @Override
    boolean hasReference(RangeVariable rangeVariable) {
        if (rangeVariable == this.rangeVariable) {
            return true;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null || !this.nodes[i].hasReference(rangeVariable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Expression expression) {
        if (expression == this) {
            return true;
        }
        if (expression == null) {
            return false;
        }
        if (this.opType != expression.opType) {
            return false;
        }
        switch (this.opType) {
            case 5: {
                return this.columnIndex == expression.columnIndex;
            }
            case 3: {
                return this.nodes == expression.nodes;
            }
            case 2: {
                return this.column == expression.getColumn();
            }
        }
        return false;
    }

    @Override
    void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
        int n;
        for (n = 0; n < this.nodes.length; ++n) {
            this.nodes[n].replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
        for (n = 0; n < rangeVariableArray.length; ++n) {
            if (this.rangeVariable != rangeVariableArray[n]) continue;
            this.rangeVariable = rangeVariableArray2[n];
            break;
        }
    }

    @Override
    void resetColumnReferences() {
        this.rangeVariable = null;
        this.columnIndex = -1;
    }

    @Override
    public boolean isIndexable(RangeVariable rangeVariable) {
        if (this.opType == 2) {
            return this.rangeVariable == rangeVariable;
        }
        return false;
    }

    @Override
    public boolean isUnresolvedParam() {
        return this.isParam && this.dataType == null;
    }

    @Override
    boolean isDynamicParam() {
        return this.isParam;
    }
}

