/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.dnd;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.dnd.TopComponentDragSupport;
import org.netbeans.core.windows.frames.FrameType;
import org.netbeans.core.windows.frames.MultiTabbedContainerImpl;
import org.netbeans.core.windows.frames.SplitContainerImpl;
import org.netbeans.core.windows.frames.TopComponentContainer;
import org.openide.util.WeakSet;
import org.openide.windows.WindowManager;

public final class WindowDnDManager {
    private static WindowDnDManager defaultDnDManager;
    private DragSource windowDragSource;
    private boolean dragging;
    private boolean dropSuccess;
    private final Set dropIndicators = new WeakSet(4);
    private final Set floatingFrames = new WeakSet(4);
    private Reference lastTargetWRef = new WeakReference<Object>(null);
    private Rectangle originalBounds;

    private WindowDnDManager() {
    }

    public static synchronized WindowDnDManager getDefault() {
        if (defaultDnDManager == null) {
            defaultDnDManager = new WindowDnDManager();
        }
        return defaultDnDManager;
    }

    public synchronized DragSource getWindowDragSource() {
        if (this.windowDragSource == null) {
            this.windowDragSource = new DragSource();
            new MotionListener();
        }
        return this.windowDragSource;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDropSuccess(boolean dropSuccess) {
        this.dropSuccess = dropSuccess;
    }

    public boolean isDropSuccess() {
        return this.dropSuccess;
    }

    public void setOriginalBounds(Rectangle bounds) {
        this.originalBounds = bounds;
    }

    public Rectangle getOriginalBounds() {
        return this.originalBounds;
    }

    public void setLastDropTarget(TopComponentContainer.DropIndicator target) {
        if (target != this.lastTargetWRef.get()) {
            this.lastTargetWRef = new WeakReference<TopComponentContainer.DropIndicator>(target);
        }
    }

    public void resetDragSource() {
        this.dragFinished();
    }

    public void dragStarting() {
        Set modes = WindowManager.getDefault().getCurrentWorkspace().getModes();
        Set set = this.dropIndicators;
        synchronized (set) {
            Iterator it = modes.iterator();
            while (it.hasNext()) {
                FrameType frameType;
                ModeImpl modeImpl = (ModeImpl)it.next();
                TopComponentContainer tcc = modeImpl.getContainerInstance();
                if (tcc instanceof TopComponentContainer.DropIndicator) {
                    ((TopComponentContainer.DropIndicator)((Object)tcc)).windowDragStarting();
                    this.dropIndicators.add(tcc);
                }
                if ((frameType = modeImpl.getFrameInstance()) == null) continue;
                this.floatingFrames.add(frameType);
            }
        }
        this.dragging = true;
        this.dropSuccess = false;
    }

    public void dragFinished() {
        TopComponentDragSupport.getDefault().dragFinished();
        this.dragging = false;
        Set set = this.dropIndicators;
        synchronized (set) {
            Iterator it = this.dropIndicators.iterator();
            while (it.hasNext()) {
                TopComponentContainer.DropIndicator di = (TopComponentContainer.DropIndicator)it.next();
                di.windowDragFinished();
                it.remove();
            }
            this.floatingFrames.clear();
        }
        this.setOriginalBounds(null);
    }

    private static void dragSourceMoved(DragSourceDragEvent evt) {
        Point location = TopComponentDragSupport.getLocationForEvent(evt);
        if (location == null) {
            return;
        }
        Point checkLocation = new Point(location);
        Rectangle bounds = MainWindow.getDefault().getBounds();
        if (!bounds.contains(checkLocation)) {
            boolean contains = false;
            Iterator it = WindowDnDManager.getDefault().floatingFrames.iterator();
            while (it.hasNext()) {
                FrameType frameType = (FrameType)it.next();
                if (!frameType.getRootPaneContainer().getBounds().contains(checkLocation)) continue;
                contains = true;
                break;
            }
            if (!contains) {
                WindowDnDManager.setCursorInFreeArea();
            }
        }
    }

    private static void setCursorInFreeArea() {
        TopComponentDragSupport.getDefault().dragEnterHack(TopComponentDragSupport.getDefault().hackUserDropAction);
        WindowDnDManager.dragExitedHack();
    }

    private static void dragExitedHack() {
        WindowDnDManager wdm = WindowDnDManager.getDefault();
        TopComponentContainer.DropIndicator lastTarget = (TopComponentContainer.DropIndicator)wdm.lastTargetWRef.get();
        if (lastTarget instanceof SplitContainerImpl) {
            ((SplitContainerImpl)lastTarget).dragExitedHack();
        } else if (lastTarget instanceof MultiTabbedContainerImpl) {
            ((MultiTabbedContainerImpl)lastTarget).dragExitedHack();
        }
        if (lastTarget != null) {
            wdm.lastTargetWRef = new WeakReference<Object>(null);
        }
    }

    private static class MotionListener {
        private MotionListener() {
            try {
                Class<?> listener = Class.forName("java.awt.dnd.DragSourceMotionListener");
                DragSource ds = WindowDnDManager.getDefault().getWindowDragSource();
                Method addMotionListener = ds.getClass().getMethod("addDragSourceMotionListener", listener);
                Object listenerProxy = Proxy.newProxyInstance(ds.getClass().getClassLoader(), new Class[]{listener}, new InvocationHandler(){

                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        WindowDnDManager.dragSourceMoved((DragSourceDragEvent)args[0]);
                        return null;
                    }
                });
                addMotionListener.invoke((Object)ds, listenerProxy);
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
            catch (NoSuchMethodException nsme) {
                nsme.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
            }
        }
    }
}

