/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.modules.DuplicateException;
import org.netbeans.core.modules.Events;
import org.netbeans.core.modules.Module;
import org.netbeans.core.modules.ModuleHistory;
import org.netbeans.core.modules.ModuleList;
import org.netbeans.core.modules.ModuleManager;
import org.netbeans.core.modules.NbEvents;
import org.netbeans.core.modules.NbInstaller;
import org.netbeans.core.modules.TestModuleDeployer;
import org.netbeans.core.modules.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Utilities;

public final class ModuleSystem {
    private final ModuleManager mgr;
    private final NbInstaller installer;
    private final ModuleList list;
    private final Events ev = Boolean.getBoolean("netbeans.modules.quiet") ? new QuietEvents() : new NbEvents();
    private Set bootModules = null;
    private Set autoscanned;
    static /* synthetic */ Class class$org$netbeans$core$modules$ModuleSystem;

    public ModuleSystem(FileSystem systemFileSystem, File installAutoscanFolder, File[] extraAutoscanFolders, File userAutoscanFolder) throws IOException {
        this.installer = new NbInstaller(this.ev);
        this.mgr = new ModuleManager(this.installer, this.ev);
        PropertyChangeListener l = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                if ("classLoader".equals(ev.getPropertyName())) {
                    NbTopManager.Lkp.systemClassLoaderChanged(ModuleSystem.this.mgr.getClassLoader());
                }
            }
        };
        this.mgr.addPropertyChangeListener(l);
        NbTopManager.Lkp.systemClassLoaderChanged(this.mgr.getClassLoader());
        NbTopManager.Lkp.moduleLookupReady(this.mgr.getModuleLookup());
        if (systemFileSystem.isReadOnly()) {
            this.list = null;
        } else {
            FileObject root = systemFileSystem.getRoot();
            FileObject modulesFolder = root.getFileObject("Modules");
            if (modulesFolder == null) {
                modulesFolder = root.createFolder("Modules");
            }
            ArrayList scandirs = new ArrayList(4);
            ModuleSystem.processTopDir(installAutoscanFolder, scandirs, "installation");
            int i = 0;
            while (i < extraAutoscanFolders.length) {
                ModuleSystem.processTopDir(extraAutoscanFolders[i], scandirs, "installation");
                ++i;
            }
            ModuleSystem.processTopDir(userAutoscanFolder, scandirs, "user");
            this.list = new ModuleList(this.mgr, modulesFolder, scandirs, this.ev);
            this.installer.registerList(this.list);
            this.installer.registerManager(this.mgr);
        }
        this.ev.log("createdModuleSystem");
    }

    private static void processTopDir(File f, List scandirs, String origin) {
        if (f != null && f.isDirectory()) {
            File eagerFolder;
            scandirs.add(new ModuleList.AutoscanFolder(f, origin, false, false));
            File autoloadFolder = new File(f, "autoload");
            if (autoloadFolder.isDirectory()) {
                scandirs.add(new ModuleList.AutoscanFolder(autoloadFolder, origin + "/autoload", true, false));
            }
            if ((eagerFolder = new File(f, "eager")).isDirectory()) {
                scandirs.add(new ModuleList.AutoscanFolder(eagerFolder, origin + "/eager", false, true));
            }
        }
    }

    public ModuleManager getManager() {
        return this.mgr;
    }

    public Events getEvents() {
        return this.ev;
    }

    public List getModuleJars() {
        ArrayList arrayList;
        this.mgr.mutexPrivileged().enterReadAccess();
        try {
            Iterator modules = this.mgr.getEnabledModules().iterator();
            ArrayList l = new ArrayList();
            while (modules.hasNext()) {
                l.addAll(((Module)((Object)modules.next())).getAllJars());
            }
            arrayList = l;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.mgr.mutexPrivileged().exitReadAccess();
            throw throwable;
        }
        this.mgr.mutexPrivileged().exitReadAccess();
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadBootModules() {
        ArrayList<String> ignoredPrefixes = new ArrayList<String>(3);
        try {
            String jdk = System.getProperty("java.home");
            if (jdk.endsWith(File.separator + "jre")) {
                jdk = jdk.substring(0, jdk.length() - 4);
            }
            File f = new File(jdk);
            ignoredPrefixes.add("jar:" + Utilities.toURL((File)f));
            String nbhomeS = System.getProperty("netbeans.home");
            if (nbhomeS != null) {
                File nbhome = new File(nbhomeS);
                f = new File(new File(nbhome, "lib"), "ext");
                ignoredPrefixes.add("jar:" + Utilities.toURL((File)f));
                f = new File(new File(new File(nbhome, "modules"), "autoload"), "ext");
                ignoredPrefixes.add("jar:" + Utilities.toURL((File)f));
            }
        }
        catch (MalformedURLException e) {
            Util.err.notify(1, (Throwable)e);
        }
        if (Util.err.isLoggable(1)) {
            Util.err.log("ignoredPrefixes=" + ignoredPrefixes);
        }
        this.mgr.mutexPrivileged().enterWriteAccess();
        this.ev.log("startLoadBootModules");
        try {
            try {
                this.bootModules = new HashSet(10);
                ClassLoader loader = (class$org$netbeans$core$modules$ModuleSystem == null ? (class$org$netbeans$core$modules$ModuleSystem = ModuleSystem.class$("org.netbeans.core.modules.ModuleSystem")) : class$org$netbeans$core$modules$ModuleSystem).getClassLoader();
                Enumeration<URL> e = loader.getResources("META-INF/MANIFEST.MF");
                this.ev.log("perfTick", "got all manifests");
                HashSet<URL> checkedManifests = new HashSet<URL>();
                while (true) {
                    Object var12_15;
                    InputStream is;
                    block25: {
                        block24: {
                            URL manifestUrl;
                            block23: {
                                if (!e.hasMoreElements()) {
                                    if (this.list == null) {
                                        this.mgr.enable(this.bootModules);
                                    }
                                    this.ev.log("perfTick", "added all classpath modules");
                                    break;
                                }
                                manifestUrl = e.nextElement();
                                if (!checkedManifests.add(manifestUrl)) continue;
                                String manifestUrlS = manifestUrl.toExternalForm();
                                Iterator it = ignoredPrefixes.iterator();
                                do {
                                    if (it.hasNext()) continue;
                                    if (Util.err.isLoggable(1)) {
                                        Util.err.log("Checking boot manifest: " + manifestUrlS);
                                    }
                                    try {
                                        is = manifestUrl.openStream();
                                        break block23;
                                    }
                                    catch (IOException ioe) {
                                        Util.err.annotate((Throwable)ioe, 0, "URL: " + manifestUrl, null, null, null);
                                        throw ioe;
                                    }
                                } while (!manifestUrlS.startsWith((String)it.next()));
                                continue;
                            }
                            try {
                                Manifest mani;
                                block27: {
                                    block26: {
                                        mani = new Manifest(is);
                                        Attributes attr = mani.getMainAttributes();
                                        if (attr.getValue("OpenIDE-Module") == null || attr.getValue("OpenIDE-Archive-Locale") != null) break block26;
                                        if (attr.getValue("OpenIDE-Archive-Branding") == null) break block27;
                                    }
                                    var12_15 = null;
                                    break block24;
                                }
                                this.bootModules.add(this.mgr.createFixed(mani, manifestUrl, loader));
                                break block25;
                            }
                            catch (Throwable throwable) {
                                var12_15 = null;
                                is.close();
                                throw throwable;
                            }
                        }
                        is.close();
                        continue;
                    }
                    var12_15 = null;
                    is.close();
                }
            }
            catch (IOException ioe) {
                Util.err.notify((Throwable)ioe);
                Object var14_18 = null;
                this.ev.log("finishLoadBootModules");
                this.mgr.mutexPrivileged().exitWriteAccess();
                return;
            }
            catch (DuplicateException de) {
                Util.err.notify((Throwable)de);
                Object var14_19 = null;
                this.ev.log("finishLoadBootModules");
                this.mgr.mutexPrivileged().exitWriteAccess();
                return;
            }
            Object var14_17 = null;
            this.ev.log("finishLoadBootModules");
        }
        catch (Throwable throwable) {
            Object var14_20 = null;
            this.ev.log("finishLoadBootModules");
            this.mgr.mutexPrivileged().exitWriteAccess();
            throw throwable;
        }
        this.mgr.mutexPrivileged().exitWriteAccess();
    }

    public void readList() {
        this.ev.log("perfStart", "ModuleSystem.readList");
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            this.list.upgradeCompatibly();
            this.list.readInitial();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.mgr.mutexPrivileged().exitWriteAccess();
            throw throwable;
        }
        this.mgr.mutexPrivileged().exitWriteAccess();
        this.ev.log("perfEnd", "ModuleSystem.readList");
    }

    public void scanForNewAndRestore() {
        this.ev.log("perfStart", "ModuleSystem.scanForNewAndRestore");
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            this.autoscanned = this.list.scan();
            this.ev.log("perfTick", "list scanned");
            HashSet<Module> toTrigger = new HashSet<Module>(this.bootModules);
            Iterator it = this.autoscanned.iterator();
            while (it.hasNext()) {
                Module m = (Module)((Object)it.next());
                Object o = m.getHistory();
                if (!(o instanceof ModuleHistory) || !((ModuleHistory)o).isPreviouslyInstalled()) continue;
                Util.err.log("#17723 fix active for " + (Object)((Object)m));
                it.remove();
                toTrigger.add(m);
            }
            this.list.trigger(toTrigger);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.mgr.mutexPrivileged().exitWriteAccess();
            throw throwable;
        }
        this.mgr.mutexPrivileged().exitWriteAccess();
        this.ev.log("perfEnd", "ModuleSystem.scanForNewAndRestore");
    }

    public void installNew() {
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            if (!this.autoscanned.isEmpty()) {
                this.ev.log("startAutoInstall", this.autoscanned);
                this.list.installNew(this.autoscanned);
                this.ev.log("finishAutoInstall", this.autoscanned);
            }
            this.autoscanned = null;
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.mgr.mutexPrivileged().exitWriteAccess();
            throw throwable;
        }
        this.mgr.mutexPrivileged().exitWriteAccess();
    }

    public boolean shutDown(Runnable midHook) {
        boolean bl;
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            bl = this.mgr.shutDown(midHook);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.mgr.mutexPrivileged().exitWriteAccess();
            throw throwable;
        }
        this.mgr.mutexPrivileged().exitWriteAccess();
        return bl;
    }

    private void deployTestModule(File jar) throws IOException {
        if (!jar.isAbsolute()) {
            throw new IOException("Absolute paths only please");
        }
        this.mgr.mutexPrivileged().enterWriteAccess();
        this.ev.log("startDeployTestModule", jar);
        System.err.println("Deploying test module " + jar + "...");
        try {
            Module m;
            Module tm = null;
            HashSet toReenable = new HashSet();
            Iterator it = this.mgr.getModules().iterator();
            while (it.hasNext()) {
                m = (Module)((Object)it.next());
                if (!jar.equals(m.getJarFile())) continue;
                if (!m.isReloadable()) {
                    m.setReloadable(true);
                }
                this.turnOffModule(m, toReenable);
                this.mgr.reload(m);
                tm = m;
                break;
            }
            if (tm == null) {
                try {
                    tm = this.mgr.create(jar, new ModuleHistory(), true, false, false);
                }
                catch (DuplicateException dupe) {
                    Module old = dupe.getOldModule();
                    System.err.println("Replacing old module in " + old.getJarFile());
                    this.turnOffModule(old, toReenable);
                    this.mgr.delete(old);
                    try {
                        tm = this.mgr.create(jar, new ModuleHistory(), true, false, false);
                    }
                    catch (DuplicateException dupe2) {
                        IOException ioe = new IOException(dupe2.toString());
                        Util.err.annotate((Throwable)ioe, (Throwable)dupe2);
                        throw ioe;
                    }
                }
            }
            System.err.println("Enabling " + tm.getJarFile() + "...");
            if (!this.mgr.simulateEnable(Collections.singleton(tm)).contains((Object)tm)) {
                throw new IOException("Cannot enable " + tm.getJarFile() + "; problems: " + tm.getProblems());
            }
            this.mgr.enable(tm);
            if (!toReenable.isEmpty()) {
                System.err.println("Also re-enabling:");
                it = toReenable.iterator();
                while (it.hasNext()) {
                    m = (Module)((Object)it.next());
                    System.err.println("\t" + m.getDisplayName());
                    if (!m.isReloadable()) continue;
                    m.reload();
                }
                try {
                    this.mgr.enable(toReenable);
                }
                catch (IllegalArgumentException iae) {
                    throw new IOException(iae.toString());
                }
            }
            System.err.println("Done.");
            Object var10_11 = null;
            this.ev.log("finishDeployTestModule", jar);
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.ev.log("finishDeployTestModule", jar);
            this.mgr.mutexPrivileged().exitWriteAccess();
            throw throwable;
        }
        this.mgr.mutexPrivileged().exitWriteAccess();
    }

    private void turnOffModule(Module m, Set toReenable) {
        if (!m.isEnabled()) {
            return;
        }
        Iterator it = this.mgr.simulateDisable(Collections.singleton(m)).iterator();
        while (it.hasNext()) {
            Module m2 = (Module)((Object)it.next());
            if (m2.isAutoload() || m2.isEager()) continue;
            toReenable.add(m2);
        }
        try {
            System.err.println("Disabling " + m.getJarFile() + "...");
            this.mgr.disable(toReenable);
            Object var6_5 = null;
            toReenable.remove((Object)m);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            toReenable.remove((Object)m);
            throw throwable;
        }
    }

    public String getEffectiveClasspath(Module m) {
        return this.installer.getEffectiveClasspath(m);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class QuietEvents
    extends Events {
        QuietEvents() {
        }

        protected void logged(String message, Object[] args) {
        }
    }

    public static final class TestModuleDeployerImpl
    extends TestModuleDeployer {
        public void deployTestModule(File jar) throws IOException {
            NbTopManager.get().getModuleSystem().deployTestModule(jar);
        }
    }
}

