/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.actions;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.frames.TopComponentContainer;
import org.openide.awt.Actions;
import org.openide.awt.JInlineMenu;
import org.openide.awt.JMenuPlus;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class OpenedWindowsAction
extends SystemAction
implements Presenter.Menu {
    static final long serialVersionUID = -145456518535036783L;
    private String name;
    private static ActionListener modeSubItemListener;
    private static ActionListener modeMainItemListener;
    private static Workspace chosenWorkspace;
    static /* synthetic */ Class class$org$netbeans$core$actions$OpenedWindowsAction;

    public OpenedWindowsAction() {
        this(null);
    }

    public OpenedWindowsAction(String aName) {
        this.name = aName;
    }

    public String getName() {
        if (this.name == null) {
            this.name = NbBundle.getBundle((Class)(class$org$netbeans$core$actions$OpenedWindowsAction == null ? (class$org$netbeans$core$actions$OpenedWindowsAction = OpenedWindowsAction.class$("org.netbeans.core.actions.OpenedWindowsAction")) : class$org$netbeans$core$actions$OpenedWindowsAction)).getString("OpenedWindows");
        }
        return this.name;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$actions$OpenedWindowsAction == null ? (class$org$netbeans$core$actions$OpenedWindowsAction = OpenedWindowsAction.class$("org.netbeans.core.actions.OpenedWindowsAction")) : class$org$netbeans$core$actions$OpenedWindowsAction);
    }

    public JMenuItem getMenuPresenter() {
        Popup mainItem = new Popup();
        return mainItem;
    }

    public void actionPerformed(ActionEvent ev) {
    }

    private static ActionListener modeMainItemListener() {
        if (modeMainItemListener == null) {
            modeMainItemListener = new ModeMainActionListener();
        }
        return modeMainItemListener;
    }

    private static ActionListener modeSubItemListener() {
        if (modeSubItemListener == null) {
            modeSubItemListener = new ModeSubActionListener();
        }
        return modeSubItemListener;
    }

    private static Image defaultModeIcon() {
        return Utilities.loadImage((String)"org/netbeans/core/resources/frames/default.gif");
    }

    private static JMenuItem createEmptyMenuItem() {
        JMenuItem emptyItem = new JMenuItem(NbBundle.getBundle((Class)(class$org$netbeans$core$actions$OpenedWindowsAction == null ? (class$org$netbeans$core$actions$OpenedWindowsAction = OpenedWindowsAction.class$("org.netbeans.core.actions.OpenedWindowsAction")) : class$org$netbeans$core$actions$OpenedWindowsAction)).getString("CTL_Empty"));
        emptyItem.setEnabled(false);
        return emptyItem;
    }

    private static void selectMode(ModeImpl mode) {
        if (mode.getFrameState() == 1) {
            mode.setFrameState(0);
        }
        mode.requestFocus();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ModeMainActionListener
    implements ActionListener {
        ModeMainActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            JMenuItem item = (JMenuItem)evt.getSource();
            WindowManagerImpl wm = (WindowManagerImpl)WindowManager.getDefault();
            WorkspaceImpl currWorkspace = (WorkspaceImpl)wm.getCurrentWorkspace();
            ModeImpl currMode = (ModeImpl)currWorkspace.findMode(item.getName());
            if (currMode != null) {
                OpenedWindowsAction.selectMode(currMode);
            }
        }
    }

    private static final class ModeSubActionListener
    implements ActionListener {
        ModeSubActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            JMenuItem item = (JMenuItem)evt.getSource();
            WindowManagerImpl wm = (WindowManagerImpl)WindowManager.getDefault();
            WorkspaceImpl curWs = (WorkspaceImpl)wm.getCurrentWorkspace();
            ModeImpl curMode = (ModeImpl)curWs.findMode(item.getName());
            if (!chosenWorkspace.equals(curWs)) {
                TopComponent origTopComponent;
                ModeImpl origMode = (ModeImpl)chosenWorkspace.findMode(item.getName());
                if (curMode == null) {
                    curMode = new ModeImpl(curWs, origMode);
                }
                curWs.addMode(curMode);
                TopComponent[] tcs = origMode.getTopComponents();
                int i = 0;
                while (i < tcs.length) {
                    curMode.dockInto(tcs[i]);
                    if (((WorkspaceImpl)chosenWorkspace).isOpened(tcs[i])) {
                        tcs[i].open((Workspace)curWs);
                    }
                    ++i;
                }
                TopComponentContainer origContainer = origMode.getContainerInstance();
                if (origContainer != null && (origTopComponent = origContainer.getSelectedTopComponent()) != null) {
                    curMode.requestFocus(origTopComponent);
                }
            } else {
                OpenedWindowsAction.selectMode(curMode);
            }
        }
    }

    private static final class WorkspaceLazyMenu
    extends JMenuPlus {
        private String workspaceName;
        private WeakReference oldWSW = new WeakReference<Object>(null);
        private Set oldModes = new WeakSet();
        static /* synthetic */ Class class$org$netbeans$core$actions$OpenedWindowsAction;

        public WorkspaceLazyMenu(String workspaceName) {
            this.workspaceName = workspaceName;
        }

        public JPopupMenu getPopupMenu() {
            this.updatePopup();
            return super.getPopupMenu();
        }

        private void updatePopup() {
            chosenWorkspace = WindowManager.getDefault().findWorkspace(this.workspaceName);
            JMenuItem curItem = null;
            Image curIcon = null;
            ModeImpl[] modes = chosenWorkspace.getModes().toArray(new ModeImpl[0]);
            Workspace oldWS = (Workspace)this.oldWSW.get();
            HashSet<ModeImpl> mss = new HashSet<ModeImpl>(Arrays.asList(modes));
            if (oldWS != null && oldWS.equals(chosenWorkspace) && this.oldModes.equals(mss)) {
                return;
            }
            this.oldWSW = new WeakReference<Workspace>(chosenWorkspace);
            this.oldModes = new WeakSet(mss);
            ((JMenu)((Object)this)).removeAll();
            int itemMnemonic = 1;
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < modes.length) {
                if (!modes[i].isHidden()) {
                    curItem = new JMenuItem();
                    buffer.append(itemMnemonic);
                    if (itemMnemonic < 10) {
                        buffer.insert(0, '&');
                    } else if (itemMnemonic == 10) {
                        buffer.insert(1, '&');
                    }
                    ++itemMnemonic;
                    buffer.append(' ');
                    buffer.append(modes[i].getDisplayName());
                    Actions.setMenuText((AbstractButton)curItem, (String)buffer.toString(), (boolean)true);
                    buffer.delete(0, buffer.length());
                    HelpCtx.setHelpIDString((JComponent)curItem, (String)(class$org$netbeans$core$actions$OpenedWindowsAction == null ? WorkspaceLazyMenu.class$("org.netbeans.core.actions.OpenedWindowsAction") : class$org$netbeans$core$actions$OpenedWindowsAction).getName());
                    curItem.setName(modes[i].getName());
                    curIcon = modes[i].getIcon();
                    curItem.setIcon(new ImageIcon(curIcon == null ? OpenedWindowsAction.defaultModeIcon() : curIcon));
                    curItem.addActionListener(OpenedWindowsAction.modeSubItemListener());
                    ((JMenu)((Object)this)).add(curItem);
                }
                ++i;
            }
            if (((JMenu)((Object)this)).getMenuComponentCount() == 0) {
                ((JMenu)((Object)this)).add(OpenedWindowsAction.createEmptyMenuItem());
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static final class MainItemLazyMenu
    extends JMenuPlus {
        private Set oldWSpaces = new WeakSet();
        static /* synthetic */ Class class$org$netbeans$core$actions$OpenedWindowsAction;

        MainItemLazyMenu() {
        }

        public JPopupMenu getPopupMenu() {
            this.updatePopup();
            return super.getPopupMenu();
        }

        private void updatePopup() {
            WorkspaceLazyMenu curMenu = null;
            Workspace[] workspaces = WindowManager.getDefault().getWorkspaces();
            Workspace currWorkspace = WindowManager.getDefault().getCurrentWorkspace();
            HashSet<Workspace> wss = new HashSet<Workspace>(Arrays.asList(workspaces));
            if (this.oldWSpaces.equals(wss)) {
                return;
            }
            this.oldWSpaces = new WeakSet(wss);
            ((JMenu)((Object)this)).removeAll();
            int i = 0;
            while (i < workspaces.length) {
                if (!workspaces[i].equals(currWorkspace)) {
                    curMenu = new WorkspaceLazyMenu(workspaces[i].getName());
                    Actions.setMenuText((AbstractButton)((Object)curMenu), (String)workspaces[i].getDisplayName(), (boolean)true);
                    HelpCtx.setHelpIDString((JComponent)((Object)curMenu), (String)(class$org$netbeans$core$actions$OpenedWindowsAction == null ? MainItemLazyMenu.class$("org.netbeans.core.actions.OpenedWindowsAction") : class$org$netbeans$core$actions$OpenedWindowsAction).getName());
                    ((JMenu)((Object)this)).add((JMenuItem)((Object)curMenu));
                }
                ++i;
            }
            if (((JMenu)((Object)this)).getMenuComponentCount() == 0) {
                ((JMenu)((Object)this)).add(OpenedWindowsAction.createEmptyMenuItem());
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private final class Popup
    extends JInlineMenu
    implements Runnable {
        static /* synthetic */ Class class$org$netbeans$core$actions$OpenedWindowsAction;

        public Popup() {
            ((JComponent)((Object)this)).putClientProperty("hack.preShowUpdater", this);
        }

        public void run() {
            ArrayList<Object> listItems = new ArrayList<Object>();
            JRadioButtonMenuItem curItem = null;
            Image curIcon = null;
            WorkspaceImpl currWorkspace = (WorkspaceImpl)WindowManager.getDefault().getCurrentWorkspace();
            ModeImpl lastActivatedMode = (ModeImpl)currWorkspace.getLastActivatedMode();
            Object[] modes = currWorkspace.getModes().toArray(new ModeImpl[0]);
            Arrays.sort(modes);
            int itemMnemonic = 1;
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < modes.length) {
                if (!((ModeImpl)modes[i]).isHidden()) {
                    curItem = new JRadioButtonMenuItem();
                    if (modes[i].equals(lastActivatedMode)) {
                        curItem.setSelected(true);
                    }
                    buffer.append(itemMnemonic);
                    if (itemMnemonic < 10) {
                        buffer.insert(0, '&');
                    } else if (itemMnemonic == 10) {
                        buffer.insert(1, '&');
                    }
                    ++itemMnemonic;
                    buffer.append(' ');
                    buffer.append(((ModeImpl)modes[i]).getDisplayName());
                    Actions.setMenuText((AbstractButton)curItem, (String)buffer.toString(), (boolean)true);
                    buffer.delete(0, buffer.length());
                    HelpCtx.setHelpIDString((JComponent)curItem, (String)(class$org$netbeans$core$actions$OpenedWindowsAction == null ? Popup.class$("org.netbeans.core.actions.OpenedWindowsAction") : class$org$netbeans$core$actions$OpenedWindowsAction).getName());
                    curItem.setName(((ModeImpl)modes[i]).getName());
                    curIcon = ((ModeImpl)modes[i]).getIcon();
                    curItem.setIcon(new ImageIcon(curIcon == null ? OpenedWindowsAction.defaultModeIcon() : curIcon));
                    curItem.addActionListener(OpenedWindowsAction.modeMainItemListener());
                    listItems.add(curItem);
                }
                ++i;
            }
            if (itemMnemonic > 1) {
                listItems.add(0, null);
            }
            MainItemLazyMenu submenuItem = new MainItemLazyMenu();
            listItems.add(0, (Object)submenuItem);
            Actions.setMenuText((AbstractButton)((Object)submenuItem), (String)OpenedWindowsAction.this.getName(), (boolean)true);
            ((AbstractButton)((Object)submenuItem)).setIcon(SystemAction.get((Class)(class$org$netbeans$core$actions$OpenedWindowsAction == null ? (class$org$netbeans$core$actions$OpenedWindowsAction = Popup.class$("org.netbeans.core.actions.OpenedWindowsAction")) : class$org$netbeans$core$actions$OpenedWindowsAction)).getIcon());
            HelpCtx.setHelpIDString((JComponent)((Object)submenuItem), (String)(class$org$netbeans$core$actions$OpenedWindowsAction == null ? (class$org$netbeans$core$actions$OpenedWindowsAction = Popup.class$("org.netbeans.core.actions.OpenedWindowsAction")) : class$org$netbeans$core$actions$OpenedWindowsAction).getName());
            JMenuItem[] items = listItems.toArray(new JMenuItem[0]);
            this.setMenuItems(items);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

