/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import java.util.EventListener;
import java.util.LinkedList;
import java.util.TooManyListenersException;
import org.omg.CORBA.SystemException;
import org.openorb.io.StorageBuffer;
import org.openorb.util.Trace;

public class BufferSource {
    private int m_available = 0;
    private LinkedList m_buffers = new LinkedList();
    private SystemException m_exception = null;
    private boolean m_last_received = false;
    private boolean m_last_notified = false;
    private int m_mark_available = -1;
    private LinkedList m_previous;
    private StorageBuffer m_current;
    private transient WaitingForBufferListener m_waiting_for_buffer_listener = null;
    private transient LastMessageProcessedListener m_last_msg_processed_listener = null;

    public BufferSource() {
    }

    public BufferSource(StorageBuffer buffer, boolean isLast) {
        this.m_buffers.addLast(buffer);
        this.m_last_received = isLast;
        this.m_available += buffer.available();
    }

    public synchronized int available() {
        return this.m_available;
    }

    public synchronized StorageBuffer next() {
        while (true) {
            if (this.m_exception != null) {
                this.lastMessageProcessed();
                throw this.m_exception;
            }
            if (this.m_buffers.size() > 0) {
                StorageBuffer ret = (StorageBuffer)this.m_buffers.removeFirst();
                this.m_available -= ret.available();
                if (this.m_mark_available >= 0) {
                    this.m_previous.addLast(this.m_current);
                    ret.mark();
                }
                this.m_current = ret;
                return ret;
            }
            if (this.m_last_received) {
                this.lastMessageProcessed();
                return null;
            }
            this.waitingForBuffer();
        }
    }

    public synchronized void mark() {
        if (this.m_previous == null) {
            this.m_previous = new LinkedList();
        } else {
            this.m_previous.clear();
        }
        this.m_current.mark();
        this.m_mark_available = this.m_available;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized StorageBuffer reset() {
        if (this.m_mark_available != -1) ** GOTO lbl8
        return null;
lbl-1000:
        // 1 sources

        {
            if (!this.m_current.reset()) {
                Trace.signalIllegalCondition(null, "Unable to reset body buffer.");
            }
            this.m_buffers.addFirst(this.m_current);
            this.m_current = (StorageBuffer)this.m_previous.removeLast();
lbl8:
            // 2 sources

            ** while (!this.m_previous.isEmpty())
        }
lbl9:
        // 1 sources

        if (!this.m_current.reset()) {
            Trace.signalIllegalCondition(null, "Unable to reset body buffer.");
        }
        this.m_available = this.m_mark_available;
        this.m_mark_available = -1;
        return this.m_current;
    }

    private void waitingForBuffer() {
        if (this.m_waiting_for_buffer_listener != null && !this.m_waiting_for_buffer_listener.waitForBuffer(this)) {
            return;
        }
        try {
            this.wait();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private void lastMessageProcessed() {
        if (!this.m_last_notified && this.m_last_msg_processed_listener != null) {
            this.m_last_notified = true;
            this.m_last_msg_processed_listener.lastMessageProcessed(this);
        }
        if (this.m_exception != null) {
            throw this.m_exception;
        }
    }

    public synchronized void setException(SystemException exception) {
        if (exception == null) {
            throw new NullPointerException();
        }
        this.m_exception = exception;
        this.m_buffers = null;
        this.notify();
    }

    public synchronized SystemException getException() {
        return this.m_exception;
    }

    public synchronized void addLast(StorageBuffer buffer, boolean isLast) {
        if (this.m_exception != null) {
            return;
        }
        this.m_buffers.addLast(buffer);
        this.m_last_received = isLast;
        this.m_available += buffer.available();
        this.notify();
    }

    public synchronized void addWaitingForBufferListener(WaitingForBufferListener listener) throws TooManyListenersException {
        if (this.m_waiting_for_buffer_listener != null) {
            throw new TooManyListenersException();
        }
        this.m_waiting_for_buffer_listener = listener;
    }

    public synchronized void removeWaitingForBufferListener(WaitingForBufferListener listener) {
        this.m_waiting_for_buffer_listener = null;
    }

    public synchronized void addLastMessageProcessedListener(LastMessageProcessedListener listener) throws TooManyListenersException {
        if (this.m_last_msg_processed_listener != null) {
            throw new TooManyListenersException();
        }
        this.m_last_msg_processed_listener = listener;
    }

    public synchronized void removeLastMessageProcessedListener(LastMessageProcessedListener listener) {
        this.m_last_msg_processed_listener = null;
    }

    public static interface LastMessageProcessedListener
    extends EventListener {
        public void lastMessageProcessed(BufferSource var1);
    }

    public static interface WaitingForBufferListener
    extends EventListener {
        public boolean waitForBuffer(BufferSource var1);
    }
}

