/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.lang.reflect.Constructor;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.openorb.CORBA.kernel.ORBLoader;
import org.openorb.PI.FeatureInitInfo;
import org.openorb.iiop.IIOPAddress;
import org.openorb.net.Address;
import org.openorb.net.TransportClientInitializer;
import org.openorb.util.NumberCache;

public class IIOPTransportClientInitializer
extends AbstractLogEnabled
implements TransportClientInitializer {
    private static final Constructor IIOP_CTOR;
    private final boolean m_socketNoDelay;
    private final boolean m_boostRecvPriority;
    private final int m_sendBufferSize;
    private final int m_receiveBufferSize;
    private final int m_bufferedOutputStreamSize;
    static /* synthetic */ Class class$java$net$InetAddress;
    static /* synthetic */ Class class$org$apache$avalon$framework$logger$Logger;
    static /* synthetic */ Class class$org$openorb$iiop$IIOPTransport;

    public IIOPTransportClientInitializer(ORBInitInfo orbinfo, FeatureInitInfo featureinfo) {
        ORBLoader loader = featureinfo.getLoader();
        this.m_socketNoDelay = loader.getBooleanProperty("iiop.clientNoDelay", true);
        this.m_boostRecvPriority = loader.getBooleanProperty("iiop.boostReceivePriority", true);
        this.m_sendBufferSize = loader.getIntProperty("iiop.sendBufferSize", 0);
        this.m_receiveBufferSize = loader.getIntProperty("iiop.receiveBufferSize", 0);
        this.m_bufferedOutputStreamSize = loader.getIntProperty("iiop.bufferedOutputStreamSize", 50);
    }

    public Address[] establishTransports(Address[] addresses) {
        int i = 0;
        while (i < addresses.length) {
            IIOPAddress addr = (IIOPAddress)addresses[i];
            Object[] args = new Object[]{addr.get_host(), NumberCache.getInteger(addr.get_port()), this.getLogger(), this.m_socketNoDelay ? Boolean.TRUE : Boolean.FALSE, this.m_boostRecvPriority ? Boolean.TRUE : Boolean.FALSE, NumberCache.getInteger(this.m_sendBufferSize), NumberCache.getInteger(this.m_receiveBufferSize), NumberCache.getInteger(this.m_bufferedOutputStreamSize)};
            addresses[i].setTransportConstructor(IIOP_CTOR, args);
            ++i;
        }
        return addresses;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            IIOP_CTOR = (class$org$openorb$iiop$IIOPTransport == null ? (class$org$openorb$iiop$IIOPTransport = IIOPTransportClientInitializer.class$("org.openorb.iiop.IIOPTransport")) : class$org$openorb$iiop$IIOPTransport).getConstructor(class$java$net$InetAddress == null ? (class$java$net$InetAddress = IIOPTransportClientInitializer.class$("java.net.InetAddress")) : class$java$net$InetAddress, Integer.TYPE, class$org$apache$avalon$framework$logger$Logger == null ? (class$org$apache$avalon$framework$logger$Logger = IIOPTransportClientInitializer.class$("org.apache.avalon.framework.logger.Logger")) : class$org$apache$avalon$framework$logger$Logger, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception ex) {
            throw new CascadingRuntimeException("Exception during the construction of class IIOPTransport.", ex);
        }
    }
}

