/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.openorb.io.StorageBuffer;
import org.openorb.net.Address;
import org.openorb.net.Transport;
import org.openorb.net.TransportAssociationHolder;
import org.openorb.util.ExceptionTool;

public class IIOPTransport
implements Transport {
    private static final long MAX_CLOSE_LINGER = 1000L;
    private final boolean m_socketNoDelay;
    private final boolean m_boostRecvPriority;
    private final int m_sendBufferSize;
    private final int m_receiveBufferSize;
    private final int m_bufferedOutputStreamSize;
    private Logger m_logger;
    private InetAddress m_host = null;
    private int m_port = -1;
    private String m_connection_string;
    private Socket m_socket;
    private InputStream m_in_stream;
    private OutputStream m_out_stream;
    private byte[] m_header = null;
    private boolean m_message_error = false;
    private boolean m_remote_close = false;
    private int m_minor_version = 0;
    private boolean m_open = false;
    private static final byte[][] MESSAGE_ERROR = new byte[][]{{71, 73, 79, 80, 1, 0, 0, 6, 0, 0, 0, 0}, {71, 73, 79, 80, 1, 1, 0, 6, 0, 0, 0, 0}, {71, 73, 79, 80, 1, 2, 0, 6, 0, 0, 0, 0}};
    private static final byte[][] CLOSE_CONNECTION = new byte[][]{{71, 73, 79, 80, 1, 0, 0, 5, 0, 0, 0, 0}, {71, 73, 79, 80, 1, 1, 0, 5, 0, 0, 0, 0}, {71, 73, 79, 80, 1, 2, 0, 5, 0, 0, 0, 0}};

    public IIOPTransport(InetAddress host, int port, Logger logger) {
        this(host, port, logger, true, true, 0, 0, 0);
    }

    public IIOPTransport(InetAddress host, int port, Logger logger, boolean socketNoDelay, boolean boostRecvPriority, int sendBufferSize, int receiveBufferSize, int bufferedOutputStreamSize) {
        this.m_host = host;
        this.m_port = port;
        this.m_logger = logger;
        this.m_socketNoDelay = socketNoDelay;
        this.m_boostRecvPriority = boostRecvPriority;
        this.m_sendBufferSize = sendBufferSize;
        this.m_receiveBufferSize = receiveBufferSize;
        this.m_bufferedOutputStreamSize = bufferedOutputStreamSize;
        this.m_connection_string = this.m_host.getHostName() + ":" + this.m_port;
    }

    public IIOPTransport(Socket sock, int serverPort, Logger logger) {
        this(sock, serverPort, logger, true, true, 0, 0, 0);
    }

    public IIOPTransport(Socket sock, int serverPort, Logger logger, boolean socketNoDelay, boolean boostRecvPriority, int sendBufferSize, int receiveBufferSize, int bufferedOutputStreamSize) {
        this.m_socket = sock;
        this.m_port = serverPort;
        this.m_logger = logger;
        this.m_socketNoDelay = socketNoDelay;
        this.m_boostRecvPriority = boostRecvPriority;
        this.m_sendBufferSize = sendBufferSize;
        this.m_receiveBufferSize = receiveBufferSize;
        this.m_bufferedOutputStreamSize = bufferedOutputStreamSize;
        try {
            if (0 < this.m_sendBufferSize) {
                this.m_socket.setSendBufferSize(this.m_sendBufferSize);
            }
            if (0 < this.m_receiveBufferSize) {
                this.m_socket.setReceiveBufferSize(this.m_receiveBufferSize);
            }
            this.m_socket.setTcpNoDelay(this.m_socketNoDelay);
            this.m_in_stream = this.m_socket.getInputStream();
            this.m_out_stream = this.wrapOutputStream(this.m_socket.getOutputStream());
        }
        catch (IOException ex) {
            this.m_socket = null;
            this.getLogger().error("IOException getting input and output streams.", ex);
            throw ExceptionTool.initCause(new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO), (Throwable)ex);
        }
        this.m_open = true;
        this.m_connection_string = serverPort + " (" + this.m_socket.getLocalPort() + " <- " + this.m_socket.getInetAddress().getHostName() + ":" + this.m_socket.getPort() + ")";
    }

    private OutputStream wrapOutputStream(OutputStream out) {
        if (0 == this.m_bufferedOutputStreamSize) {
            return out;
        }
        return new BufferedOutputStream(out, this.m_bufferedOutputStreamSize);
    }

    public void open() {
        if (this.m_host == null) {
            throw new BAD_INV_ORDER();
        }
        if (this.m_open) {
            return;
        }
        this.m_message_error = false;
        this.m_remote_close = false;
        try {
            this.m_socket = this.createSocket(this.m_host, this.m_port);
            if (0 < this.m_sendBufferSize) {
                this.m_socket.setSendBufferSize(this.m_sendBufferSize);
            }
            if (0 < this.m_receiveBufferSize) {
                this.m_socket.setReceiveBufferSize(this.m_receiveBufferSize);
            }
            this.m_socket.setTcpNoDelay(this.m_socketNoDelay);
            this.m_in_stream = this.m_socket.getInputStream();
            this.m_out_stream = this.wrapOutputStream(this.m_socket.getOutputStream());
        }
        catch (NoRouteToHostException ex) {
            this.getLogger().error("No route to host. Check your network.", ex);
            throw ExceptionTool.initCause(new COMM_FAILURE("No route to host. Check your network (" + ex + ")", 1146056969, CompletionStatus.COMPLETED_NO), (Throwable)ex);
        }
        catch (ConnectException ex) {
            throw ExceptionTool.initCause(new COMM_FAILURE("Cannot connect to target (" + ex + ")", 1146056970, CompletionStatus.COMPLETED_NO), (Throwable)ex);
        }
        catch (IOException ex) {
            this.getLogger().error("IOException during connect.", ex);
            throw ExceptionTool.initCause(new COMM_FAILURE("IOException during connect (" + ex + ")", 0, CompletionStatus.COMPLETED_NO), (Throwable)ex);
        }
        this.m_open = true;
        this.m_connection_string = this.m_host.getHostName() + ":" + this.m_port + " (" + this.m_socket.getLocalPort() + " -> " + this.m_socket.getPort() + ")";
    }

    protected Socket createSocket(InetAddress host, int port) throws IOException {
        return new Socket(host, port);
    }

    public void close() {
        if (this.m_open) {
            boolean interrupt = Thread.interrupted();
            if (!this.m_remote_close) {
                try {
                    this.writeCloseMessage();
                    try {
                        this.m_socket.getClass().getMethod("shutdownOutput", null).invoke((Object)this.m_socket, null);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (this.m_message_error || this.m_minor_version == 2 || this.m_host == null) {
                        StorageBuffer recv;
                        TransportAssociationHolder tassc = new TransportAssociationHolder();
                        do {
                            tassc.setValue(null);
                            recv = this.recvMessage(1000, tassc);
                            boolean bl = interrupt = Thread.interrupted() || interrupt;
                        } while (recv != null);
                    }
                }
                catch (SystemException ex) {
                }
                catch (EOFException ex) {
                    // empty catch block
                }
            }
            this.m_open = false;
            try {
                this.m_socket.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (interrupt) {
                Thread.currentThread().interrupt();
            }
            this.m_connection_string = this.m_host != null ? this.m_host.getHostName() + ":" + this.m_port : Integer.toString(this.m_port);
        }
    }

    protected void writeCloseMessage() {
        if (this.m_message_error) {
            this.write(MESSAGE_ERROR[this.m_minor_version], 0, 12);
        } else if (this.m_minor_version == 2 || this.m_host == null) {
            this.write(CLOSE_CONNECTION[this.m_minor_version], 0, 12);
        }
    }

    public boolean isOpen() {
        return this.m_open;
    }

    public void sendMessage(StorageBuffer msg, Object assoc) {
        if (!this.m_open) {
            throw new COMM_FAILURE("Transport is closed");
        }
        try {
            msg.writeTo(this.m_out_stream);
            this.m_out_stream.flush();
        }
        catch (IOException ex) {
            this.getLogger().error("IOException while writing to output stream.", ex);
            throw ExceptionTool.initCause(new COMM_FAILURE("IOException while writing to output stream."), (Throwable)ex);
        }
    }

    protected void write(byte[] buf, int off, int len) {
        InterruptedIOException ex2;
        boolean interrupt = Thread.interrupted();
        do {
            try {
                this.m_out_stream.write(buf, off, len);
                break;
            }
            catch (InterruptedIOException ex2) {
                interrupt = true;
                off += ex2.bytesTransferred;
            }
            catch (IOException ex3) {
                throw ExceptionTool.initCause(new COMM_FAILURE(), (Throwable)ex3);
            }
        } while ((len -= ex2.bytesTransferred) > 0);
        if (interrupt) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageBuffer recvMessage(int timeout, TransportAssociationHolder assoc) throws EOFException {
        int oldPriority;
        Thread thread;
        block11: {
            if (!this.m_open) {
                throw new COMM_FAILURE("Transport is closed");
            }
            if (null == this.m_header) {
                this.m_header = new byte[12];
            }
            if (null == assoc.getValue()) {
                assoc.setValue(TransportAssociationHolder.EMPTY_ASSOCIATION);
            }
            if ((thread = Thread.currentThread()).isInterrupted()) {
                return null;
            }
            oldPriority = thread.getPriority();
            if (this.m_boostRecvPriority) {
                thread.setPriority(10);
            }
            try {
                if (this.readMagic(timeout, this.m_header, 0)) break block11;
                StorageBuffer storageBuffer = null;
                Object var10_7 = null;
                if (this.m_boostRecvPriority) {
                    thread.setPriority(oldPriority);
                }
                return storageBuffer;
            }
            catch (Throwable throwable) {
                block12: {
                    Object var10_9 = null;
                    if (!this.m_boostRecvPriority) break block12;
                    thread.setPriority(oldPriority);
                }
                throw throwable;
            }
        }
        boolean interrupt = Thread.interrupted();
        this.read(this.m_header, 4, 8);
        int bodyLength = this.checkGIOPHeader(this.m_header, 0);
        interrupt = interrupt || Thread.interrupted();
        StorageBuffer ret = this.readBuffer(this.m_header, 0, 12, bodyLength + 12);
        if (interrupt) {
            thread.interrupt();
        }
        StorageBuffer storageBuffer = ret;
        Object var10_8 = null;
        if (this.m_boostRecvPriority) {
            thread.setPriority(oldPriority);
        }
        return storageBuffer;
    }

    public void setMessageError() {
        this.m_message_error = true;
    }

    public boolean isMessageError() {
        return this.m_message_error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean readMagic(int timeout, byte[] buf, int off) throws EOFException {
        if (!this.m_open) {
            throw new COMM_FAILURE("Transport is closed");
        }
        try {
            block24: {
                interrupt = false;
                try {
                    try {
                        if (timeout > 0) {
                            this.m_socket.setSoTimeout(timeout);
                        }
                        m = this.m_in_stream.read(buf, off, 4);
                    }
                    catch (InterruptedIOException ex) {
                        if (timeout > 0 && ex.getMessage().equals("Read timed out")) {
                            var7_17 = false;
                            var10_8 = null;
                            if (timeout <= 0) return var7_17;
                            try {
                                this.m_socket.setSoTimeout(0);
                                return var7_17;
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                            return var7_17;
                        }
                        m = ex.bytesTransferred;
                        if (m == 0) {
                            Thread.currentThread().interrupt();
                            var8_19 = false;
                            var10_9 = null;
                            if (timeout <= 0) return var8_19;
                            ** try [egrp 3[TRYBLOCK] [6 : 128->139)] { 
lbl31:
                            // 1 sources

                            this.m_socket.setSoTimeout(0);
                            return var8_19;
lbl33:
                            // 1 sources

                            catch (IOException ex) {
                                // empty catch block
                            }
                            return var8_19;
                        }
                        interrupt = true;
                        var10_7 = null;
                        if (timeout > 0) {
                            try {}
                            catch (IOException ex) {}
                            this.m_socket.setSoTimeout(0);
                        }
                        break block24;
                    }
                    var10_7 = null;
                    if (timeout <= 0) break block24;
                }
                catch (Throwable var9_20) {
                    var10_10 = null;
                    if (timeout <= 0) throw var9_20;
                    ** try [egrp 3[TRYBLOCK] [6 : 128->139)] { 
lbl53:
                    // 1 sources

                    this.m_socket.setSoTimeout(0);
                    throw var9_20;
lbl55:
                    // 1 sources

                    catch (IOException ex) {
                        // empty catch block
                    }
                    throw var9_20;
                }
                try {}
                catch (IOException ex) {}
                this.m_socket.setSoTimeout(0);
            }
            if (m == 0) {
                return false;
            }
            if (m == 4) {
                return true;
            }
            if (m <= 0) throw new EOFException();
            r = m;
            while (true) {
                if (r >= 4) {
                    if (interrupt == false) return true;
                    Thread.currentThread().interrupt();
                    return true;
                }
                try {
                    m = this.m_in_stream.read(buf, off + r, 4 - r);
                    if (m < 0) {
                        throw new COMM_FAILURE("Unexpected end of stream", 1146056973, CompletionStatus.COMPLETED_MAYBE);
                    }
                }
                catch (InterruptedIOException ex) {
                    m = ex.bytesTransferred;
                    interrupt = true;
                }
                r += m;
            }
        }
        catch (IOException ex) {
            throw ExceptionTool.initCause(new COMM_FAILURE("IOException while reading from input stream (" + ex + ")", 1146056972, CompletionStatus.COMPLETED_MAYBE), (Throwable)ex);
        }
    }

    protected int checkGIOPHeader(byte[] buf, int off) throws EOFException {
        if (buf[off + 0] != 71 || buf[off + 1] != 73 || buf[off + 2] != 79 || buf[off + 3] != 80 || buf[off + 4] != 1 || buf[off + 5] > 2) {
            this.m_message_error = true;
            throw new COMM_FAILURE("Bad magic", 1146056974, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.m_minor_version < buf[off + 5]) {
            this.m_minor_version = buf[off + 5];
        }
        switch (buf[off + 7]) {
            case 5: {
                this.m_remote_close = true;
                throw new EOFException("CloseConnection message received from peer.");
            }
            case 6: {
                this.m_remote_close = true;
                throw new COMM_FAILURE("Message Error recieved from remote", 1146056974, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        boolean swap = (buf[off + 6] & 1) == 1;
        return (buf[off + 8] & 0xFF) << (swap ? 0 : 24) | (buf[off + 9] & 0xFF) << (swap ? 8 : 16) | (buf[off + 10] & 0xFF) << (swap ? 16 : 8) | (buf[off + 11] & 0xFF) << (swap ? 24 : 0);
    }

    protected final void read(byte[] buf, int off, int len) {
        if (!this.m_open) {
            throw new COMM_FAILURE("Transport is closed");
        }
        try {
            boolean interrupt = false;
            while (len > 0) {
                int r;
                try {
                    r = this.m_in_stream.read(buf, off, len);
                    if (r < 0) {
                        throw new COMM_FAILURE("Unexpected end of stream", 1146056973, CompletionStatus.COMPLETED_MAYBE);
                    }
                }
                catch (InterruptedIOException ex) {
                    interrupt = true;
                    r = ex.bytesTransferred;
                }
                off += r;
                len -= r;
            }
            if (interrupt) {
                Thread.currentThread().interrupt();
            }
        }
        catch (IOException ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("IOException while reading from input stream.", ex);
            }
            throw new COMM_FAILURE("IOException while reading from input stream", 1146056972, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    protected StorageBuffer readBuffer(byte[] head, int off, int len, int total_len) {
        if (!this.m_open) {
            throw new COMM_FAILURE("Transport is closed");
        }
        try {
            return new StorageBuffer(head, off, len, this.m_in_stream, total_len);
        }
        catch (EOFException ex) {
            this.getLogger().error("Unexpected end of stream.", ex);
            throw ExceptionTool.initCause(new COMM_FAILURE("Unexpected end of stream (" + ex + ")", 1146056973, CompletionStatus.COMPLETED_MAYBE), (Throwable)ex);
        }
        catch (IOException ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("IOException while reading from input stream.", ex);
            }
            throw ExceptionTool.initCause(new COMM_FAILURE("IOException while reading from input stream (" + ex + ")", 1146056972, CompletionStatus.COMPLETED_MAYBE), (Throwable)ex);
        }
    }

    public boolean establishAssociation(Address addr, TransportAssociationHolder binding) {
        binding.setValue(TransportAssociationHolder.EMPTY_ASSOCIATION);
        return true;
    }

    public String toString() {
        return "(iiop) " + this.getConnString();
    }

    protected String getConnString() {
        return this.m_connection_string;
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

