/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml.elements;

import java.lang.reflect.Method;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.elements.AbstractTagHandler;
import junit.framework.Assert;
import org.w3c.dom.Element;

public class EvaluateTagHandler
extends AbstractTagHandler {
    public EvaluateTagHandler(Element element, IXMLTestCase testcase) {
        super(element, testcase);
    }

    public void processElement() throws XMLException {
        this.validateElement();
        String id = this.getString("id");
        String refid = this.getString("refid");
        String method = this.getString("method");
        Object obj = this.getXMLTestCase().getProperty(refid);
        Assert.assertNotNull((String)("Refid not found:" + refid), (Object)obj);
        try {
            Class<?> clz = obj.getClass();
            Method m = clz.getMethod(method, new Class[0]);
            Object result = m.invoke(obj, new Object[0]);
            this.getXMLTestCase().addProperty(id, result);
        }
        catch (XMLException xe) {
            throw xe;
        }
        catch (Exception ex) {
            throw new XMLException("Could not execute method:" + method, (Throwable)ex, this.getElement(), this.getXMLTestCase().getPropertyCache());
        }
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkElementTagName("evaluate");
        this.checkRequiredAttribute("id");
        this.checkRequiredAttribute("refid");
        this.checkRequiredAttribute("method");
    }
}

