/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;
import org.w3c.dom.Element;

public class JTextComponentMouseEventData
extends AbstractMouseEventData {
    private JTextComponent m_comp;
    private int m_offset = -1;

    public JTextComponentMouseEventData() {
        this.setValid(false);
    }

    public JTextComponentMouseEventData(JFCTestCase testCase, JTextComponent comp) {
        this(testCase, comp, 1);
    }

    public JTextComponentMouseEventData(JFCTestCase testCase, JTextComponent comp, int numberOfClicks) {
        this(testCase, comp, numberOfClicks, 16);
    }

    public JTextComponentMouseEventData(JFCTestCase testCase, JTextComponent comp, long sleepTime) {
        this(testCase, comp, 1);
        this.setSleepTime(sleepTime);
    }

    public JTextComponentMouseEventData(JFCTestCase testCase, JTextComponent comp, int numberOfClicks, int modifiers) {
        this(testCase, comp, numberOfClicks, modifiers, false);
    }

    public JTextComponentMouseEventData(JFCTestCase testCase, JTextComponent comp, int numberOfClicks, boolean isPopupTrigger) {
        this(testCase, comp, numberOfClicks, JTextComponentMouseEventData.getDefaultModifiers(isPopupTrigger), isPopupTrigger);
    }

    public JTextComponentMouseEventData(JFCTestCase testCase, JTextComponent comp, int numberOfClicks, long sleepTime) {
        this(testCase, comp, numberOfClicks, 16, false, sleepTime);
    }

    public JTextComponentMouseEventData(JFCTestCase testCase, JTextComponent comp, int numberOfClicks, int modifiers, boolean isPopupTrigger) {
        this(testCase, comp, numberOfClicks, modifiers, isPopupTrigger, 300L);
    }

    public JTextComponentMouseEventData(JFCTestCase testCase, JTextComponent comp, int numberOfClicks, boolean isPopupTrigger, long sleepTime) {
        this(testCase, comp, numberOfClicks, JTextComponentMouseEventData.getDefaultModifiers(isPopupTrigger), isPopupTrigger, sleepTime);
    }

    public JTextComponentMouseEventData(JFCTestCase testCase, JTextComponent comp, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime) {
        this(testCase, comp, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 0, null, -1);
    }

    public JTextComponentMouseEventData(JFCTestCase testCase, JTextComponent comp, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position) {
        this(testCase, comp, numberOfClicks, modifiers, isPopupTrigger, sleepTime, position, null, -1);
    }

    public JTextComponentMouseEventData(JFCTestCase testCase, JTextComponent comp, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position, int offset) {
        this(testCase, comp, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 14, null, offset);
    }

    public JTextComponentMouseEventData(JFCTestCase testCase, JTextComponent comp, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, Point referencePoint) {
        this(testCase, comp, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 12, referencePoint, -1);
    }

    public JTextComponentMouseEventData(JFCTestCase testCase, JTextComponent comp, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position, Point referencePoint, int offset) {
        this.setTestCase(testCase);
        this.setSource(comp);
        this.setNumberOfClicks(numberOfClicks);
        this.setModifiers(modifiers);
        this.setPopupTrigger(isPopupTrigger);
        this.setSleepTime(sleepTime);
        this.setPosition(position);
        this.setReferencePoint(referencePoint);
        this.setOffset(offset);
        this.setValid(true);
    }

    public final void setOffset(int offset) {
        this.m_offset = offset;
    }

    public final int getOffset() {
        return this.m_offset;
    }

    public final void setSource(JTextComponent comp) {
        this.m_comp = comp;
    }

    public final JTextComponent getSource() {
        return this.m_comp;
    }

    public Component getComponent() {
        return this.getSource();
    }

    public boolean canConsume(AWTEvent ae) {
        return ae.getSource() instanceof JTextComponent && super.canConsume(ae) && this.sameSource(ae);
    }

    public boolean consume(AWTEvent ae) {
        if (super.consume(ae)) {
            return true;
        }
        MouseEvent me = (MouseEvent)ae;
        JTextComponent source = (JTextComponent)me.getSource();
        this.setSource(source);
        this.setModifiers(me.getModifiers());
        this.setNumberOfClicks(me.getClickCount());
        this.setPopupTrigger(me.isPopupTrigger());
        Point p = new Point(me.getX(), me.getY());
        Point screen = source.getLocationOnScreen();
        screen.translate(p.x, p.y);
        this.setLocationOnScreen(screen);
        int offset = source.viewToModel(p);
        this.setOffset(offset);
        this.setPosition(0);
        this.setReferencePoint(null);
        this.setSleepTime(this.getDefaultSleepTime());
        this.setValid(true);
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof JTextComponentMouseEventData)) {
            return false;
        }
        JTextComponentMouseEventData data = (JTextComponentMouseEventData)o;
        return super.equals(o) && data.getOffset() == this.getOffset();
    }

    public int hashCode() {
        return super.hashCode() + this.m_offset;
    }

    public void populate(Element e) {
        super.populate(e);
        e.setAttribute("type", "JTextComponentMouseEventData");
        e.setAttribute("index", "" + this.getOffset());
    }

    public boolean prepareComponent() {
        if (!this.isValidForProcessing(this.getSource())) {
            return false;
        }
        Point p = null;
        if (this.getPosition() == 14) {
            this.setPosition(3);
            if (this.m_offset == -1 || this.m_offset > this.m_comp.getDocument().getLength()) {
                this.m_offset = this.m_comp.getDocument().getLength();
            }
            Rectangle rect = null;
            try {
                rect = this.m_comp.modelToView(this.m_offset);
            }
            catch (BadLocationException ex) {
                throw new RuntimeException("Invalid Offset:" + this.m_offset + ":" + ex);
            }
            p = this.calculatePoint(rect);
        } else {
            p = this.calculatePoint(this.m_comp.getBounds());
        }
        Point screen = this.m_comp.getLocationOnScreen();
        screen.translate(p.x, p.y);
        this.setLocationOnScreen(screen);
        return true;
    }

    public String toString() {
        if (!this.isValid()) {
            return super.toString();
        }
        StringBuffer buf = new StringBuffer(1000);
        buf.append(super.toString());
        buf.append(" offset: " + this.getOffset());
        return buf.toString();
    }
}

