/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakSet;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.WaitableResult;

final class SimpleProxyLookup
extends Lookup {
    private Lookup.Provider provider;
    private Lookup delegate;
    private WeakSet results;

    SimpleProxyLookup(Lookup.Provider provider) {
        this.provider = provider;
    }

    private Lookup checkLookup() {
        Lookup l = this.provider.getLookup();
        Iterator<Object> toCheck = null;
        SimpleProxyLookup simpleProxyLookup = this;
        synchronized (simpleProxyLookup) {
            if (l != this.delegate) {
                this.delegate = l;
                if (this.results != null) {
                    toCheck = Arrays.asList(this.results.toArray()).iterator();
                }
            }
        }
        if (toCheck != null) {
            Iterator<Object> it = toCheck;
            while (it.hasNext()) {
                ProxyResult p = (ProxyResult)it.next();
                if (!p.updateLookup(l)) continue;
                p.resultChanged(null);
            }
        }
        return this.delegate;
    }

    public Lookup.Result lookup(Lookup.Template template) {
        ProxyResult p = new ProxyResult(template);
        SimpleProxyLookup simpleProxyLookup = this;
        synchronized (simpleProxyLookup) {
            if (this.results == null) {
                this.results = new WeakSet();
            }
            this.results.add(p);
        }
        return p;
    }

    public Object lookup(Class clazz) {
        return this.checkLookup().lookup(clazz);
    }

    public Lookup.Item lookupItem(Lookup.Template template) {
        return this.checkLookup().lookupItem(template);
    }

    private final class ProxyResult
    extends WaitableResult
    implements LookupListener {
        private Lookup.Template template;
        private Lookup.Result delegate;
        private EventListenerList listeners;
        static /* synthetic */ Class class$org$openide$util$LookupListener;

        ProxyResult(Lookup.Template template) {
            this.template = template;
        }

        private Lookup.Result checkResult() {
            this.updateLookup(SimpleProxyLookup.this.checkLookup());
            return this.delegate;
        }

        public boolean updateLookup(Lookup l) {
            Collection oldPairs = this.delegate != null ? this.delegate.allItems() : null;
            ProxyResult proxyResult = this;
            synchronized (proxyResult) {
                if (this.delegate != null) {
                    this.delegate.removeLookupListener(this);
                }
                this.delegate = l.lookup(this.template);
                this.delegate.addLookupListener(this);
            }
            if (oldPairs == null) {
                return false;
            }
            Collection newPairs = this.delegate.allItems();
            return !oldPairs.equals(newPairs);
        }

        public synchronized void addLookupListener(LookupListener l) {
            if (this.listeners == null) {
                this.listeners = new EventListenerList();
            }
            this.listeners.add(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = ProxyResult.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener, l);
        }

        public synchronized void removeLookupListener(LookupListener l) {
            if (this.listeners != null) {
                this.listeners.remove(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = ProxyResult.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener, l);
            }
        }

        public Collection allInstances() {
            return this.checkResult().allInstances();
        }

        public Set allClasses() {
            return this.checkResult().allClasses();
        }

        public Collection allItems() {
            return this.checkResult().allItems();
        }

        protected void beforeLookup(Lookup.Template t) {
            Lookup.Result r = this.checkResult();
            if (r instanceof WaitableResult) {
                ((WaitableResult)r).beforeLookup(t);
            }
        }

        public void resultChanged(LookupEvent anEvent) {
            EventListenerList l = this.listeners;
            if (l == null) {
                return;
            }
            Object[] listeners = l.getListenerList();
            if (listeners.length == 0) {
                return;
            }
            LookupEvent ev = new LookupEvent(this);
            AbstractLookup.notifyListeners(listeners, ev);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

