/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;

public class ReaderInputStream
extends InputStream {
    private Reader reader;
    private PipedInputStream pis;
    private PipedOutputStream pos;
    private OutputStreamWriter osw;

    public ReaderInputStream(Reader reader) throws IOException {
        this(reader, "ISO-8859-1");
    }

    public ReaderInputStream(Reader reader, String encoding) throws IOException {
        this.reader = reader;
        this.pos = new PipedOutputStream();
        this.pis = new PipedInputStream(this.pos);
        this.osw = new OutputStreamWriter((OutputStream)this.pos, encoding);
    }

    public int read() throws IOException {
        if (this.pis.available() > 0) {
            return this.pis.read();
        }
        int c = this.reader.read();
        if (c == -1) {
            return c;
        }
        this.osw.write(c);
        this.osw.flush();
        return this.pis.read();
    }

    public long skip(long n) throws IOException {
        return this.reader.skip(n);
    }

    public int available() throws IOException {
        return 0;
    }

    public void close() throws IOException {
        this.reader.close();
        this.osw.close();
        this.pis.close();
    }
}

