/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.ReferencesResolver;

class DefaultResolver
implements ReferencesResolver {
    private static final String NAME_DELIMITER = "/";
    private static final String DOT = ".";
    private static final String DOUBLE_DOT = "..";

    DefaultResolver() {
    }

    public FileObject find(URL ref, FileObject base) {
        FileObject[] f;
        if ("nbfs".equals(ref.getProtocol()) && (f = URLMapper.findFileObjects(ref)).length > 0) {
            return f[0];
        }
        return this.resolveRelativeName(ref.getPath(), base);
    }

    public URL translateURL(URL ref, FileObject base) {
        if (!"nbfs".equals(ref.getProtocol())) {
            return ref;
        }
        FileObject[] f = URLMapper.findFileObjects(ref);
        if (f.length == 0) {
            return ref;
        }
        try {
            return this.createRelativeURL(f[0], base);
        }
        catch (MalformedURLException e) {
            ErrorManager.getDefault().notify(e);
            return ref;
        }
    }

    private FileObject resolveRelativeName(String relPath, FileObject base) {
        if (relPath.length() == 0) {
            return base;
        }
        if (relPath.startsWith(NAME_DELIMITER)) {
            try {
                base = base.getFileSystem().getRoot();
            }
            catch (IOException ex) {
                return null;
            }
        } else {
            base = base.getParent();
        }
        StringTokenizer t = new StringTokenizer(relPath, NAME_DELIMITER);
        while (t.hasMoreElements() && base != null) {
            int index;
            String token = t.nextToken();
            if (token.length() == 0 || token.equals(DOT)) continue;
            base = token.equals(DOUBLE_DOT) ? base.getParent() : ((index = token.lastIndexOf(DOT)) != -1 ? base.getFileObject(token.substring(0, index), token.substring(index + 1)) : base.getFileObject(token));
        }
        return base;
    }

    private URL createRelativeURL(FileObject to, FileObject from) throws MalformedURLException {
        if (to.equals(from)) {
            return new URL("file:.");
        }
        LinkedList l1 = new LinkedList();
        LinkedList l2 = new LinkedList();
        this.createPath(from, l1);
        this.createPath(to, l2);
        int s1 = l1.size();
        int skip = 0;
        Iterator it1 = l1.iterator();
        Iterator it2 = l2.iterator();
        FileObject f1 = null;
        FileObject f2 = null;
        while (it1.hasNext() && it2.hasNext()) {
            f1 = (FileObject)it1.next();
            if (f1 != (f2 = (FileObject)it2.next())) break;
            ++skip;
        }
        StringBuffer relName = new StringBuffer(50);
        while (skip < s1 - 1) {
            relName.append("../");
            ++skip;
        }
        if (f2 != null) {
            relName.append(f2.getNameExt());
        }
        while (it2.hasNext()) {
            f2 = (FileObject)it2.next();
            relName.append('/');
            relName.append(f2.getNameExt());
        }
        return new URL("file:" + relName.toString());
    }

    private void createPath(FileObject f, LinkedList l) {
        while (!f.isRoot()) {
            l.addFirst(f);
            f = f.getParent();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }
}

