/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Graphics;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.Map;
import java.util.WeakHashMap;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeNode;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.view.NodeTableModel;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

class TableSheetCell
extends AbstractCellEditor
implements TableModelListener,
PropertyChangeListener,
TableCellEditor,
TableCellRenderer {
    private NodeTableModel tableModel;
    private Boolean flat;
    private WrapperPropertyModel propModel;
    private Node node;
    private Node.Property prop;
    private TableCellRenderer headerRenderer = new JTableHeader().getDefaultRenderer();
    private NullPanel nullPanel;
    private Border nullPanelBorder;
    private Border nullPanelFocusBorder;
    private Map panelCache = new WeakHashMap();
    static /* synthetic */ Class class$org$openide$explorer$view$TableSheetCell;

    public TableSheetCell(NodeTableModel tableModel) {
        this.tableModel = tableModel;
        this.setFlat(false);
    }

    public void setFlat(boolean f) {
        this.nullPanelBorder = f ? new EmptyBorder(1, 1, 1, 1) : new CompoundBorder(new MatteBorder(0, 0, 1, 1, UIManager.getColor("controlDkShadow")), new MatteBorder(1, 1, 0, 0, UIManager.getColor("controlLtHighlight")));
        this.nullPanelFocusBorder = new CompoundBorder(new CompoundBorder(this.nullPanelBorder, new EmptyBorder(1, 1, 1, 1)), new MatteBorder(1, 1, 1, 1, UIManager.getColor("Button.focus")));
        this.flat = f ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object getCellEditorValue() {
        return null;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
        this.prop = (Node.Property)value;
        this.node = this.tableModel.nodeForRow(r);
        this.propModel = new WrapperPropertyModel(this.node, this.prop);
        this.node.addPropertyChangeListener(this);
        this.tableModel.addTableModelListener(this);
        FocusHackedPropertyPanel propPanel = new FocusHackedPropertyPanel(this.propModel, this.prop.canWrite() ? 0 : 1);
        propPanel.putClientProperty("flat", this.flat);
        propPanel.setBackground(table.getSelectionBackground());
        return propPanel;
    }

    public boolean shouldSelectCell(EventObject ev) {
        return true;
    }

    public boolean isCellEditable(EventObject e) {
        return true;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                if (TableSheetCell.this.propModel != null) {
                    TableSheetCell.this.propModel.firePropertyChange();
                }
            }
        });
    }

    public boolean stopCellEditing() {
        if (this.prop != null) {
            this.detachEditor();
        }
        return super.stopCellEditing();
    }

    public void cancelCellEditing() {
        if (this.prop != null) {
            this.detachEditor();
        }
        super.cancelCellEditing();
    }

    public void tableChanged(TableModelEvent e) {
        this.cancelCellEditing();
    }

    private void detachEditor() {
        this.node.removePropertyChangeListener(this);
        this.tableModel.removeTableModelListener(this);
        this.node = null;
        this.prop = null;
        this.propModel = null;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (row == -1) {
            Component comp = this.headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (comp instanceof JComponent) {
                String tip = column > 0 ? this.tableModel.propertyForColumn(column).getShortDescription() : table.getColumnName(0);
                ((JComponent)comp).setToolTipText(tip);
            }
            return comp;
        }
        Node.Property prop = (Node.Property)value;
        Node node = this.tableModel.nodeForRow(row);
        if (prop != null) {
            FocusedPropertyPanel propPanel = this.obtainPanel(node, prop);
            propPanel.setFocused(hasFocus);
            propPanel.setToolTipText(prop.getShortDescription());
            propPanel.setOpaque(true);
            if (isSelected) {
                propPanel.setBackground(table.getSelectionBackground());
            } else {
                propPanel.setBackground(table.getBackground());
            }
            return propPanel;
        }
        if (this.nullPanel == null) {
            this.nullPanel = new NullPanel(node);
            this.nullPanel.setOpaque(true);
        } else {
            this.nullPanel.setNode(node);
        }
        if (isSelected) {
            this.nullPanel.setBackground(table.getSelectionBackground());
        } else {
            this.nullPanel.setBackground(table.getBackground());
        }
        if (hasFocus) {
            this.nullPanel.setBorder(this.nullPanelFocusBorder);
        } else {
            this.nullPanel.setBorder(this.nullPanelBorder);
        }
        return this.nullPanel;
    }

    private FocusedPropertyPanel obtainPanel(Node node, Node.Property prop) {
        FocusedPropertyPanel propPanel = null;
        TreeNode visualizer = Visualizer.findVisualizer(node);
        WeakHashMap<Node.Property, FocusedPropertyPanel> innerCache = (WeakHashMap<Node.Property, FocusedPropertyPanel>)this.panelCache.get(visualizer);
        if (innerCache == null) {
            innerCache = new WeakHashMap<Node.Property, FocusedPropertyPanel>();
            propPanel = TableSheetCell.createPropPanel(node, prop);
            propPanel.putClientProperty("flat", this.flat);
            innerCache.put(prop, propPanel);
            this.panelCache.put(visualizer, innerCache);
        } else {
            propPanel = (FocusedPropertyPanel)innerCache.get(prop);
            if (propPanel == null) {
                propPanel = TableSheetCell.createPropPanel(node, prop);
                propPanel.putClientProperty("flat", this.flat);
                innerCache.put(prop, propPanel);
            } else {
                ((WrapperPropertyModel)propPanel.getModel()).firePropertyChange();
            }
        }
        return propPanel;
    }

    private static FocusedPropertyPanel createPropPanel(Node node, Node.Property prop) {
        WrapperPropertyModel propModel = new WrapperPropertyModel(node, prop);
        FocusedPropertyPanel propPanel = new FocusedPropertyPanel(propModel, 0);
        return propPanel;
    }

    private static String getString(String key) {
        return NbBundle.getBundle(class$org$openide$explorer$view$TableSheetCell == null ? (class$org$openide$explorer$view$TableSheetCell = TableSheetCell.class$("org.openide.explorer.view.TableSheetCell")) : class$org$openide$explorer$view$TableSheetCell).getString(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FocusHackedPropertyPanel
    extends PropertyPanel {
        public FocusHackedPropertyPanel(PropertyModel model, int preferences) {
            super(model, preferences);
        }

        public void requestFocus() {
            this.requestDefaultFocus();
        }

        public void addNotify() {
            super.addNotify();
            this.requestFocus();
        }
    }

    private static class FocusedPropertyPanel
    extends PropertyPanel {
        boolean focused;

        public FocusedPropertyPanel(PropertyModel model, int preferences) {
            super(model, preferences);
        }

        public void setFocused(boolean focused) {
            this.focused = focused;
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this.focused) {
                g.setColor(UIManager.getColor("Button.focus"));
                g.drawRect(2, 1, this.getWidth() - 5, this.getHeight() - 4);
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleFocusedPropertyPanel();
            }
            return this.accessibleContext;
        }

        private class AccessibleFocusedPropertyPanel
        extends JComponent.AccessibleJComponent {
            AccessibleFocusedPropertyPanel() {
                super(FocusedPropertyPanel.this);
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PANEL;
            }

            public String getAccessibleName() {
                FeatureDescriptor fd = ((ExPropertyModel)FocusedPropertyPanel.this.getModel()).getFeatureDescriptor();
                PropertyEditor editor = FocusedPropertyPanel.this.getPropertyEditor();
                return MessageFormat.format(TableSheetCell.getString("ACS_PropertyPanelRenderer"), fd.getDisplayName(), editor == null ? TableSheetCell.getString("CTL_No_value") : editor.getAsText());
            }

            public String getAccessibleDescription() {
                FeatureDescriptor fd = ((ExPropertyModel)FocusedPropertyPanel.this.getModel()).getFeatureDescriptor();
                Node node = (Node)((ExPropertyModel)FocusedPropertyPanel.this.getModel()).getBeans()[0];
                Class clazz = FocusedPropertyPanel.this.getModel().getPropertyType();
                return MessageFormat.format(TableSheetCell.getString("ACSD_PropertyPanelRenderer"), fd.getShortDescription(), clazz == null ? TableSheetCell.getString("CTL_No_type") : clazz.getName(), node.getDisplayName());
            }
        }
    }

    private static class NullPanel
    extends JPanel {
        private WeakReference weakNode;

        NullPanel(Node node) {
            this.weakNode = new WeakReference<Node>(node);
        }

        void setNode(Node node) {
            this.weakNode = new WeakReference<Node>(node);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleNullPanel();
            }
            return this.accessibleContext;
        }

        private class AccessibleNullPanel
        extends JPanel.AccessibleJPanel {
            AccessibleNullPanel() {
                super(NullPanel.this);
            }

            public String getAccessibleName() {
                String name = super.getAccessibleName();
                if (name == null) {
                    name = TableSheetCell.getString("ACS_NullPanel");
                }
                return name;
            }

            public String getAccessibleDescription() {
                Node node;
                String description = super.getAccessibleDescription();
                if (description == null && (node = (Node)NullPanel.this.weakNode.get()) != null) {
                    description = MessageFormat.format(TableSheetCell.getString("ACSD_NullPanel"), node.getDisplayName());
                }
                return description;
            }
        }
    }

    private static class WrapperPropertyModel
    implements ExPropertyModel {
        PropertyChangeSupport support = new PropertyChangeSupport(this);
        Node.Property prop;
        Node node;

        public WrapperPropertyModel(Node node, Node.Property prop) {
            this.prop = prop;
            this.node = node;
        }

        public Object getValue() throws InvocationTargetException {
            try {
                return this.prop.getValue();
            }
            catch (IllegalAccessException e) {
                ErrorManager.getDefault().notify(1, e);
                throw new InvocationTargetException(e);
            }
        }

        public void setValue(Object v) throws InvocationTargetException {
            if (!this.prop.canWrite()) {
                return;
            }
            try {
                this.prop.setValue(v);
            }
            catch (IllegalAccessException e) {
                ErrorManager.getDefault().notify(1, e);
                throw new InvocationTargetException(e);
            }
        }

        public Class getPropertyType() {
            return this.prop.getValueType();
        }

        public Class getPropertyEditorClass() {
            return this.prop.getPropertyEditor().getClass();
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.support.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.support.removePropertyChangeListener(l);
        }

        public void firePropertyChange() {
            this.support.firePropertyChange("value", null, null);
        }

        public Object[] getBeans() {
            return new Object[]{this.node};
        }

        public FeatureDescriptor getFeatureDescriptor() {
            return this.prop;
        }
    }
}

