/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws;

import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.transport.TransportServerSupport;
import org.apache.activemq.transport.ws.StompServlet;
import org.apache.activemq.util.ServiceStopper;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;

public class WSTransportServer
extends TransportServerSupport {
    private URI bindAddress;
    private Server server;
    private Connector connector;

    public WSTransportServer(URI location) {
        super(location);
        this.bindAddress = location;
    }

    protected void doStart() throws Exception {
        this.server = new Server();
        if (this.connector == null) {
            this.connector = new SocketConnector();
        }
        this.connector.setHost(this.bindAddress.getHost());
        this.connector.setPort(this.bindAddress.getPort());
        this.server.setConnectors(new Connector[]{this.connector});
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setContextPath("/");
        contextHandler.setServer(this.server);
        this.server.setHandler((Handler)contextHandler);
        SessionHandler sessionHandler = new SessionHandler();
        contextHandler.setHandler((Handler)sessionHandler);
        ServletHandler servletHandler = new ServletHandler();
        sessionHandler.setHandler((Handler)servletHandler);
        ServletHolder holder = new ServletHolder();
        holder.setName("WSStomp");
        holder.setClassName(StompServlet.class.getName());
        servletHandler.setServlets(new ServletHolder[]{holder});
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName("WSStomp");
        mapping.setPathSpec("/*");
        servletHandler.setServletMappings(new ServletMapping[]{mapping});
        contextHandler.setAttribute("acceptListener", (Object)this.getAcceptListener());
        this.server.start();
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        Server temp = this.server;
        this.server = null;
        if (temp != null) {
            temp.stop();
        }
    }

    public InetSocketAddress getSocketAddress() {
        return null;
    }

    public void setBrokerInfo(BrokerInfo brokerInfo) {
    }
}

