// -*- C++ -*-
// ============================================================================
/**
 *  @file   MyTypeSupportImpl.h
 *
 *  $Id: MyTypeSupportImpl.h 3496 2010-07-23 21:39:08Z mitza $
 *
 *
 */
// ============================================================================


#ifndef MYTYPESUPPORTIMPL_H_
#define MYTYPESUPPORTIMPL_H_

#include "dds/DdsDcpsDataWriterRemoteC.h"
#include "dds/DdsDcpsDataReaderRemoteC.h"
#include "dds/DCPS/DataReaderImpl.h"
#include "dds/DCPS/DataWriterImpl.h"
#include "MyTypeSupportS.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
#pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

/**
 * @class MyTypeSupportImpl
 *
 * @brief An implementation of a TypeSupport
 *
 */
class MyTypeSupportImpl : public virtual OpenDDS::DCPS::LocalObject<MyTypeSupport>
{

public:
  //Constructor
  MyTypeSupportImpl (void);

  //Destructor
  virtual ~MyTypeSupportImpl (void);


  virtual ::DDS::ReturnCode_t register_type (
      ::DDS::DomainParticipant_ptr participant,
      const char * type_name
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

  virtual
  char * get_type_name (
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

  virtual ::DDS::DataWriter_ptr create_datawriter (
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

  virtual ::DDS::DataReader_ptr create_datareader (
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

#ifndef OPENDDS_NO_CONTENT_SUBSCRIPTION_PROFILE
  virtual ::DDS::DataReader_ptr create_multitopic_datareader()
    ACE_THROW_SPEC ((CORBA::SystemException));

  virtual const OpenDDS::DCPS::MetaStruct& getMetaStructForType();
#endif
};

class MyDataReaderImpl :  public virtual OpenDDS::DCPS::DataReaderImpl
{
public:
  virtual ::DDS::ReturnCode_t enable_specific (
      )
      ACE_THROW_SPEC ((
        CORBA::SystemException
        )) { return ::DDS::RETCODE_OK;};

  virtual ::DDS::ReturnCode_t auto_return_loan (void *)
  {
    return ::DDS::RETCODE_ERROR;
  }

  virtual void purge_data(OpenDDS::DCPS::SubscriptionInstance*) {}
  virtual void release_instance_i(DDS::InstanceHandle_t) {}
  virtual void dds_demarshal(const OpenDDS::DCPS::ReceivedDataSample&,
                             OpenDDS::DCPS::SubscriptionInstance *&,
                             bool &,
                             bool &) {}
  virtual void dec_ref_data_element(OpenDDS::DCPS::ReceivedDataElement *) {}
  virtual void delete_instance_map (void *) {}
  bool contains_sample_filtered(DDS::SampleStateMask, DDS::ViewStateMask,
    DDS::InstanceStateMask, const OpenDDS::DCPS::FilterEvaluator&,
    const DDS::StringSeq&) { return true; }
  virtual void lookup_instance(const OpenDDS::DCPS::ReceivedDataSample&,
                               OpenDDS::DCPS::SubscriptionInstance*&) {}

#ifndef OPENDDS_NO_CONTENT_SUBSCRIPTION_PROFILE
  DDS::ReturnCode_t read_generic(
    OpenDDS::DCPS::DataReaderImpl::GenericBundle&, DDS::SampleStateMask,
    DDS::ViewStateMask, DDS::InstanceStateMask);

  DDS::InstanceHandle_t lookup_instance_generic(const void* data);

  DDS::ReturnCode_t read_instance_generic(void*& data,
    DDS::SampleInfo& info, DDS::InstanceHandle_t instance,
    DDS::SampleStateMask sample_states, DDS::ViewStateMask view_states,
    DDS::InstanceStateMask instance_states);

  DDS::ReturnCode_t read_next_instance_generic(void*&,
    DDS::SampleInfo&, DDS::InstanceHandle_t, DDS::SampleStateMask,
    DDS::ViewStateMask, DDS::InstanceStateMask);

  void set_instance_state(DDS::InstanceHandle_t, DDS::InstanceStateKind)
  {}
#endif
};

class MyDataWriterImpl :  public virtual OpenDDS::DCPS::DataWriterImpl
{
public:
  virtual ::DDS::ReturnCode_t enable_specific (
      )
      ACE_THROW_SPEC ((
        CORBA::SystemException
        )) {return ::DDS::RETCODE_OK;};
};

#endif /* MYTYPESUPPORTIMPL_H_  */
