/*
 * $Id: TransportRegistry.java 2842 2010-01-04 06:46:03Z stallions $
 *
 * Copyright 2010 Object Computing, Inc.
 *
 * Distributed under the OpenDDS License.
 * See: http://www.opendds.org/license.html
 */

package org.opendds.jms.transport.spi;

import org.opendds.jms.common.spi.ServiceRegistry;

/**
 * @author  Steven Stallion
 * @version $Revision: 2842 $
 */
public class TransportRegistry extends ServiceRegistry<Transport> {

    protected Class<Transport> getProviderClass() {
        return Transport.class;
    }

    public Transport findTransport(String name) {
        assert name != null;

        for (Transport transport : providers) {
            if (name.equals(transport.getName())) {
                return transport;
            }
        }
        return null;
    }
}
