/*
 * $Id: DataReaderHandlePair.java 2842 2010-01-04 06:46:03Z stallions $
 *
 * Copyright 2010 Object Computing, Inc.
 *
 * Distributed under the OpenDDS License.
 * See: http://www.opendds.org/license.html
 */

package org.opendds.jms;

import OpenDDS.JMS.MessagePayloadDataReader;

/**
 * An alternative representation of a MessagePayload that is used by SessionImpl during
 * the acknowledgement phase of the Message consumption
 *
 * @author  Weiqi Gao
 * @version $Revision: 2842 $
 */
public class DataReaderHandlePair {
    private MessagePayloadDataReader dataReader;
    private int instanceHandle;

    public DataReaderHandlePair(MessagePayloadDataReader dataReader, int instanceHandle) {
        this.dataReader = dataReader;
        this.instanceHandle = instanceHandle;
    }

    public MessagePayloadDataReader getDataReader() {
        return dataReader;
    }

    public int getInstanceHandle() {
        return instanceHandle;
    }
}
