/*
 * $Id: idl2jni_BaseJavaPeer.h 2842 2010-01-04 06:46:03Z stallions $
 *
 * Copyright 2010 Object Computing, Inc.
 *
 * Distributed under the OpenDDS License.
 * See: http://www.opendds.org/license.html
 */

#ifndef idl2jni_BaseJavaPeer_H
#define idl2jni_BaseJavaPeer_H

#include "idl2jni_runtime_Export.h"
#include "idl2jni_runtime.h"
#include "idl2jni_jni.h"
#include "tao/LocalObject.h"

class idl2jni_runtime_Export IDL2JNI_BaseJavaPeer
  : public virtual TAO_Local_RefCounted_Object {
public:
  IDL2JNI_BaseJavaPeer(JNIEnv *jni, jobject local)
    : globalCallback_(jni->NewGlobalRef(local))
    , cl_(jni->NewGlobalRef(getContextClassLoader(jni)))
  {
    jni->GetJavaVM(&jvm_);
  }

  virtual ~IDL2JNI_BaseJavaPeer();

protected:
  jobject globalCallback_;
  jobject cl_;
  JavaVM *jvm_;

private: //unimplemented
  IDL2JNI_BaseJavaPeer(const IDL2JNI_BaseJavaPeer&);
  IDL2JNI_BaseJavaPeer &operator= (const IDL2JNI_BaseJavaPeer&);
};

#endif
