/*
 * $Id: DWPeriodicMonitorImpl.cpp 2842 2010-01-04 06:46:03Z stallions $
 *
 * Copyright 2010 Object Computing, Inc.
 *
 * Distributed under the OpenDDS License.
 * See: http://www.opendds.org/license.html
 */

#include "DWPeriodicMonitorImpl.h"
#include "monitorC.h"
#include "monitorTypeSupportImpl.h"
#include "dds/DCPS/DataWriterImpl.h"
#include <dds/DdsDcpsInfrastructureC.h>
#include <dds/DCPS/transport/framework/TheTransportFactory.h>

namespace OpenDDS {
namespace DCPS {


DWPeriodicMonitorImpl::DWPeriodicMonitorImpl(DataWriterImpl* dw,
              OpenDDS::DCPS::DataWriterPeriodicReportDataWriter_ptr dw_per_writer)
  : dw_(dw),
    dw_per_writer_(DataWriterPeriodicReportDataWriter::_duplicate(dw_per_writer))
{
}

DWPeriodicMonitorImpl::~DWPeriodicMonitorImpl()
{
}

void
DWPeriodicMonitorImpl::report() {
  if (!CORBA::is_nil(this->dw_per_writer_.in())) {
    DataWriterPeriodicReport report;
    report.dw_id   = dw_->get_publication_id();
    //report.data_dropped_count = dw_->
    //report.data_delivered_count  = dw_->
    //report.control_dropped_count  = dw_->
    //report.control_delivered_count  = dw_->
    //report.associations  = dw_->
    this->dw_per_writer_->write(report, DDS::HANDLE_NIL);
  }
}


} // namespace DCPS
} // namespace OpenDDS

