/*
 * $Id: UdpFactory.cpp 2842 2010-01-04 06:46:03Z stallions $
 *
 * Copyright 2010 Object Computing, Inc.
 *
 * Distributed under the OpenDDS License.
 * See: http://www.opendds.org/license.html
 */

#include "UdpFactory.h"
#include "UdpTransport.h"

namespace OpenDDS {
namespace DCPS {

int
UdpFactory::requires_reactor() const
{
  return 1;  // require reactor
}

TransportImpl*
UdpFactory::create()
{
  TransportImpl* transport_impl;
  ACE_NEW_RETURN(transport_impl, UdpTransport, 0);
  return transport_impl;
}

} // namespace DCPS
} // namespace OpenDDS
