/*
 * $Id: SimpleTcpGenerator.h 2842 2010-01-04 06:46:03Z stallions $
 *
 * Copyright 2010 Object Computing, Inc.
 *
 * Distributed under the OpenDDS License.
 * See: http://www.opendds.org/license.html
 */

#ifndef SIMPLETCP_GENERATOR_H
#define SIMPLETCP_GENERATOR_H

#include "SimpleTcp_export.h"

#include "dds/DCPS/transport/framework/TransportGenerator.h"
#include "ace/Synch.h"

namespace OpenDDS {
namespace DCPS {

class SimpleTcp_Export SimpleTcpGenerator : public TransportGenerator {
public:

  /// Default ctor.
  SimpleTcpGenerator();

  /// Dtor
  virtual ~SimpleTcpGenerator();

  /// Provide a new SimpleTcpFactory instance.
  virtual TransportImplFactory* new_factory();

  /// Provide a new SimpleTcpConfiguration instance.
  virtual TransportConfiguration* new_configuration(const TransportIdType id);

  /// Provide a list of default transport id.
  virtual void default_transport_ids(TransportIdList & ids);
};

} // namespace DCPS
} // namespace OpenDDS

#endif
