/*
 *                         OpenSplice DDS
 *
 *   This software and documentation are Copyright 2006 to 2009 PrismTech 
 *   Limited and its licensees. All rights reserved. See file:
 *
 *                     $OSPL_HOME/LICENSE 
 *
 *   for full copyright notice and license terms. 
 *
 */
/*
 * The contents of this file is private to SPLICE-DDS and not meant for use by
 * any application other then application code generated by SPLICE-DDS tooling.
 */

#ifndef DDS_DCPS_PRIVATE_H
#define DDS_DCPS_PRIVATE_H

#include <dds_dcps.h>
#include <os_if.h>

#ifdef OSPL_BUILD_DCPSSAC
#define OS_API OS_API_EXPORT
#else
#define OS_API OS_API_IMPORT
#endif
/* !!!!!!!!NOTE From here no more includes are allowed!!!!!!! */

typedef void *(*bufferAllocatorType)(DDS_unsigned_long len);

OS_API DDS_char *
DDS_string_dup (
    DDS_char *src);

OS_API void *
DDS__malloc (
    void (*ff)(void *),
    DDS_unsigned_long hl,
    DDS_unsigned_long len);

OS_API void
DDS__free (
    void *object);

OS_API void *
DDS__header (
    void *object);

OS_API void *
DDS_alloc (
    DDS_unsigned_long l);

OS_API void
DDS_free (
    void *a);

OS_API DDS_char *
DDS_string_alloc (
    DDS_unsigned_long len);

OS_API DDS_char *
DDS_string_dup (
    DDS_char *src);

OS_API void 
DDS_string_clean (
    DDS_char **string);

OS_API void 
DDS_string_replace (
    DDS_char *src,
    DDS_char **dst);

OS_API void 
DDS_sequence_free (
    void *sequence);

OS_API void 
DDS_sequence_clean (
    void *sequence);

OS_API void
DDS_sequence_replacebuf (
    void *sequence,
    bufferAllocatorType allocbuf,
    DDS_unsigned_long count);

OS_API void *
DDS_sequence_create (
    dealloactorType deallocator,
    DDS_unsigned_long len,
    DDS_unsigned_long count);

#undef OS_API
#endif /* DDS_DCPS_PRIVATE_H */
