/*
 *        Written for JacORB - a free Java ORB
 *
 *   Copyright (C) 2002-2004 - Gerald Brose
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.jacorb.security.ssl.iaik;

import iaik.security.ssl.*;
import java.security.cert.X509Certificate;

/**
 * @author Nicolas Noffke
 * @version $Id: ServerChainVerifier.java,v 1.6 2004/05/06 12:40:01 nicolas Exp $
 */

public class ServerChainVerifier 
    extends ChainVerifier 
{
    private boolean require_client_auth = false;

    public ServerChainVerifier( boolean require_client_auth )
    {
        super();
        
        this.require_client_auth = require_client_auth;
    }

    public ServerChainVerifier( int k )
    {
        super( k );
    }
    
    public boolean verifyChain( X509Certificate[] chain,
                                SSLTransport transport )
    {
        if( require_client_auth && (chain == null) )
        {
            return false;
        }
        
        return super.verifyChain( chain, transport );
    }
}// ServerChainVerifier


