/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1999-2004 Gerald Brose
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
package org.jacorb.ir.gui.typesystem;


/**
 * This class was generated by a SmartGuide.
 * 
 */
 
import java.util.*;
import javax.swing.tree.*;
import java.lang.reflect.*;
 
public abstract class TypeSystemNode 
    extends ModelParticipant
{
    protected DefaultMutableTreeNode treeNode;	
    protected String name = "";
    protected String absoluteName = "";

    /**
     */
    public TypeSystemNode ( ) {
    }

    /**
     * @param treeModel javax.swing.tree.DefaultTreeModel
     * @param parent javax.swing.tree.DefaultMutableTreeNode
     */
    protected TypeSystemNode ( DefaultMutableTreeNode treeNode) {
	this();
	this.treeNode = treeNode;
    }

    /**
     * @param name java.lang.String
     */

    public TypeSystemNode ( String name) {
	this();
	this.name = name;
    }

    /**
     * Gibt Array mit Strings zurck: die Node-Typen, die zu dieser Node
     * hinzugefgt werden knnen.
     * IRModule z.B. gibt "module", "interface" usw. zurck.
     * @return java.util.Enumeration
     */

    public String[] allowedToAdd ( ) 
    {
        return null;
    }

    /**
     * @return int
     * @param other org.jacorb.ir.gui.typesystem.ModelParticipant
     */
    public int compareTo(ModelParticipant other) {
	return this.toString().compareTo(other.toString());
    }

    /**
     * @return java.lang.String
     */

    public  String description() {
	return  getInstanceNodeTypeName() + " " + getAbsoluteName();
    }

    /**
     * @return java.lang.String
     */
    public String getAbsoluteName() {
	return absoluteName;
    }

    /**
     * @return java.lang.String
     */

    public String getInstanceNodeTypeName ( ) 
    {
	// Fr die Textreprsentation einer Node kann nodeTypeName abhngig vom Zustand sein,
	// z.B. bei IRAttribute: gegebenenfalls mu es dort "readonly attribute" heien und nicht "attribute"
	// Dynamischen Lookup einer static Methode simulieren:
	Method nodeTypeNameMethod;
	String nodeTypeName = "";
	try {
            nodeTypeNameMethod = getClass().getMethod("nodeTypeName", new Class[0]);
            nodeTypeName = (String) nodeTypeNameMethod.invoke(null, new Object[0]) ;
	}
	catch (Exception e) {
            e.printStackTrace();
	}	
	return nodeTypeName;    
    }

    /**
     * @return java.lang.String
     */

    public String getName ( ) 
    {
        return name; 
    }

    /**
     * Fge neues Child zu Node hinzu. Wird nur von TypeSystem.insertChild(..) aufgerufen.
     * Macht hier nichts als Exception zu werfen, wenn newChild nicht zugelassen ist, mu also
     * von Unterklassen berschrieben werden, um z.B. entsprechende Methode auf IR aufzurufen.
     * Bei illegalem Child-Typ wird IllegalChildException geworfen.
     * @param newChild TypeSystemNode
     */

    protected void insertChild ( TypeSystemNode newChild) 
        throws IllegalChildException 
    {
	String[] allowedTypes = allowedToAdd();
	int i;
	for (i = 0;  
             i <allowedTypes.length && !allowedTypes[i].equals(newChild.nodeTypeName()); 
             i++);

	if (!allowedTypes[i].equals(newChild.nodeTypeName())) {
            throw new IllegalChildException();
	}	
	// Das eigentliche Einfgen der DefaultMutableTreeNode wird von TypeSystem vorgenommen,
	// um entsprechende Events des TreeModels wird sich dort gekmmert.
	// Unterklassen mssen Methode berschreiben (inkl. Aufruf von super.addChild(..)) und z.B.
	// entsprechende Methode auf dem InterfaceRepository aufrufen
    }

    /**
     * Gib den Namen des Typen der Node zurck, z.B. den IDL-Bezeichner "Module"
     * @return java.lang.String
     */

    public static String nodeTypeName ( ) {
	// static Methoden knnen nicht abstract sein
	return null;
    }

    /**
     */
    protected void setAbsoluteName(String absoluteName ) {
	this.absoluteName = absoluteName;
    }

    /**
     * wird von Unterklassen von TypeSystemNode aufgerufen, deswegen protected
     * @param name java.lang.String
     */

    protected void setName( String name) {
	this.name = name;
    }

    /**
     * Soll mglichst IDL-hnliche komplette Textreprsentation zurckgeben
     * aber nur der Node selbst.
     * @return java.lang.String
     */
    public String toString ( ) {
	return getInstanceNodeTypeName() + " " + getName();
    }
}













