/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 */
package alma.acs.concurrent;

import java.util.concurrent.ThreadFactory;


/**
 * Factory for daemon threads.
 * @author hsommer
 * created Oct 29, 2003 3:51:25 PM
 */
public class DaemonThreadFactory implements ThreadFactory
{
    private String threadNamePrefix;
    
	public DaemonThreadFactory() {
		super();
	}

    public DaemonThreadFactory(String threadNamePrefix) {
        super();
        setThreadNamePrefix(threadNamePrefix);
    }


    /**
	 * @see ThreadFactory#newThread(java.lang.Runnable)
	 */
	public Thread newThread(Runnable command)
	{
		Thread t = new Thread(command);
		t.setDaemon(true);
//		t.setPriority(Thread.MIN_PRIORITY+1);
        
        String assignedName = t.getName();        
        if (threadNamePrefix != null) {
            assignedName = threadNamePrefix + assignedName;
        }
        String threadName = getThreadName(assignedName);
        if (threadName == null) {
            threadName = assignedName;
        }
        t.setName(threadName);
        
		return t;
	}
    
    /**
     * Can be overridden to change the name used for a new thread.
     * @param assignedName  concatenation of the name prefix (if one was given in {@link DaemonThreadFactory#setThreadNamePrefix(String)})
     *                      and the thread name generated by the constructor of Thread. 
     * @return the name to be used (will be ignored if it's null)
     */
    protected String getThreadName(String assignedName) {
        return assignedName;
    }
    
    public void setThreadNamePrefix(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
    }

}
