/*
 * ALMA - Atacama Large Millimiter Array (c) European Southern Observatory, 2011
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 */
package alma.acs.alarm.gui.senderpanel.table;

import java.util.Collection;
import java.util.Collections;
import java.util.Vector;

import javax.swing.table.AbstractTableModel;

import alma.acs.alarm.gui.senderpanel.SenderPanelUtils.Triplet;

/**
 * The model for the table
 * 
 * @author acaproni
 *
 */
public class AlarmsSentTableModel extends AbstractTableModel {
	
	/**
	 * The alarms shown in the table
	 */
	private final Vector<Triplet> alarms=new Vector<Triplet>();

	@Override
	public int getRowCount() {
		return alarms.size();
	}

	@Override
	public int getColumnCount() {
		return 1;
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		return alarms.get(rowIndex);
	}
	
	/**
	 * Active alarms must be added to the table;
	 * terminate alarm must be removed.
	 * 
	 * @param triplet The triplet of the alrm
	 * @param active The state of the alarm
	 * @return The number of alarms in the table
	 */
	public int alarmSent(Triplet triplet, boolean active) {
		System.out.println("Model: added "+triplet.toString()+" ACTIVE="+active);
		if (!active && alarms.contains(triplet)) {
			alarms.remove(triplet);
		} else if (active && !alarms.contains(triplet)) {
			alarms.add(triplet);
		}
		Collections.sort(alarms);
		fireTableDataChanged();
		System.out.println("\talarms size= "+alarms.size());
		return alarms.size();
	}
	
	/**
	 * @return The alarms in the table
	 */
	public Collection<Triplet> getAlarms() {
		Vector<Triplet> ret = new Vector<Triplet>(alarms.size());
		for (Triplet triplet: alarms) {
			ret.add(triplet);
		}
		return ret;
	}

}
