/*
* Copyright (C) The Community OpenORB Project. All rights reserved.
*
* This software is published under the terms of The OpenORB Community Software
* License version 1.0, a copy of which has been included with this distribution
* in the LICENSE.txt file.
*/

package org.openorb.compiler.object;

import org.openorb.compiler.parser.*;

/**
 * Cette classe represente une information sur une inclusion dans un fichier IDL
 *
 * @author Jerome Daniel
 * @version $Revision: 1.4 $ $Date: 2002/08/21 08:19:21 $ 
 */

public class IdlImport extends IdlObject
{
    /**
     * Nom du fichier
     */
    public String file_name;

    /**
        * Cree un objet IDL Include
        */
    public IdlImport( IdlObject father, String file_name )
    {
        super( IdlType.e_import, father );
        name( "import__" + file_name );
        this.file_name = file_name;

        if ( org.openorb.compiler.IdlCompiler.map_all )
            _map = true;
    }

    /**
     * Retourne le nom du fichier
     */
    public String file_name()
    {
        return file_name;
    }
}
