/*
* Copyright (C) The Community OpenORB Project. All rights reserved.
*
* This software is published under the terms of The OpenORB Community Software
* License version 1.0, a copy of which has been included with this distribution
* in the LICENSE.txt file.
*/
package org.openorb.adapter.boa;

import org.omg.PortableInterceptor.ORBInitInfo;

import org.openorb.net.ServerManager;

import org.openorb.PI.FeatureInitInfo;
import org.openorb.PI.FeatureInitializer;

/**
 * This class initializes a BOA instance.
 *
 * @author Chris Wood
 * @version $Revision: 1.6 $ $Date: 2002/06/28 08:59:04 $ 
 */
public class BOAInitializer
    implements FeatureInitializer
{
    /**
     * Creates a BOA instance and attaches it with the server manager.
     * @param orbinfo ORB standard information.
     * @param featureinfo OpenORB specific information.
     */
    public void init( ORBInitInfo orbinfo, FeatureInitInfo featureinfo )
    {
        ServerManager svrmgr = ( ServerManager ) featureinfo.getFeature( "ServerCPCManager" );

        if ( svrmgr != null )
        {
            BOA boa = new BOA( svrmgr );

            if ( featureinfo.orb().getFeature( "BOA" ) == null )
                featureinfo.orb().setFeature( "BOA", boa );
        }
    }
}
