/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import org.omg.GIOP.Version;
import org.openorb.iiop.CDROutputStream;
import org.openorb.io.MarshalBuffer;

final class HeaderBlock
implements MarshalBuffer.HeaderGenerator {
    private static final byte[][] GIOP_HEADERS = new byte[][]{{71, 73, 79, 80, 1, 0}, {71, 73, 79, 80, 1, 1}, {71, 73, 79, 80, 1, 2}};
    private byte m_msgType;
    private int m_reqID;
    private byte[] m_reqIDBytes;
    private Version m_version;

    HeaderBlock(byte msgType, int reqID, CDROutputStream os) {
        this.m_msgType = msgType;
        this.m_reqID = reqID;
        this.m_version = os.version();
        os.write_octet_array(GIOP_HEADERS[this.m_version.minor], 0, 6);
        os.addHeader(this, 6, this.m_version.minor >= 2, null);
    }

    public void endMessage(byte[] buf, int pos, int len, boolean fragment, int length, Object cookie) {
        buf[pos] = (byte)(fragment ? 2 : 0);
        buf[pos + 1] = this.m_msgType;
        buf[pos + 2] = (byte)((length -= 6) >>> 24);
        buf[pos + 3] = (byte)(length >>> 16);
        buf[pos + 4] = (byte)(length >>> 8);
        buf[pos + 5] = (byte)length;
        this.m_msgType = (byte)7;
    }

    public void beginMessage(MarshalBuffer buffer, Object cookie) {
        buffer.append(GIOP_HEADERS[this.m_version.minor], 0, 6);
        buffer.addHeader(this, 6, this.m_version.minor >= 2, null);
        if (this.m_version.minor >= 2) {
            if (this.m_reqIDBytes == null) {
                this.m_reqIDBytes = new byte[]{(byte)(this.m_reqID >>> 24), (byte)(this.m_reqID >>> 16), (byte)(this.m_reqID >>> 8), (byte)this.m_reqID};
            }
            buffer.append(this.m_reqIDBytes, 0, 4);
        }
    }
}

