/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.hsqldb.lib.RCData;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.util.CommonSwing;
import org.hsqldb.util.ConnectionDialogCommon;
import org.hsqldb.util.ConnectionDialogSwing;
import org.hsqldb.util.ConnectionSetting;
import org.hsqldb.util.DatabaseManagerCommon;
import org.hsqldb.util.FontDialogSwing;
import org.hsqldb.util.GridSwing;
import org.hsqldb.util.TableSorter;
import org.hsqldb.util.Transfer;

public class DatabaseManagerSwing
extends JApplet
implements ActionListener,
WindowListener,
KeyListener,
MouseListener {
    private static String homedir = null;
    private boolean isOracle = false;
    ArrayList localActionList = new ArrayList();
    private JFrame jframe = null;
    private static final String DEFAULT_RCFILE;
    private static boolean TT_AVAILABLE;
    private static final String HELP_TEXT;
    private static final String ABOUT_TEXT;
    static final String NL;
    static final String NULL_STR = "[null]";
    static int iMaxRecent;
    Connection cConn;
    Connection rowConn;
    DatabaseMetaData dMeta;
    Statement sStatement;
    JMenu mRecent;
    String[] sRecent;
    int iRecent;
    JTextArea txtCommand;
    JScrollPane txtCommandScroll;
    JButton butExecute;
    JTree tTree;
    JScrollPane tScrollPane;
    DefaultTreeModel treeModel;
    TableModel tableModel;
    DefaultMutableTreeNode rootNode;
    JPanel pResult;
    long lTime;
    GridSwing gResult;
    JTable gResultTable;
    JScrollPane gScrollPane;
    JTextArea txtResult;
    JScrollPane txtResultScroll;
    JSplitPane nsSplitPane;
    JSplitPane ewSplitPane;
    boolean bHelp;
    RootPaneContainer fMain;
    static boolean bMustExit;
    String sqlScriptBuffer = null;
    JToolBar jtoolbar;
    private boolean showSchemas = true;
    private boolean showTooltips = true;
    private boolean autoRefresh = true;
    private boolean gridFormat = true;
    static DatabaseManagerSwing refForFontDialogSwing;
    boolean displayRowCounts = false;
    boolean showSys = false;
    boolean showIndexDetails = true;
    String currentLAF = null;
    JPanel pStatus;
    static JButton iReadyStatus;
    JRadioButtonMenuItem rbAllSchemas = new JRadioButtonMenuItem("*");
    JMenuItem mitemAbout = new JMenuItem("About", 65);
    JMenuItem mitemHelp = new JMenuItem("Help", 72);
    JMenuItem mitemUpdateSchemas = new JMenuItem("Update Schemas");
    JCheckBoxMenuItem boxAutoCommit = new JCheckBoxMenuItem("Autocommit mode");
    JCheckBoxMenuItem boxLogging = new JCheckBoxMenuItem("Logging mode");
    JCheckBoxMenuItem boxShowSchemas = new JCheckBoxMenuItem("Show schemas");
    JCheckBoxMenuItem boxAutoRefresh = new JCheckBoxMenuItem("Auto-refresh tree");
    JCheckBoxMenuItem boxTooltips = new JCheckBoxMenuItem("Show Tooltips");
    JCheckBoxMenuItem boxRowCounts = new JCheckBoxMenuItem("Show row counts");
    JCheckBoxMenuItem boxShowGrid = new JCheckBoxMenuItem("Show results in Grid (a.o.t. Text)");
    JCheckBoxMenuItem boxShowSys = new JCheckBoxMenuItem("Show system tables");
    JRadioButtonMenuItem rbNativeLF = new JRadioButtonMenuItem("Native Look & Feel");
    JRadioButtonMenuItem rbJavaLF = new JRadioButtonMenuItem("Java Look & Feel");
    JRadioButtonMenuItem rbMotifLF = new JRadioButtonMenuItem("Motif Look & Feel");
    JLabel jStatusLine;
    static String READY_STATUS;
    private static final String AUTOCOMMIT_BOX_TEXT = "Autocommit mode";
    private static final String LOGGING_BOX_TEXT = "Logging mode";
    private static final String SHOWSCHEMAS_BOX_TEXT = "Show schemas";
    private static final String AUTOREFRESH_BOX_TEXT = "Auto-refresh tree";
    private static final String SHOWTIPS_BOX_TEXT = "Show Tooltips";
    private static final String ROWCOUNTS_BOX_TEXT = "Show row counts";
    private static final String SHOWSYS_BOX_TEXT = "Show system tables";
    private static final String GRID_BOX_TEXT = "Show results in Grid (a.o.t. Text)";
    Cursor fMainCursor;
    Cursor txtCommandCursor;
    Cursor txtResultCursor;
    HashMap tipMap = new HashMap();
    private JMenu mnuSchemas = new JMenu("Schemas");
    private final Cursor waitCursor = new Cursor(3);
    static String defDriver;
    static String defURL;
    static String defUser;
    static String defPassword;
    static String defScript;
    static String defDirectory;
    private String schemaFilter = null;
    private DBMPrefs prefs = null;
    Thread dummyThread = new Thread("dummy");
    private String busyText = null;
    private Runnable enableButtonRunnable = new Runnable(){

        @Override
        public void run() {
            DatabaseManagerSwing.this.jbuttonClear.setEnabled(true);
            DatabaseManagerSwing.this.jbuttonExecute.setEnabled(true);
        }
    };
    private Runnable disableButtonRunnable = new Runnable(){

        @Override
        public void run() {
            DatabaseManagerSwing.this.jbuttonClear.setEnabled(false);
            DatabaseManagerSwing.this.jbuttonExecute.setEnabled(false);
        }
    };
    private Thread buttonUpdaterThread = null;
    private static final int BUTTON_CHECK_PERIOD = 500;
    private Runnable buttonUpdater = new Runnable(){

        @Override
        public void run() {
            while (true) {
                boolean bl;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (DatabaseManagerSwing.this.buttonUpdaterThread == null) {
                    return;
                }
                boolean bl2 = bl = DatabaseManagerSwing.this.txtCommand.getText().length() > 0;
                if (DatabaseManagerSwing.this.jbuttonClear.isEnabled() == bl) continue;
                SwingUtilities.invokeLater(bl ? DatabaseManagerSwing.this.enableButtonRunnable : DatabaseManagerSwing.this.disableButtonRunnable);
            }
        }
    };
    private JButton jbuttonClear;
    private JButton jbuttonExecute;
    private Runnable treeRefreshRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                DatabaseManagerSwing.this.directRefreshTree();
            }
            catch (RuntimeException runtimeException) {
                CommonSwing.errorMessage(runtimeException);
                throw runtimeException;
            }
            finally {
                DatabaseManagerSwing.this.setWaiting(null);
            }
        }
    };
    private MouseEvent alreadyHandled = null;
    private static final String[] usertables;
    private static final String[] nonSystables;
    private static final HashSet oracleSysUsers;
    private static final String[] oracleSysSchemas;
    ActionListener schemaListListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DatabaseManagerSwing.this.schemaFilter = actionEvent.getActionCommand();
            if (DatabaseManagerSwing.this.schemaFilter.equals("*")) {
                DatabaseManagerSwing.this.schemaFilter = null;
            }
            DatabaseManagerSwing.this.refreshTree();
        }
    };
    private static final String tString;
    private static final String fString;

    public DatabaseManagerSwing() {
        this.jframe = new JFrame("HSQLDB DatabaseManager");
        this.fMain = this.jframe;
    }

    public DatabaseManagerSwing(JFrame jFrame) {
        this.jframe = jFrame;
        this.fMain = this.jframe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        this.fMain = this;
        this.main();
        for (int i = 0; i < this.localActionList.size(); ++i) {
            AbstractButton abstractButton = (AbstractButton)this.localActionList.get(i);
            abstractButton.setEnabled(false);
        }
        Connection connection = null;
        boolean bl = false;
        if (this.getParameter("jdbcDriver") != null) {
            bl = true;
            defDriver = this.getParameter("jdbcDriver");
        }
        if (this.getParameter("jdbcUrl") != null) {
            bl = true;
            defURL = this.getParameter("jdbcUrl");
        }
        if (this.getParameter("jdbcUser") != null) {
            bl = true;
            defUser = this.getParameter("jdbcUser");
        }
        if (this.getParameter("jdbcPassword") != null) {
            bl = true;
            defPassword = this.getParameter("jdbcPassword");
        }
        try {
            this.setWaiting("Initializing");
            connection = bl ? ConnectionDialogSwing.createConnection(defDriver, defURL, defUser, defPassword) : ConnectionDialogSwing.createConnection(this.jframe, "Connect");
        }
        catch (Exception exception) {
            CommonSwing.errorMessage(exception);
        }
        finally {
            this.setWaiting(null);
        }
        if (connection != null) {
            this.connect(connection);
        }
        if (this.getParameter("loadSampleData") != null && this.getParameter("loadSampleData").equals("true")) {
            this.insertTestData();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.refreshTree();
        }
        if (this.getParameter("schemaFilter") != null) {
            this.schemaFilter = this.getParameter("schemaFilter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        DatabaseManagerSwing databaseManagerSwing;
        System.getProperties().put("sun.java2d.noddraw", "true");
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        bMustExit = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].toLowerCase();
            if (string3.startsWith("--")) {
                string3 = string3.substring(1);
            }
            ++i;
            if (string3.equals("-driver")) {
                defDriver = stringArray[i];
                bl = true;
                continue;
            }
            if (string3.equals("-url")) {
                defURL = stringArray[i];
                bl = true;
                continue;
            }
            if (string3.equals("-user")) {
                defUser = stringArray[i];
                bl = true;
                continue;
            }
            if (string3.equals("-password")) {
                defPassword = stringArray[i];
                bl = true;
                continue;
            }
            if (string3.equals("-urlid")) {
                string = stringArray[i];
                bl2 = true;
                continue;
            }
            if (string3.equals("-rcfile")) {
                string2 = stringArray[i];
                bl2 = true;
                continue;
            }
            if (string3.equals("-dir")) {
                defDirectory = stringArray[i];
                continue;
            }
            if (string3.equals("-script")) {
                defScript = stringArray[i];
                continue;
            }
            if (string3.equals("-noexit")) {
                bMustExit = false;
                --i;
                continue;
            }
            if (string3.equals("-help")) {
                DatabaseManagerSwing.showUsage();
                return;
            }
            throw new IllegalArgumentException("Try:  java... " + DatabaseManagerSwing.class.getName() + " --help");
        }
        refForFontDialogSwing = databaseManagerSwing = new DatabaseManagerSwing(new JFrame("HSQL Database Manager"));
        databaseManagerSwing.main();
        Connection connection = null;
        databaseManagerSwing.setWaiting("Initializing");
        try {
            if (bl && bl2) {
                throw new IllegalArgumentException("You may not specify both (urlid) AND (url/user/password).");
            }
            if (bl) {
                connection = ConnectionDialogSwing.createConnection(defDriver, defURL, defUser, defPassword);
            } else if (bl2) {
                if (string == null) {
                    throw new IllegalArgumentException("You must specify an 'urlid' to use an RC file");
                }
                bl = true;
                String string4 = string2 == null ? DEFAULT_RCFILE : string2;
                RCData rCData = new RCData(new File(string4), string);
                connection = rCData.getConnection(null, System.getProperty("javax.net.ssl.trustStore"));
            } else {
                connection = ConnectionDialogSwing.createConnection(databaseManagerSwing.jframe, "Connect");
            }
        }
        catch (Exception exception) {
            CommonSwing.errorMessage(exception);
        }
        finally {
            databaseManagerSwing.setWaiting(null);
        }
        if (connection != null) {
            databaseManagerSwing.connect(connection);
        }
        FontDialogSwing.creatFontDialog(refForFontDialogSwing);
        databaseManagerSwing.start();
    }

    public void connect(Connection connection) {
        this.schemaFilter = null;
        if (connection == null) {
            return;
        }
        if (this.cConn != null) {
            try {
                this.cConn.close();
            }
            catch (SQLException sQLException) {
                CommonSwing.errorMessage(sQLException);
            }
        }
        this.cConn = connection;
        this.rowConn = connection;
        try {
            this.dMeta = this.cConn.getMetaData();
            this.isOracle = this.dMeta.getDatabaseProductName().indexOf("Oracle") >= 0;
            this.sStatement = this.cConn.createStatement();
            this.updateAutoCommitBox();
            this.showIndexDetails = !this.isOracle;
            Driver driver = DriverManager.getDriver(this.dMeta.getURL());
            ConnectionSetting connectionSetting = new ConnectionSetting(this.dMeta.getDatabaseProductName(), driver.getClass().getName(), this.dMeta.getURL(), this.dMeta.getUserName().replaceAll("@localhost", ""), "");
            Hashtable hashtable = ConnectionDialogCommon.loadRecentConnectionSettings();
            ConnectionDialogCommon.addToRecentConnectionSettings(hashtable, connectionSetting);
            ConnectionDialogSwing.setConnectionSetting(connectionSetting);
            this.refreshTree();
            this.clearResultPanel();
            if (this.fMain instanceof JApplet) {
                this.getAppletContext().showStatus("JDBC Connection established to a " + this.dMeta.getDatabaseProductName() + " v. " + this.dMeta.getDatabaseProductVersion() + " database as '" + this.dMeta.getUserName() + "'.");
            }
        }
        catch (SQLException sQLException) {
            CommonSwing.errorMessage(sQLException);
        }
        catch (IOException iOException) {
            CommonSwing.errorMessage(iOException);
        }
        catch (Exception exception) {
            CommonSwing.errorMessage(exception);
        }
    }

    private static void showUsage() {
        System.out.println("Usage: java DatabaseManagerSwing [--options]\nwhere options include:\n    --help                show this message\n    --driver <classname>  jdbc driver class\n    --url <name>          jdbc url\n    --user <name>         username used for connection\n    --password <password> password for this user\n    --urlid <urlid>       use url/user/password/driver in rc file\n    --rcfile <file>       (defaults to 'dbmanager.rc' in home dir)\n    --dir <path>          default directory\n    --script <file>       reads from script file\n    --noexit              do not call system.exit()");
    }

    private void insertTestData() {
        try {
            DatabaseManagerCommon.createTestTables(this.sStatement);
            this.txtCommand.setText(DatabaseManagerCommon.createTestData(this.sStatement));
            for (int i = 0; i < DatabaseManagerCommon.testDataSql.length; ++i) {
                this.addToRecent(DatabaseManagerCommon.testDataSql[i]);
            }
            this.executeCurrentSQL();
        }
        catch (SQLException sQLException) {
            CommonSwing.errorMessage(sQLException);
        }
    }

    public void setMustExit(boolean bl) {
        bMustExit = bl;
    }

    public void main() {
        JMenuItem jMenuItem;
        try {
            this.prefs = new DBMPrefs(this.fMain instanceof JApplet);
        }
        catch (Exception exception) {
            System.err.println("Failed to load preferences.  Proceeding with defaults:\n");
        }
        if (this.prefs == null) {
            this.setLF(CommonSwing.Native);
        } else {
            this.autoRefresh = this.prefs.autoRefresh;
            this.displayRowCounts = this.prefs.showRowCounts;
            this.showSys = this.prefs.showSysTables;
            this.showSchemas = this.prefs.showSchemas;
            this.gridFormat = this.prefs.resultGrid;
            this.showTooltips = this.prefs.showTooltips;
            this.setLF(this.prefs.laf);
        }
        this.fMain.getContentPane().add((Component)this.createToolBar(), "North");
        if (this.fMain instanceof Frame) {
            ((Frame)((Object)this.fMain)).setIconImage(CommonSwing.getIcon("Frame"));
        }
        if (this.fMain instanceof Window) {
            ((Window)((Object)this.fMain)).addWindowListener(this);
        }
        JMenuBar jMenuBar = new JMenuBar();
        Object[] objectArray = new String[]{"-Connect...", "--", "OOpen Script...", "-Save Script...", "-Save Result...", "--", "-Exit"};
        JMenu jMenu = this.addMenu(jMenuBar, "File", objectArray);
        for (int i = 2; i < jMenu.getItemCount(); ++i) {
            jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null) continue;
            this.localActionList.add(jMenuItem);
        }
        Object[] objectArray2 = new Object[]{"RRefresh Tree", this.boxAutoRefresh, "--", this.boxRowCounts, this.boxShowSys, this.boxShowSchemas, this.boxShowGrid};
        this.addMenu(jMenuBar, "View", objectArray2);
        Object[] objectArray3 = new String[]{"SSELECT", "IINSERT", "UUPDATE", "DDELETE", "EEXECUTE", "---", "-CREATE TABLE", "-DROP TABLE", "-CREATE INDEX", "-DROP INDEX", "--", "CCOMMIT*", "LROLLBACK*", "-CHECKPOINT*", "-SCRIPT", "-SET", "-SHUTDOWN", "--", "-Test Script"};
        this.addMenu(jMenuBar, "Command", objectArray3);
        this.mRecent = new JMenu("Recent");
        this.mRecent.setMnemonic(82);
        jMenuBar.add(this.mRecent);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbNativeLF);
        buttonGroup.add(this.rbJavaLF);
        buttonGroup.add(this.rbMotifLF);
        this.boxShowSchemas.setSelected(this.showSchemas);
        this.boxShowGrid.setSelected(this.gridFormat);
        this.boxTooltips.setSelected(this.showTooltips);
        this.boxShowGrid.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.boxAutoRefresh.setSelected(this.autoRefresh);
        this.boxRowCounts.setSelected(this.displayRowCounts);
        this.boxShowSys.setSelected(this.showSys);
        this.rbNativeLF.setActionCommand("LFMODE:" + CommonSwing.Native);
        this.rbJavaLF.setActionCommand("LFMODE:" + CommonSwing.Java);
        this.rbMotifLF.setActionCommand("LFMODE:" + CommonSwing.Motif);
        this.tipMap.put(this.mitemUpdateSchemas, "Refresh the schema list in this menu");
        this.tipMap.put(this.rbAllSchemas, "Display items in all schemas");
        this.tipMap.put(this.mitemAbout, "Display product information");
        this.tipMap.put(this.mitemHelp, "Display advice for obtaining help");
        this.tipMap.put(this.boxAutoRefresh, "Refresh tree (and schema list) automaticallywhen YOU modify database objects");
        this.tipMap.put(this.boxShowSchemas, "Display object names in tree-like schemaname.basename");
        this.tipMap.put(this.rbNativeLF, "Set Look and Feel to Native for your platform");
        this.tipMap.put(this.rbJavaLF, "Set Look and Feel to Java");
        this.tipMap.put(this.rbMotifLF, "Set Look and Feel to Motif");
        this.boxTooltips.setToolTipText("Display tooltips (hover text), like this");
        this.tipMap.put(this.boxAutoCommit, "Shows current Auto-commit mode.  Click to change");
        this.tipMap.put(this.boxLogging, "Shows current JDBC DriverManager logging mode.  Click to change");
        this.tipMap.put(this.boxShowSys, "Show system tables in table tree to the left");
        this.tipMap.put(this.boxShowGrid, "Show query results in grid (in text if off)");
        this.tipMap.put(this.boxRowCounts, "Show row counts with table names in tree");
        this.boxAutoRefresh.setMnemonic(67);
        this.boxShowSchemas.setMnemonic(89);
        this.boxAutoCommit.setMnemonic(65);
        this.boxShowSys.setMnemonic(89);
        this.boxShowGrid.setMnemonic(71);
        this.boxRowCounts.setMnemonic(67);
        this.boxLogging.setMnemonic(76);
        this.rbAllSchemas.setMnemonic(151);
        this.rbNativeLF.setMnemonic(78);
        this.rbJavaLF.setMnemonic(74);
        this.rbMotifLF.setMnemonic(77);
        this.mitemUpdateSchemas.setMnemonic(85);
        Object[] objectArray4 = new Object[]{this.rbNativeLF, this.rbJavaLF, this.rbMotifLF, "--", "-Set Fonts", "--", this.boxAutoCommit, "--", "-Disable MaxRows", "-Set MaxRows to 100", "--", this.boxLogging, "--", "-Insert test data"};
        this.addMenu(jMenuBar, "Options", objectArray4);
        Object[] objectArray5 = new String[]{"-Dump", "-Restore", "-Transfer"};
        jMenu = this.addMenu(jMenuBar, "Tools", objectArray5);
        jMenu.setEnabled(TT_AVAILABLE);
        this.localActionList.add(jMenu);
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null) continue;
            this.localActionList.add(jMenuItem);
        }
        this.mnuSchemas.setMnemonic(83);
        jMenuBar.add(this.mnuSchemas);
        JMenu jMenu2 = new JMenu("Help");
        jMenu2.setMnemonic(72);
        jMenu2.add(this.mitemAbout);
        jMenu2.add(this.mitemHelp);
        jMenu2.add(this.boxTooltips);
        this.rbAllSchemas.addActionListener(this.schemaListListener);
        this.mitemUpdateSchemas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseManagerSwing.this.updateSchemaList();
            }
        });
        this.mitemHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(DatabaseManagerSwing.this.fMain.getContentPane(), HELP_TEXT, "HELP", 1);
            }
        });
        this.mitemAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(DatabaseManagerSwing.this.fMain.getContentPane(), ABOUT_TEXT, "About", 1);
            }
        });
        this.boxTooltips.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseManagerSwing.this.showTooltips = DatabaseManagerSwing.this.boxTooltips.isSelected();
                DatabaseManagerSwing.this.resetTooltips();
            }
        });
        jMenuBar.add(jMenu2);
        if (this.fMain instanceof JApplet) {
            ((JApplet)this.fMain).setJMenuBar(jMenuBar);
        } else if (this.fMain instanceof JFrame) {
            ((JFrame)this.fMain).setJMenuBar(jMenuBar);
        }
        this.initGUI();
        this.sRecent = new String[iMaxRecent];
        if (!(this.fMain instanceof JApplet)) {
            CommonSwing.setFramePositon((JFrame)this.fMain);
        }
        ((Component)((Object)this.fMain)).setVisible(true);
        if (defScript != null) {
            if (defDirectory != null) {
                defScript = defDirectory + File.separator + defScript;
            }
            this.sqlScriptBuffer = DatabaseManagerCommon.readFile(defScript);
            if (4096 <= this.sqlScriptBuffer.length()) {
                int n = this.sqlScriptBuffer.indexOf(10);
                if (n > 0) {
                    n = this.sqlScriptBuffer.indexOf(10, n + 1);
                }
                if (n > 0) {
                    n = this.sqlScriptBuffer.indexOf(10, n + 1);
                }
                if (n < 1) {
                    n = 100;
                }
                this.txtCommand.setText("............... Script File loaded: " + defScript + " ..................... \n" + "............... Click Execute or Clear " + "...................\n" + this.sqlScriptBuffer.substring(0, n + 1) + "..........................................." + "..............................\n" + "............................................." + "............................\n");
                this.txtCommand.setEnabled(false);
            } else {
                this.txtCommand.setText(this.sqlScriptBuffer);
                this.sqlScriptBuffer = null;
                this.txtCommand.setEnabled(true);
            }
        }
        this.resetTooltips();
        this.txtCommand.requestFocus();
    }

    private JMenu addMenu(JMenuBar jMenuBar, String string, Object[] objectArray) {
        JMenu jMenu = new JMenu(string);
        jMenu.setMnemonic(string.charAt(0));
        this.addMenuItems(jMenu, objectArray);
        jMenuBar.add(jMenu);
        return jMenu;
    }

    private void addMenuItems(JMenu jMenu, Object[] objectArray) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        for (int i = 0; i < objectArray.length; ++i) {
            JMenuItem jMenuItem;
            if (objectArray[i].equals("--")) {
                jMenu.addSeparator();
                continue;
            }
            if (objectArray[i].equals("---")) {
                if (dimension.width >= 640) {
                    jMenu.addSeparator();
                    continue;
                }
                return;
            }
            if (objectArray[i] instanceof JMenuItem) {
                jMenuItem = (JMenuItem)objectArray[i];
            } else if (objectArray[i] instanceof String) {
                jMenuItem = new JMenuItem(((String)objectArray[i]).substring(1));
                char c = ((String)objectArray[i]).charAt(0);
                if (c != '-') {
                    KeyStroke keyStroke = KeyStroke.getKeyStroke((int)c, 2);
                    jMenuItem.setAccelerator(keyStroke);
                }
            } else {
                throw new RuntimeException("Unexpected element for menu item creation: " + objectArray[i].getClass().getName());
            }
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n' && keyEvent.isControlDown()) {
            keyEvent.consume();
            this.executeCurrentSQL();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null && actionEvent.getSource() instanceof JMenuItem) {
            string = ((JMenuItem)actionEvent.getSource()).getText();
        }
        if (string != null) {
            if (string.equals("Exit")) {
                this.windowClosing(null);
            } else if (string.equals("Transfer")) {
                Transfer.work(null);
            } else if (string.equals("Dump")) {
                Transfer.work((String[])new String[]{"-d"});
            } else if (string.equals("Restore")) {
                JOptionPane.showMessageDialog(this.fMain.getContentPane(), "Use Ctrl-R or the View menu to\nupdate nav. tree after Restoration", "Suggestion", 1);
                Transfer.work((String[])new String[]{"-r"});
            } else if (string.equals(LOGGING_BOX_TEXT)) {
                JavaSystem.setLogToSystem(this.boxLogging.isSelected());
            } else if (string.equals(AUTOREFRESH_BOX_TEXT)) {
                this.autoRefresh = this.boxAutoRefresh.isSelected();
                this.refreshTree();
            } else if (string.equals("Refresh Tree")) {
                this.refreshTree();
            } else if (string.startsWith("#")) {
                int n = Integer.parseInt(string.substring(1));
                this.txtCommand.setText(this.sRecent[n]);
            } else if (string.equals("Connect...")) {
                Connection connection = null;
                try {
                    this.setWaiting("Connecting");
                    connection = ConnectionDialogSwing.createConnection(this.jframe, "Connect");
                }
                finally {
                    this.setWaiting(null);
                }
                this.connect(connection);
            } else if (string.equals(GRID_BOX_TEXT)) {
                this.gridFormat = this.boxShowGrid.isSelected();
                this.displayResults();
            } else if (string.equals("Open Script...")) {
                File file;
                int n;
                JFileChooser jFileChooser = new JFileChooser(".");
                jFileChooser.setDialogTitle("Open Script...");
                if (defDirectory != null) {
                    jFileChooser.setCurrentDirectory(new File(defDirectory));
                }
                if ((n = jFileChooser.showOpenDialog((Component)((Object)this.fMain))) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    this.sqlScriptBuffer = DatabaseManagerCommon.readFile(file.getAbsolutePath());
                    if (4096 <= this.sqlScriptBuffer.length()) {
                        int n2 = this.sqlScriptBuffer.indexOf(10);
                        if (n2 > 0) {
                            n2 = this.sqlScriptBuffer.indexOf(10, n2 + 1);
                        }
                        if (n2 > 0) {
                            n2 = this.sqlScriptBuffer.indexOf(10, n2 + 1);
                        }
                        if (n2 < 1) {
                            n2 = 100;
                        }
                        this.txtCommand.setText("............... Script File loaded: " + file + " ..................... \n" + "............... Click Execute or Clear " + "...................\n" + this.sqlScriptBuffer.substring(0, n2 + 1) + "........................................." + "................................\n" + "..........................................." + "..............................\n");
                        this.txtCommand.setEnabled(false);
                    } else {
                        this.txtCommand.setText(this.sqlScriptBuffer);
                        this.sqlScriptBuffer = null;
                        this.txtCommand.setEnabled(true);
                    }
                }
            } else if (string.equals("Save Script...")) {
                File file;
                int n;
                JFileChooser jFileChooser = new JFileChooser(".");
                jFileChooser.setDialogTitle("Save Script");
                if (defDirectory != null) {
                    jFileChooser.setCurrentDirectory(new File(defDirectory));
                }
                if ((n = jFileChooser.showSaveDialog((Component)((Object)this.fMain))) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    DatabaseManagerCommon.writeFile(file.getAbsolutePath(), this.txtCommand.getText());
                }
            } else if (string.equals("Save Result...")) {
                File file;
                int n;
                JFileChooser jFileChooser = new JFileChooser(".");
                jFileChooser.setDialogTitle("Save Result...");
                if (defDirectory != null) {
                    jFileChooser.setCurrentDirectory(new File(defDirectory));
                }
                if ((n = jFileChooser.showSaveDialog((Component)((Object)this.fMain))) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    this.showResultInText();
                    DatabaseManagerCommon.writeFile(file.getAbsolutePath(), this.txtResult.getText());
                }
            } else if (string.equals(SHOWSYS_BOX_TEXT)) {
                this.showSys = this.boxShowSys.isSelected();
                this.refreshTree();
            } else if (string.equals(ROWCOUNTS_BOX_TEXT)) {
                this.displayRowCounts = this.boxRowCounts.isSelected();
                this.refreshTree();
            } else if (string.startsWith("LFMODE:")) {
                this.setLF(string.substring("LFMODE:".length()));
            } else if (string.equals("Set Fonts")) {
                FontDialogSwing.creatFontDialog(refForFontDialogSwing);
            } else if (string.equals(AUTOCOMMIT_BOX_TEXT)) {
                try {
                    this.cConn.setAutoCommit(this.boxAutoCommit.isSelected());
                }
                catch (SQLException sQLException) {
                    this.boxAutoCommit.setSelected(!this.boxAutoCommit.isSelected());
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string.equals("COMMIT*")) {
                try {
                    this.cConn.commit();
                    this.showHelp(new String[]{"", "COMMIT executed"});
                }
                catch (SQLException sQLException) {
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string.equals("Insert test data")) {
                this.insertTestData();
                this.refreshTree();
            } else if (string.equals("ROLLBACK*")) {
                try {
                    this.cConn.rollback();
                    this.showHelp(new String[]{"", "ROLLBACK executed"});
                }
                catch (SQLException sQLException) {
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string.equals("Disable MaxRows")) {
                try {
                    this.sStatement.setMaxRows(0);
                }
                catch (SQLException sQLException) {
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string.equals("Set MaxRows to 100")) {
                try {
                    this.sStatement.setMaxRows(100);
                }
                catch (SQLException sQLException) {
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string.equals("SELECT")) {
                this.showHelp(DatabaseManagerCommon.selectHelp);
            } else if (string.equals("INSERT")) {
                this.showHelp(DatabaseManagerCommon.insertHelp);
            } else if (string.equals("UPDATE")) {
                this.showHelp(DatabaseManagerCommon.updateHelp);
            } else if (string.equals("DELETE")) {
                this.showHelp(DatabaseManagerCommon.deleteHelp);
            } else if (string.equals("EXECUTE")) {
                this.executeCurrentSQL();
            } else if (string.equals("CREATE TABLE")) {
                this.showHelp(DatabaseManagerCommon.createTableHelp);
            } else if (string.equals("DROP TABLE")) {
                this.showHelp(DatabaseManagerCommon.dropTableHelp);
            } else if (string.equals("CREATE INDEX")) {
                this.showHelp(DatabaseManagerCommon.createIndexHelp);
            } else if (string.equals("DROP INDEX")) {
                this.showHelp(DatabaseManagerCommon.dropIndexHelp);
            } else if (string.equals("CHECKPOINT*")) {
                try {
                    this.cConn.createStatement().executeUpdate("CHECKPOINT");
                    this.showHelp(new String[]{"", "CHECKPOINT executed"});
                }
                catch (SQLException sQLException) {
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string.equals("SCRIPT")) {
                this.showHelp(DatabaseManagerCommon.scriptHelp);
            } else if (string.equals("SHUTDOWN")) {
                this.showHelp(DatabaseManagerCommon.shutdownHelp);
            } else if (string.equals("SET")) {
                this.showHelp(DatabaseManagerCommon.setHelp);
            } else if (string.equals("Test Script")) {
                this.showHelp(DatabaseManagerCommon.testHelp);
            } else if (string.equals(SHOWSCHEMAS_BOX_TEXT)) {
                this.showSchemas = this.boxShowSchemas.isSelected();
                this.refreshTree();
            } else {
                throw new RuntimeException("Unexpected action triggered: " + string);
            }
        }
    }

    private void displayResults() {
        if (this.gridFormat) {
            this.setResultsInGrid();
        } else {
            this.setResultsInText();
        }
    }

    private void setResultsInGrid() {
        this.pResult.removeAll();
        this.pResult.add((Component)this.gScrollPane, "Center");
        this.pResult.doLayout();
        this.gResult.fireTableChanged(null);
        this.pResult.repaint();
    }

    private void setResultsInText() {
        this.pResult.removeAll();
        this.pResult.add((Component)this.txtResultScroll, "Center");
        this.pResult.doLayout();
        this.showResultInText();
        this.pResult.repaint();
    }

    private void showHelp(String[] stringArray) {
        this.txtCommand.setText(stringArray[0]);
        this.bHelp = true;
        this.pResult.removeAll();
        this.pResult.add((Component)this.txtResultScroll, "Center");
        this.pResult.doLayout();
        this.txtResult.setText(stringArray[1]);
        this.pResult.repaint();
        this.txtCommand.requestFocus();
        this.txtCommand.setCaretPosition(stringArray[0].length());
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.stop();
        try {
            if (this.cConn != null) {
                this.cConn.close();
            }
            if (this.prefs != null) {
                this.prefs.autoRefresh = this.autoRefresh;
                this.prefs.showRowCounts = this.displayRowCounts;
                this.prefs.showSysTables = this.showSys;
                this.prefs.showSchemas = this.showSchemas;
                this.prefs.resultGrid = this.gridFormat;
                this.prefs.showTooltips = this.showTooltips;
                this.prefs.laf = this.currentLAF;
                this.prefs.store();
            }
        }
        catch (Exception exception) {
            CommonSwing.errorMessage(exception);
        }
        if (this.fMain instanceof Window) {
            ((Window)((Object)this.fMain)).dispose();
        }
        if (bMustExit) {
            System.exit(0);
        }
    }

    private void clear() {
        this.sqlScriptBuffer = null;
        this.txtCommand.setText("");
        this.txtCommand.setEnabled(true);
    }

    private void backgroundIt(Runnable runnable, String string) {
        if (this.busyText != null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.setWaiting(string);
        SwingUtilities.invokeLater(runnable);
    }

    private void clearResultPanel() {
        this.gResult.setHead(new Object[0]);
        this.gResult.clear();
        if (this.gridFormat) {
            this.gResult.fireTableChanged(null);
        } else {
            this.showResultInText();
        }
    }

    public void setWaiting(String string) {
        this.busyText = string;
        if (this.busyText == null) {
            if (this.fMain instanceof Frame) {
                ((Frame)((Object)this.fMain)).setCursor(this.fMainCursor);
            } else {
                ((Component)((Object)this.fMain)).setCursor(this.fMainCursor);
            }
            this.txtCommand.setCursor(this.txtCommandCursor);
            this.txtResult.setCursor(this.txtResultCursor);
        } else {
            if (this.fMainCursor == null) {
                this.fMainCursor = this.fMain instanceof Frame ? ((Frame)((Object)this.fMain)).getCursor() : ((Component)((Object)this.fMain)).getCursor();
                this.txtCommandCursor = this.txtCommand.getCursor();
                this.txtResultCursor = this.txtResult.getCursor();
            }
            if (this.fMain instanceof Frame) {
                ((Frame)((Object)this.fMain)).setCursor(this.waitCursor);
            } else {
                ((Component)((Object)this.fMain)).setCursor(this.waitCursor);
            }
            this.txtCommand.setCursor(this.waitCursor);
            this.txtResult.setCursor(this.waitCursor);
        }
        this.setStatusLine(this.busyText, this.busyText == null ? this.gResult.getRowCount() : 0);
    }

    @Override
    public void start() {
        if (this.buttonUpdaterThread == null) {
            this.buttonUpdaterThread = new Thread(this.buttonUpdater);
        }
        this.buttonUpdaterThread.start();
    }

    @Override
    public void stop() {
        System.err.println("Stopping");
        this.buttonUpdaterThread = null;
    }

    protected void executeCurrentSQL() {
        if (this.txtCommand.getText().length() < 1) {
            CommonSwing.errorMessage("No SQL to execute");
            return;
        }
        this.backgroundIt(new StatementExecRunnable(), "Executing SQL");
    }

    private void executeSQL() {
        Object[] objectArray = new String[1];
        String string = null;
        try {
            this.lTime = System.currentTimeMillis();
            string = this.sqlScriptBuffer == null ? this.txtCommand.getText() : this.sqlScriptBuffer;
            this.sStatement.execute(string);
            int n = this.sStatement.getUpdateCount();
            if (n == -1) {
                ResultSet resultSet = this.sStatement.getResultSet();
                try {
                    this.formatResultSet(resultSet);
                }
                catch (Throwable throwable) {
                    objectArray[0] = "Error displaying the ResultSet";
                    this.gResult.setHead(objectArray);
                    String string2 = throwable.getMessage();
                    objectArray[0] = string2;
                    this.gResult.addRow(objectArray);
                }
            } else {
                objectArray[0] = "update count";
                this.gResult.setHead(objectArray);
                objectArray[0] = "" + n;
                this.gResult.addRow(objectArray);
            }
            this.lTime = System.currentTimeMillis() - this.lTime;
            if (this.sqlScriptBuffer == null) {
                this.addToRecent(string);
                this.txtCommand.setEnabled(true);
            } else {
                this.clear();
            }
        }
        catch (SQLException sQLException) {
            this.lTime = System.currentTimeMillis() - this.lTime;
            objectArray[0] = "SQL Error";
            this.gResult.setHead(objectArray);
            String string3 = sQLException.getMessage();
            string3 = string3 + " / Error Code: " + sQLException.getErrorCode();
            string3 = string3 + " / State: " + sQLException.getSQLState();
            objectArray[0] = string3;
            this.gResult.addRow(objectArray);
            CommonSwing.errorMessage(sQLException);
            return;
        }
        if (this.autoRefresh) {
            this.setStatusLine("Refreshing object tree", 0);
            String string4 = string.toUpperCase(Locale.ENGLISH);
            if (string4.indexOf("ALTER") > -1 || string4.indexOf("DROP") > -1 || string4.indexOf("CREATE") > -1) {
                this.directRefreshTree();
            }
        }
    }

    private void updateResult() {
        if (this.gridFormat) {
            if (this.bHelp) {
                this.pResult.removeAll();
                this.pResult.add((Component)this.gScrollPane, "Center");
                this.pResult.doLayout();
                this.gResult.fireTableChanged(null);
                this.pResult.repaint();
                this.bHelp = false;
            }
        } else {
            this.showResultInText();
        }
        this.txtCommand.selectAll();
        this.txtCommand.requestFocus();
    }

    private void formatResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            Object[] objectArray = new String[]{"Result"};
            this.gResult.setHead(objectArray);
            objectArray[0] = "(empty)";
            this.gResult.addRow(objectArray);
            return;
        }
        try {
            int n;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            Object[] objectArray = new Object[n2];
            boolean[] blArray = new boolean[n2];
            for (n = 1; n <= n2; ++n) {
                objectArray[n - 1] = resultSetMetaData.getColumnLabel(n);
                blArray[n - 1] = resultSetMetaData.getColumnType(n) == 12;
            }
            this.gResult.setHead(objectArray);
            while (resultSet.next()) {
                for (n = 1; n <= n2; ++n) {
                    try {
                        objectArray[n - 1] = resultSet.getObject(n);
                        if (!resultSet.wasNull()) continue;
                        objectArray[n - 1] = blArray[n - 1] ? NULL_STR : null;
                        continue;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.gResult.addRow(objectArray);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            CommonSwing.errorMessage(sQLException);
        }
    }

    private void testPerformance() {
        int n;
        String string = this.txtCommand.getText();
        StringBuffer stringBuffer = new StringBuffer();
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n == 10) continue;
            stringBuffer.append((char)n);
        }
        string = stringBuffer.toString();
        Object[] objectArray = new String[]{"ms", "count", "sql", "error"};
        this.gResult.setHead(objectArray);
        n = 1;
        this.lTime = System.currentTimeMillis() - this.lTime;
        while (!string.equals("")) {
            String string2;
            int n2 = string.indexOf(59);
            if (n2 != -1) {
                string2 = string.substring(0, n2);
                string = string.substring(n2 + 1);
            } else {
                string2 = string;
                string = "";
            }
            if (string2.startsWith("--#")) {
                n = Integer.parseInt(string2.substring(3));
                continue;
            }
            if (string2.startsWith("--")) continue;
            objectArray[2] = string2;
            long l2 = 0L;
            try {
                l2 = DatabaseManagerCommon.testStatement(this.sStatement, string2, n);
                l += l2;
                objectArray[0] = "" + l2;
                objectArray[1] = "" + n;
                objectArray[3] = "";
            }
            catch (SQLException sQLException) {
                objectArray[1] = "n/a";
                objectArray[0] = "n/a";
                objectArray[3] = sQLException.toString();
                CommonSwing.errorMessage(sQLException);
            }
            this.gResult.addRow(objectArray);
            System.out.println(l2 + " ms : " + string2);
        }
        objectArray[0] = "" + l;
        objectArray[1] = "total";
        objectArray[2] = "";
        this.gResult.addRow(objectArray);
        this.lTime = System.currentTimeMillis() - this.lTime;
    }

    private void showResultInText() {
        int n;
        Object[] objectArray;
        int n2;
        Object[] objectArray2 = this.gResult.getHead();
        int n3 = objectArray2.length;
        int[] nArray = new int[n3];
        Vector vector = this.gResult.getData();
        int n4 = vector.size();
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = objectArray2[n2].toString().length();
        }
        for (n2 = 0; n2 < n4; ++n2) {
            objectArray = (Object[])vector.elementAt(n2);
            for (n = 0; n < n3; ++n) {
                String string = objectArray[n] == null ? "" : objectArray[n].toString();
                int n5 = string.length();
                if (n5 <= nArray[n]) continue;
                nArray[n] = n5;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < n3; ++n) {
            stringBuffer.append(objectArray2[n]);
            for (int i = objectArray2[n].toString().length(); i <= nArray[n]; ++i) {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append(NL);
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < nArray[n]; ++i) {
                stringBuffer.append('-');
            }
            stringBuffer.append(' ');
        }
        stringBuffer.append(NL);
        for (n = 0; n < n4; ++n) {
            objectArray = (Object[])vector.elementAt(n);
            for (int i = 0; i < n3; ++i) {
                String string = objectArray[i] == null ? "" : objectArray[i].toString();
                stringBuffer.append(string);
                for (int j = string.length(); j <= nArray[i]; ++j) {
                    stringBuffer.append(' ');
                }
            }
            stringBuffer.append(NL);
        }
        this.txtResult.setText(stringBuffer.toString());
    }

    private void addToRecent(String string) {
        for (int i = 0; i < iMaxRecent; ++i) {
            if (!string.equals(this.sRecent[i])) continue;
            return;
        }
        if (this.sRecent[this.iRecent] != null) {
            this.mRecent.remove(this.iRecent);
        }
        this.sRecent[this.iRecent] = string;
        if (string.length() > 43) {
            string = string.substring(0, 40) + "...";
        }
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand("#" + this.iRecent);
        jMenuItem.addActionListener(this);
        this.mRecent.insert(jMenuItem, this.iRecent);
        this.iRecent = (this.iRecent + 1) % iMaxRecent;
    }

    @Override
    public final void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public final void mousePressed(MouseEvent mouseEvent) {
        if (this.alreadyHandled == mouseEvent) {
            return;
        }
        this.handlePopup(mouseEvent);
        this.alreadyHandled = mouseEvent;
    }

    @Override
    public final void mouseReleased(MouseEvent mouseEvent) {
        if (this.alreadyHandled == mouseEvent) {
            return;
        }
        this.handlePopup(mouseEvent);
        this.alreadyHandled = mouseEvent;
    }

    public final void handlePopup(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        Object object = mouseEvent.getSource();
        if (!(object instanceof JTree)) {
            return;
        }
        JTree jTree = (JTree)object;
        TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        String[] stringArray = new String[]{"Select", "Delete", "Update", "Insert"};
        for (int i = 0; i < stringArray.length; ++i) {
            PopupListener popupListener = new PopupListener(stringArray[i], treePath);
            String string = popupListener.toString();
            if (string == null) {
                return;
            }
            if (string.length() > 40) {
                string = string.substring(0, 40) + "...";
            }
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(popupListener);
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private String quoteTableName(String string) {
        int n = string.indexOf(".");
        if (n < 0) {
            return this.quoteObjectName(string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return this.quoteObjectName(string2) + '.' + this.quoteObjectName(string3);
    }

    private String quoteObjectName(String string) {
        if (string.toUpperCase().equals(string) && string.indexOf(32) < 0) {
            return string;
        }
        return "\"" + string + "\"";
    }

    private void initGUI() {
        JPanel jPanel = new JPanel();
        this.pResult = new JPanel();
        this.nsSplitPane = new JSplitPane(0, jPanel, this.pResult);
        this.nsSplitPane.setOneTouchExpandable(true);
        jPanel.setLayout(new BorderLayout());
        this.pResult.setLayout(new BorderLayout());
        Font font = new Font("Dialog", 0, 12);
        this.txtCommand = new JTextArea(5, 40);
        this.txtCommand.setMargin(new Insets(5, 5, 5, 5));
        this.txtCommand.addKeyListener(this);
        this.txtCommandScroll = new JScrollPane(this.txtCommand);
        this.txtResult = new JTextArea(20, 40);
        this.txtResult.setMargin(new Insets(5, 5, 5, 5));
        this.txtResultScroll = new JScrollPane(this.txtResult);
        this.txtCommand.setFont(font);
        this.txtResult.setFont(new Font("Courier", 0, 12));
        jPanel.add((Component)this.txtCommandScroll, "Center");
        this.gResult = new GridSwing();
        TableSorter tableSorter = new TableSorter(this.gResult);
        this.tableModel = tableSorter;
        this.gResultTable = new JTable(tableSorter);
        tableSorter.setTableHeader(this.gResultTable.getTableHeader());
        this.gScrollPane = new JScrollPane(this.gResultTable);
        this.gResultTable.setAutoResizeMode(0);
        this.gResult.setJTable(this.gResultTable);
        this.pResult.add((Component)this.gScrollPane, "Center");
        this.rootNode = new DefaultMutableTreeNode("Connection");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tTree = new JTree(this.treeModel);
        this.tScrollPane = new JScrollPane(this.tTree);
        this.tTree.addMouseListener(this);
        this.tScrollPane.setPreferredSize(new Dimension(120, 400));
        this.tScrollPane.setMinimumSize(new Dimension(70, 100));
        this.txtCommandScroll.setPreferredSize(new Dimension(360, 100));
        this.txtCommandScroll.setMinimumSize(new Dimension(180, 100));
        this.gScrollPane.setPreferredSize(new Dimension(460, 300));
        this.ewSplitPane = new JSplitPane(1, this.tScrollPane, this.nsSplitPane);
        this.ewSplitPane.setOneTouchExpandable(true);
        this.fMain.getContentPane().add((Component)this.ewSplitPane, "Center");
        this.jStatusLine = new JLabel();
        iReadyStatus = new JButton(new ImageIcon(CommonSwing.getIcon("StatusReady")));
        iReadyStatus.setSelectedIcon(new ImageIcon(CommonSwing.getIcon("StatusRunning")));
        this.pStatus = new JPanel();
        this.pStatus.setLayout(new BorderLayout());
        this.pStatus.add((Component)iReadyStatus, "West");
        this.pStatus.add((Component)this.jStatusLine, "Center");
        this.fMain.getContentPane().add((Component)this.pStatus, "South");
        this.doLayout();
        if (this.fMain instanceof Window) {
            ((Window)((Object)this.fMain)).pack();
        } else {
            ((Container)((Object)this.fMain)).validate();
        }
    }

    private DefaultMutableTreeNode makeNode(Object object, MutableTreeNode mutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(object);
        if (mutableTreeNode != null) {
            this.treeModel.insertNodeInto(defaultMutableTreeNode, mutableTreeNode, mutableTreeNode.getChildCount());
        }
        return defaultMutableTreeNode;
    }

    protected void refreshTree() {
        this.backgroundIt(this.treeRefreshRunnable, "Refreshing object tree");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void directRefreshTree() {
        Object object;
        DecimalFormat decimalFormat = new DecimalFormat(" ( ####,###,####,##0 )");
        while (this.treeModel.getChildCount(this.rootNode) > 0) {
            object = (DefaultMutableTreeNode)this.treeModel.getChild(this.rootNode, 0);
            this.treeModel.removeNodeFromParent((MutableTreeNode)object);
            ((DefaultMutableTreeNode)object).removeAllChildren();
            ((DefaultMutableTreeNode)object).removeFromParent();
        }
        this.treeModel.nodeStructureChanged(this.rootNode);
        this.treeModel.reload();
        this.tScrollPane.repaint();
        object = null;
        try {
            String string;
            this.rootNode.setUserObject(this.dMeta.getURL());
            object = this.dMeta.getTables(null, null, null, this.showSys ? usertables : nonSystables);
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            while (object.next()) {
                string = object.getString(2);
                if (!this.showSys && this.isOracle && oracleSysUsers.contains(string) || this.schemaFilter != null && !string.equals(this.schemaFilter)) continue;
                vector2.addElement(string);
                vector.addElement(object.getString(3));
                vector3.addElement(object.getString(5));
            }
            object.close();
            object = null;
            int[] nArray = new int[vector.size()];
            try {
                nArray = this.getRowCounts(vector, vector2);
            }
            catch (Exception exception) {
                CommonSwing.errorMessage(exception);
            }
            for (int i = 0; i < vector.size(); ++i) {
                Object object2;
                Object object3;
                DefaultMutableTreeNode defaultMutableTreeNode;
                Object object4;
                Object object5;
                Object object6;
                String string2;
                ResultSet resultSet = null;
                try {
                    string2 = (String)vector.elementAt(i);
                    if (this.isOracle && string2.startsWith("BIN$")) continue;
                    string = (String)vector2.elementAt(i);
                    object6 = "";
                    if (string != null && this.showSchemas) {
                        object6 = string + '.';
                    }
                    object5 = this.displayRowCounts ? " " + decimalFormat.format(nArray[i]) : "";
                    object4 = (String)object6 + string2 + (String)object5;
                    defaultMutableTreeNode = this.makeNode(object4, this.rootNode);
                    resultSet = this.dMeta.getColumns(null, string, string2, null);
                    if (string != null && !string.trim().equals("")) {
                        this.makeNode(string, defaultMutableTreeNode);
                    }
                    if ((object3 = (String)vector3.elementAt(i)) != null && !((String)object3).trim().equals("")) {
                        this.makeNode(object3, defaultMutableTreeNode);
                    }
                    while (resultSet.next()) {
                        String string3 = resultSet.getString(4);
                        object2 = this.makeNode(string3, defaultMutableTreeNode);
                        String string4 = resultSet.getString(6);
                        this.makeNode("Type: " + string4, (MutableTreeNode)object2);
                        boolean bl = resultSet.getInt(11) != 0;
                        this.makeNode("Nullable: " + bl, (MutableTreeNode)object2);
                    }
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                object6 = this.makeNode("Indices", defaultMutableTreeNode);
                if (!this.showIndexDetails) continue;
                object5 = null;
                try {
                    object5 = this.dMeta.getIndexInfo(null, string, string2, false, false);
                    object4 = null;
                    object3 = null;
                    while (object5.next()) {
                        boolean bl = object5.getBoolean(4);
                        object2 = object5.getString(6);
                        if (object4 == null || !((String)object4).equals(object2)) {
                            object3 = this.makeNode(object2, (MutableTreeNode)object6);
                            this.makeNode("Unique: " + !bl, (MutableTreeNode)object3);
                            object4 = object2;
                        }
                        this.makeNode(object5.getString(9), (MutableTreeNode)object3);
                    }
                    continue;
                }
                catch (SQLException sQLException) {
                    if (sQLException.getMessage() != null && (sQLException.getMessage().startsWith("ORA-25191:") || sQLException.getMessage().startsWith("ORA-01702:") || sQLException.getMessage().startsWith("ORA-01031:"))) continue;
                    throw sQLException;
                }
                finally {
                    if (object5 != null) {
                        object5.close();
                        object5 = null;
                    }
                }
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.makeNode("Properties", this.rootNode);
            this.makeNode("User: " + this.dMeta.getUserName(), defaultMutableTreeNode);
            this.makeNode("ReadOnly: " + this.cConn.isReadOnly(), defaultMutableTreeNode);
            this.makeNode("AutoCommit: " + this.cConn.getAutoCommit(), defaultMutableTreeNode);
            this.makeNode("Driver: " + this.dMeta.getDriverName(), defaultMutableTreeNode);
            this.makeNode("Product: " + this.dMeta.getDatabaseProductName(), defaultMutableTreeNode);
            this.makeNode("Version: " + this.dMeta.getDatabaseProductVersion(), defaultMutableTreeNode);
        }
        catch (SQLException sQLException) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.makeNode("Error getting metadata:", this.rootNode);
            this.makeNode(sQLException.getMessage(), defaultMutableTreeNode);
            this.makeNode(sQLException.getSQLState(), defaultMutableTreeNode);
            CommonSwing.errorMessage(sQLException);
        }
        finally {
            if (object != null) {
                try {
                    object.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        this.treeModel.nodeStructureChanged(this.rootNode);
        this.treeModel.reload();
        this.tScrollPane.repaint();
        this.updateSchemaList();
    }

    void setStatusLine(String string, int n) {
        iReadyStatus.setSelected(string != null);
        if (string == null) {
            String string2 = "";
            if (this.schemaFilter != null) {
                string2 = " /  Tree showing objects in schema '" + this.schemaFilter + "'";
            }
            if (n > 1) {
                string2 = string2 + " / " + n + " rows retrieved";
            }
            this.jStatusLine.setText("  " + READY_STATUS + string2);
        } else {
            this.jStatusLine.setText("  " + string + "...");
        }
    }

    protected int[] getRowCounts(Vector vector, Vector vector2) throws Exception {
        if (!this.displayRowCounts) {
            return null;
        }
        String string = "SELECT COUNT(*) FROM ";
        int[] nArray = new int[vector.size()];
        try {
            Statement statement = this.rowConn.createStatement();
            for (int i = 0; i < vector.size(); ++i) {
                try {
                    String string2 = (String)vector2.elementAt(i);
                    string2 = string2 == null ? "" : string2 + '.';
                    String string3 = string2 + (String)vector.elementAt(i);
                    ResultSet resultSet = statement.executeQuery(string + string3);
                    while (resultSet.next()) {
                        nArray[i] = resultSet.getInt(1);
                    }
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("Unable to get row count for table " + vector2.elementAt(i) + '.' + vector.elementAt(i) + ".  Using value '0': " + exception);
                }
            }
        }
        catch (Exception exception) {
            CommonSwing.errorMessage(exception);
        }
        return nArray;
    }

    protected JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.jbuttonClear = new JButton("Clear SQL", new ImageIcon(CommonSwing.getIcon("Clear")));
        this.jbuttonClear.putClientProperty("is3DEnabled", Boolean.TRUE);
        this.tipMap.put(this.jbuttonClear, "Clear SQL");
        this.jbuttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DatabaseManagerSwing.this.sqlScriptBuffer == null && DatabaseManagerSwing.this.txtCommand.getText().length() < 1) {
                    CommonSwing.errorMessage("No SQL to clear");
                    return;
                }
                DatabaseManagerSwing.this.clear();
            }
        });
        this.jbuttonExecute = new JButton("Execute SQL", new ImageIcon(CommonSwing.getIcon("Execute")));
        this.tipMap.put(this.jbuttonExecute, "Execute SQL");
        this.jbuttonExecute.putClientProperty("is3DEnabled", Boolean.TRUE);
        this.jbuttonExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseManagerSwing.this.executeCurrentSQL();
            }
        });
        jToolBar.addSeparator();
        jToolBar.add(this.jbuttonClear);
        jToolBar.addSeparator();
        jToolBar.add(this.jbuttonExecute);
        jToolBar.addSeparator();
        this.jbuttonClear.setAlignmentY(0.5f);
        this.jbuttonClear.setAlignmentX(0.5f);
        this.jbuttonExecute.setAlignmentY(0.5f);
        this.jbuttonExecute.setAlignmentX(0.5f);
        return jToolBar;
    }

    void updateAutoCommitBox() {
        try {
            this.boxAutoCommit.setSelected(this.cConn.getAutoCommit());
        }
        catch (SQLException sQLException) {
            CommonSwing.errorMessage(sQLException);
        }
    }

    private void setLF(String string) {
        if (this.currentLAF != null && this.currentLAF == string) {
            return;
        }
        if (this.pResult != null && this.gridFormat) {
            this.pResult.removeAll();
        }
        CommonSwing.setSwingLAF((Component)((Object)this.fMain), string);
        if (this.pResult != null && this.gridFormat) {
            this.setResultsInGrid();
        }
        this.currentLAF = string;
        if (this.currentLAF.equals(CommonSwing.Native)) {
            this.rbNativeLF.setSelected(true);
        } else if (this.currentLAF.equals(CommonSwing.Java)) {
            this.rbJavaLF.setSelected(true);
        } else if (this.currentLAF.equals(CommonSwing.Motif)) {
            this.rbMotifLF.setSelected(true);
        }
    }

    void resetTooltips() {
        for (JComponent jComponent : this.tipMap.keySet()) {
            jComponent.setToolTipText(this.showTooltips ? (String)this.tipMap.get(jComponent) : (String)null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSchemaList() {
        ButtonGroup buttonGroup = new ButtonGroup();
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSet resultSet = null;
        try {
            resultSet = this.dMeta.getSchemas();
            if (resultSet == null) {
                throw new SQLException("Failed to get metadata from database");
            }
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
        }
        catch (SQLException sQLException) {
            CommonSwing.errorMessage(sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        this.mnuSchemas.removeAll();
        this.rbAllSchemas.setSelected(this.schemaFilter == null);
        buttonGroup.add(this.rbAllSchemas);
        this.mnuSchemas.add(this.rbAllSchemas);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
            buttonGroup.add(jRadioButtonMenuItem);
            this.mnuSchemas.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.setSelected(this.schemaFilter != null && this.schemaFilter.equals(string));
            jRadioButtonMenuItem.addActionListener(this.schemaListListener);
            jRadioButtonMenuItem.setEnabled(arrayList.size() > 1);
        }
        this.mnuSchemas.addSeparator();
        this.mnuSchemas.add(this.mitemUpdateSchemas);
    }

    static {
        try {
            Class<?> clazz = Class.forName("sun.security.action.GetPropertyAction");
            Constructor<?> constructor = clazz.getConstructor(String.class);
            PrivilegedAction privilegedAction = (PrivilegedAction)constructor.newInstance("user.home");
            homedir = (String)AccessController.doPrivileged(privilegedAction);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Failed to get home directory.\nTherefore not retrieving/storing user preferences.\n(" + illegalAccessException.getMessage() + ')');
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("Failed to get home directory.\nTherefore not retrieving/storing user preferences.\n(" + noSuchMethodException.getMessage() + ')');
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Failed to get home directory.\nTherefore not retrieving/storing user preferences.\n(" + classNotFoundException.getMessage() + ')');
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Failed to get home directory.\nTherefore not retrieving/storing user preferences.\n(" + instantiationException.getMessage() + ')');
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("Failed to get home directory.\nTherefore not retrieving/storing user preferences.\n(" + invocationTargetException.getMessage() + ')');
        }
        catch (AccessControlException accessControlException) {
            System.err.println("Failed to get home directory.\nTherefore not retrieving/storing user preferences.\n(" + accessControlException.getMessage() + ')');
        }
        DEFAULT_RCFILE = homedir + "/dbmanager.rc";
        TT_AVAILABLE = false;
        try {
            Class.forName(DatabaseManagerSwing.class.getPackage().getName() + ".Transfer");
            TT_AVAILABLE = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        HELP_TEXT = "See the HSQLDB Utilities Guide, forums and mailing lists \nat http://hsqldb.org.\n\nPlease paste the following version identifier with any\nproblem reports or help requests:  $Revision: 3529 $" + (TT_AVAILABLE ? "" : "\n\nTransferTool classes are not in CLASSPATH.\nTo enable the Tools menu, add 'transfer.jar' to your class path.");
        ABOUT_TEXT = "$Revision: 3529 $ of DatabaseManagerSwing\n\nCopyright (c) 1995-2000, The Hypersonic SQL Group.\nCopyright (c) 2001-2010, The HSQL Development Group.\nhttp://hsqldb.org  (Utilities Guide available at this site).\n\n\nYou may use and redistribute according to the HSQLDB\nlicense documented in the source code and at the web\nsite above." + (TT_AVAILABLE ? "\n\nTransferTool options are available." : "");
        NL = System.getProperty("line.separator");
        iMaxRecent = 24;
        READY_STATUS = "Ready";
        defDriver = "org.hsqldb.jdbcDriver";
        defURL = "jdbc:hsqldb:mem:.";
        defUser = "SA";
        defPassword = "";
        usertables = new String[]{"TABLE", "GLOBAL TEMPORARY", "VIEW", "SYSTEM TABLE"};
        nonSystables = new String[]{"TABLE", "GLOBAL TEMPORARY", "VIEW"};
        oracleSysUsers = new HashSet();
        oracleSysSchemas = new String[]{"SYS", "SYSTEM", "OUTLN", "DBSNMP", "OUTLN", "MDSYS", "ORDSYS", "ORDPLUGINS", "CTXSYS", "DSSYS", "PERFSTAT", "WKPROXY", "WKSYS", "WMSYS", "XDB", "ANONYMOUS", "ODM", "ODM_MTR", "OLAPSYS", "TRACESVR", "REPADMIN"};
        for (int i = 0; i < oracleSysSchemas.length; ++i) {
            oracleSysUsers.add(oracleSysSchemas[i]);
        }
        tString = Boolean.TRUE.toString();
        fString = Boolean.FALSE.toString();
    }

    public class DBMPrefs {
        public File prefsFile = null;
        boolean autoRefresh = true;
        boolean showRowCounts = false;
        boolean showSysTables = false;
        boolean showSchemas = true;
        boolean resultGrid = true;
        String laf = CommonSwing.Native;
        boolean showTooltips = true;

        public DBMPrefs(boolean bl) throws IOException {
            if (!bl) {
                if (homedir == null) {
                    throw new IOException("Skipping preferences since do not know home dir");
                }
                this.prefsFile = new File(homedir, "dbmprefs.properties");
            }
            this.load();
        }

        public void load() throws IOException {
            if (this.prefsFile == null) {
                String string = DatabaseManagerSwing.this.getParameter("autoRefresh");
                if (string != null) {
                    this.autoRefresh = Boolean.valueOf(string);
                }
                if ((string = DatabaseManagerSwing.this.getParameter("showRowCounts")) != null) {
                    this.showRowCounts = Boolean.valueOf(string);
                }
                if ((string = DatabaseManagerSwing.this.getParameter("showSysTables")) != null) {
                    this.showSysTables = Boolean.valueOf(string);
                }
                if ((string = DatabaseManagerSwing.this.getParameter("showSchemas")) != null) {
                    this.showSchemas = Boolean.valueOf(string);
                }
                if ((string = DatabaseManagerSwing.this.getParameter("resultGrid")) != null) {
                    this.resultGrid = Boolean.valueOf(string);
                }
                this.laf = (string = DatabaseManagerSwing.this.getParameter("laf")) == null ? CommonSwing.Native : string;
                string = DatabaseManagerSwing.this.getParameter("showTooltips");
                if (string != null) {
                    this.showTooltips = Boolean.valueOf(string);
                }
            } else {
                if (!this.prefsFile.exists()) {
                    throw new IOException("No such file: " + this.prefsFile);
                }
                Properties properties = new Properties();
                try {
                    FileInputStream fileInputStream = new FileInputStream(this.prefsFile);
                    properties.load(fileInputStream);
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    throw new IOException("Failed to read preferences file '" + this.prefsFile + "':  " + iOException.getMessage());
                }
                String string = properties.getProperty("autoRefresh");
                if (string != null) {
                    this.autoRefresh = Boolean.valueOf(string);
                }
                if ((string = properties.getProperty("showRowCounts")) != null) {
                    this.showRowCounts = Boolean.valueOf(string);
                }
                if ((string = properties.getProperty("showSysTables")) != null) {
                    this.showSysTables = Boolean.valueOf(string);
                }
                if ((string = properties.getProperty("showSchemas")) != null) {
                    this.showSchemas = Boolean.valueOf(string);
                }
                if ((string = properties.getProperty("resultGrid")) != null) {
                    this.resultGrid = Boolean.valueOf(string);
                }
                this.laf = (string = properties.getProperty("laf")) == null ? CommonSwing.Native : string;
                string = properties.getProperty("showTooltips");
                if (string != null) {
                    this.showTooltips = Boolean.valueOf(string);
                }
            }
        }

        public void store() {
            if (this.prefsFile == null) {
                return;
            }
            Properties properties = new Properties();
            properties.setProperty("autoRefresh", this.autoRefresh ? tString : fString);
            properties.setProperty("showRowCounts", this.showRowCounts ? tString : fString);
            properties.setProperty("showSysTables", this.showSysTables ? tString : fString);
            properties.setProperty("showSchemas", this.showSchemas ? tString : fString);
            properties.setProperty("resultGrid", this.resultGrid ? tString : fString);
            properties.setProperty("laf", this.laf);
            properties.setProperty("showTooltips", this.showTooltips ? tString : fString);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.prefsFile);
                properties.store(fileOutputStream, "DatabaseManagerSwing user preferences");
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to prepare preferences file '" + this.prefsFile + "':  " + iOException.getMessage());
            }
        }
    }

    private class PopupListener
    implements ActionListener {
        public static final int DEPTH_URL = 1;
        public static final int DEPTH_TABLE = 2;
        public static final int DEPTH_COLUMN = 3;
        String command;
        TreePath treePath;
        TreePath tablePath;
        TreePath columnPath;
        String table = null;
        String column = null;

        PopupListener(String string, TreePath treePath) {
            this.command = string;
            this.treePath = treePath;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DatabaseManagerSwing.this.txtCommand.setText(this.getCommandString());
        }

        public String toString() {
            return this.getCommandString();
        }

        public String getCommandString() {
            if (this.treePath.getPathCount() == 2) {
                this.tablePath = this.treePath;
                this.table = this.treePath.getPathComponent(1).toString();
            }
            if (this.treePath.getPathCount() == 3) {
                this.tablePath = this.treePath.getParentPath();
                this.table = this.treePath.getPathComponent(1).toString();
                this.columnPath = this.treePath;
                this.column = this.treePath.getPathComponent(2).toString();
            }
            if (this.command.toUpperCase().equals("SELECT")) {
                String string = "SELECT * FROM " + DatabaseManagerSwing.this.quoteTableName(this.table);
                if (this.column != null) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treePath.getLastPathComponent();
                    String string2 = null;
                    if (defaultMutableTreeNode.getChildCount() > 0) {
                        string2 = defaultMutableTreeNode.getFirstChild().toString();
                        boolean bl = string2.indexOf("CHAR") >= 0;
                        string = string + " WHERE " + DatabaseManagerSwing.this.quoteObjectName(this.column);
                        string = bl ? string + " LIKE '%%'" : string + " = ";
                    }
                }
                return string;
            }
            if (this.command.toUpperCase().equals("UPDATE")) {
                String string = "UPDATE " + DatabaseManagerSwing.this.quoteTableName(this.table) + " SET ";
                if (this.column != null) {
                    string = string + DatabaseManagerSwing.this.quoteObjectName(this.column) + " = ";
                }
                return string;
            }
            if (this.command.toUpperCase().equals("DELETE")) {
                String string = "DELETE FROM " + DatabaseManagerSwing.this.quoteTableName(this.table);
                if (this.column != null) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treePath.getLastPathComponent();
                    String string3 = null;
                    if (defaultMutableTreeNode.getChildCount() > 0) {
                        string3 = defaultMutableTreeNode.getFirstChild().toString();
                        boolean bl = string3.indexOf("CHAR") >= 0;
                        string = string + " WHERE " + DatabaseManagerSwing.this.quoteObjectName(this.column);
                        string = bl ? string + " LIKE '%%'" : string + " = ";
                    }
                }
                return string;
            }
            if (this.command.toUpperCase().equals("INSERT")) {
                String string = "";
                String string4 = " ";
                String string5 = "";
                String string6 = "";
                if (this.tablePath == null) {
                    return null;
                }
                TreeNode treeNode = (TreeNode)this.tablePath.getLastPathComponent();
                Enumeration<? extends TreeNode> enumeration = treeNode.children();
                while (enumeration.hasMoreElements()) {
                    TreeNode treeNode2 = enumeration.nextElement();
                    if (treeNode2.toString().equals("Indices")) continue;
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode2;
                    String string7 = null;
                    if (defaultMutableTreeNode.getChildCount() == 0) continue;
                    string7 = defaultMutableTreeNode.getFirstChild().toString();
                    string6 = string7.indexOf("CHAR") >= 0 ? "''" : "";
                    string = string + string5 + DatabaseManagerSwing.this.quoteObjectName(treeNode2.toString());
                    string4 = string4 + string5 + string6;
                    string5 = ", ";
                }
                return "INSERT INTO " + DatabaseManagerSwing.this.quoteTableName(this.table) + "\n( " + string + " )\nVALUES (" + string4 + ")";
            }
            return "Got here in error " + this.command + ".  Should never happen";
        }
    }

    protected class StatementExecRunnable
    implements Runnable {
        protected StatementExecRunnable() {
        }

        @Override
        public void run() {
            DatabaseManagerSwing.this.gResult.clear();
            try {
                if (DatabaseManagerSwing.this.txtCommand.getText().startsWith("-->>>TEST<<<--")) {
                    DatabaseManagerSwing.this.testPerformance();
                } else {
                    DatabaseManagerSwing.this.executeSQL();
                }
                DatabaseManagerSwing.this.updateResult();
                DatabaseManagerSwing.this.displayResults();
                DatabaseManagerSwing.this.updateAutoCommitBox();
            }
            catch (RuntimeException runtimeException) {
                CommonSwing.errorMessage(runtimeException);
                throw runtimeException;
            }
            finally {
                DatabaseManagerSwing.this.setWaiting(null);
            }
        }
    }
}

