/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.netbeans.core.NbNodeOperation;
import org.netbeans.core.actions.DockingAction;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.RegistryImpl;
import org.netbeans.core.windows.SelectedNodesChangedEvent;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.dnd.DropTargetGlassPane;
import org.netbeans.core.windows.dnd.TopComponentDragSupport;
import org.netbeans.core.windows.dnd.WindowDnDManager;
import org.netbeans.core.windows.frames.FrameType;
import org.netbeans.core.windows.frames.FrameTypeEvent;
import org.netbeans.core.windows.frames.FrameTypeListener;
import org.netbeans.core.windows.frames.MultiTabbedContainerImpl;
import org.netbeans.core.windows.frames.PerimeterPane;
import org.netbeans.core.windows.frames.SplitContainerImpl;
import org.netbeans.core.windows.frames.TopComponentContainer;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.actions.CloneViewAction;
import org.openide.actions.CloseViewAction;
import org.openide.actions.NextTabAction;
import org.openide.actions.PreviousTabAction;
import org.openide.actions.UndockAction;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

abstract class DefaultContainerImpl
extends JPanel
implements TopComponentContainer,
ActionPerformer,
PropertyChangeListener,
FrameTypeListener,
AWTEventListener,
DropTargetListener,
TopComponentContainer.DropIndicator {
    private final List topComponents = new ArrayList(10);
    private boolean hasFocus = false;
    private TopComponent selected;
    private boolean isSelectedInSync = false;
    private final Map tcs2Weights = new HashMap(15);
    private Component originalGlassPane;
    protected static CloneViewAction clone = (CloneViewAction)SystemAction.get((Class)(class$org$openide$actions$CloneViewAction == null ? (class$org$openide$actions$CloneViewAction = DefaultContainerImpl.class$("org.openide.actions.CloneViewAction")) : class$org$openide$actions$CloneViewAction));
    protected static UndockAction undock = (UndockAction)SystemAction.get((Class)(class$org$openide$actions$UndockAction == null ? (class$org$openide$actions$UndockAction = DefaultContainerImpl.class$("org.openide.actions.UndockAction")) : class$org$openide$actions$UndockAction));
    protected static NextTabAction nextTab = (NextTabAction)SystemAction.get((Class)(class$org$openide$actions$NextTabAction == null ? (class$org$openide$actions$NextTabAction = DefaultContainerImpl.class$("org.openide.actions.NextTabAction")) : class$org$openide$actions$NextTabAction));
    protected static PreviousTabAction prevTab = (PreviousTabAction)SystemAction.get((Class)(class$org$openide$actions$PreviousTabAction == null ? (class$org$openide$actions$PreviousTabAction = DefaultContainerImpl.class$("org.openide.actions.PreviousTabAction")) : class$org$openide$actions$PreviousTabAction));
    protected static CloseViewAction closeView = (CloseViewAction)SystemAction.get((Class)(class$org$openide$actions$CloseViewAction == null ? (class$org$openide$actions$CloseViewAction = DefaultContainerImpl.class$("org.openide.actions.CloseViewAction")) : class$org$openide$actions$CloseViewAction));
    protected static DockingAction docking = (DockingAction)SystemAction.get((Class)(class$org$netbeans$core$actions$DockingAction == null ? (class$org$netbeans$core$actions$DockingAction = DefaultContainerImpl.class$("org.netbeans.core.actions.DockingAction")) : class$org$netbeans$core$actions$DockingAction));
    private static final int TYPE_CLONE_ACTION = 0;
    private static final int TYPE_UNDOCK_ACTION = 1;
    private static final int TYPE_NEXT_ACTION = 2;
    private static final int TYPE_PREVIOUS_ACTION = 3;
    private static final int TYPE_CLOSE_ACTION = 4;
    private static final int TYPE_DOCKING_ACTION = 5;
    protected WindowManagerImpl wm;
    protected ModeImpl mode;
    private PropertyChangeListener weakModeL;
    private FrameTypeListener weakFrameL;
    private boolean attached;
    private PropertyChangeSupport propChangeSupport;
    private SerializedData serData;
    private final Object MODE_LOCK = new Object();
    private final Object LOCK_TOPCOMPONENTS = new Object();
    static /* synthetic */ Class class$org$openide$actions$CloneViewAction;
    static /* synthetic */ Class class$org$openide$actions$UndockAction;
    static /* synthetic */ Class class$org$openide$actions$NextTabAction;
    static /* synthetic */ Class class$org$openide$actions$PreviousTabAction;
    static /* synthetic */ Class class$org$openide$actions$CloseViewAction;
    static /* synthetic */ Class class$org$netbeans$core$actions$DockingAction;
    static /* synthetic */ Class class$javax$swing$JInternalFrame;
    static /* synthetic */ Class class$org$netbeans$core$windows$frames$FrameTypeListener;

    protected DefaultContainerImpl() {
        this((SerializedData)null);
    }

    protected DefaultContainerImpl(SerializedData serData) {
        this.wm = (WindowManagerImpl)WindowManager.getDefault();
        this.serData = serData;
    }

    public void dragEnter(DropTargetDragEvent evt) {
        if ((evt.getDropAction() & 3) > 0) {
            evt.acceptDrag(evt.getDropAction());
        } else {
            evt.rejectDrag();
        }
        TopComponentDragSupport.getDefault().dragEnterHack(evt.getDropAction());
    }

    public void dragExit(DropTargetEvent evt) {
        Component c = evt.getDropTargetContext().getComponent();
        if (c instanceof DropTargetGlassPane) {
            ((DropTargetGlassPane)c).dragExited();
        }
        TopComponentDragSupport.getDefault().dragExitHack();
    }

    public void dragExitedHack() {
        Component c = this.getRootPane().getGlassPane();
        if (c instanceof DropTargetGlassPane) {
            ((DropTargetGlassPane)c).dragExitedHack();
        }
    }

    public void dragOver(DropTargetDragEvent evt) {
        int dropAction = evt.getDropAction();
        boolean acceptDrag = dropAction == 2 || dropAction == 1 && TopComponentDragSupport.getDefault().copyOperationPossible();
        Component c = evt.getDropTargetContext().getComponent();
        if (c instanceof DropTargetGlassPane) {
            ((DropTargetGlassPane)c).dragOver(acceptDrag ? evt.getLocation() : null);
        }
        WindowDnDManager.getDefault().setLastDropTarget(this);
    }

    public void dropActionChanged(DropTargetDragEvent evt) {
        int dropAction = evt.getDropAction();
        boolean acceptDrag = dropAction == 2 || dropAction == 1 && TopComponentDragSupport.getDefault().copyOperationPossible();
        if (acceptDrag) {
            evt.acceptDrag(dropAction);
        } else {
            evt.rejectDrag();
        }
        Component c = evt.getDropTargetContext().getComponent();
        if (c instanceof DropTargetGlassPane) {
            ((DropTargetGlassPane)c).dragActionChanged(acceptDrag ? evt.getLocation() : null);
        }
    }

    public void drop(DropTargetDropEvent evt) {
        int dropAction;
        Component c = evt.getDropTargetContext().getComponent();
        if (c instanceof DropTargetGlassPane) {
            ((DropTargetGlassPane)c).dragFinished();
        }
        if ((dropAction = evt.getDropAction()) != 2 && dropAction != 1) {
            evt.rejectDrop();
            return;
        }
        evt.acceptDrop(dropAction);
        boolean success = false;
        try {
            TopComponent tc = TopComponentDragSupport.extractTopComponent(dropAction == 1, evt.getTransferable(), this.getClass().getClassLoader());
            if (tc != null) {
                success = this.performDrop(dropAction, tc, evt.getLocation());
            }
            Object var7_6 = null;
            WindowDnDManager.getDefault().setDropSuccess(success);
            evt.dropComplete(false);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            WindowDnDManager.getDefault().setDropSuccess(success);
            evt.dropComplete(false);
            throw throwable;
        }
    }

    private boolean performDrop(int dropAction, TopComponent tc, Point location) {
        Object constraint = this.getConstraintForLocation(location);
        boolean open = dropAction == 1;
        boolean success = false;
        if (this.containsTopComponent(tc)) {
            if (this instanceof MultiTabbedContainerImpl) {
                return true;
            }
            if (this instanceof SplitContainerImpl) {
                PerimeterPane pp = (PerimeterPane)this.getComponent(0);
                Component comp = pp.getComponentAt((String)constraint);
                if (comp != null && (comp == tc || SwingUtilities.isDescendingFrom((Component)tc, comp))) {
                    return true;
                }
                this.removeTopComponent(tc);
                success = this.addTopComponent(tc, true, constraint);
            }
        } else {
            success = this.mode.dockInto(tc, constraint);
        }
        if (open) {
            tc.open();
        }
        tc.requestFocus();
        return success;
    }

    public void windowDragStarting() {
        JRootPane rootPane = this.getRootPane();
        if (rootPane == null) {
            return;
        }
        this.originalGlassPane = rootPane.getGlassPane();
        DropTargetGlassPane dropGlass = new DropTargetGlassPane(this);
        new DropTarget(dropGlass, 3, this);
        rootPane.setGlassPane(dropGlass);
        dropGlass.initialize();
    }

    public void windowDragFinished() {
        JRootPane rootPane = this.getRootPane();
        if (rootPane == null) {
            return;
        }
        Component glass = rootPane.getGlassPane();
        if (glass instanceof DropTargetGlassPane) {
            DropTargetGlassPane dropGlass = (DropTargetGlassPane)glass;
            dropGlass.setDropTarget(null);
            dropGlass.uninitialize();
        }
        rootPane.setGlassPane(this.originalGlassPane);
        JInternalFrame internalFrame = (JInternalFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JInternalFrame == null ? (class$javax$swing$JInternalFrame = DefaultContainerImpl.class$("javax.swing.JInternalFrame")) : class$javax$swing$JInternalFrame, this);
        if (internalFrame != null && !internalFrame.isSelected() && !this.originalGlassPane.isVisible()) {
            this.originalGlassPane.setVisible(true);
        }
    }

    public Object getConstraintForLocation(Point location) {
        return null;
    }

    public String getDescriptionForLocation(Point location) {
        return null;
    }

    public Shape getIndicationForLocation(Point location) {
        return this.getBounds();
    }

    public void attachToMode(ModeImpl mode) {
        ModeImpl oldMode = this.mode;
        ModeImpl newMode = mode;
        this.changeModeDetachOld(oldMode);
        if (newMode == null) {
            this.setAttached(false);
        }
        Object object = this.MODE_LOCK;
        synchronized (object) {
            this.mode = newMode;
        }
        this.changeModeAttachNew(newMode);
        this.changeFrame(oldMode == null ? null : oldMode.getFrameInstance(), newMode == null ? null : newMode.getFrameInstance());
    }

    private void changeModeDetachOld(ModeImpl oldMode) {
        if (oldMode != null) {
            oldMode.removePropertyChangeListener(this.weakModeL);
            Object object = this.LOCK_TOPCOMPONENTS;
            synchronized (object) {
                Iterator iter = this.topComponents.iterator();
                while (iter.hasNext()) {
                    TopComponent curTc = (TopComponent)iter.next();
                    WindowManagerImpl.findManager(curTc).removePropertyChangeListener(this);
                }
            }
            this.weakModeL = null;
        }
    }

    private void changeModeAttachNew(ModeImpl newMode) {
        if (newMode != null) {
            this.weakModeL = WeakListener.propertyChange((PropertyChangeListener)this, (Object)newMode);
            newMode.addPropertyChangeListener(this.weakModeL);
        }
    }

    private void changeFrame(FrameType oldFrame, FrameType newFrame) {
        if (oldFrame != null) {
            oldFrame.removeFrameTypeListener(this.weakFrameL);
            this.weakFrameL = null;
        }
        if (newFrame != null) {
            this.weakFrameL = (FrameTypeListener)WeakListener.create((Class)(class$org$netbeans$core$windows$frames$FrameTypeListener == null ? (class$org$netbeans$core$windows$frames$FrameTypeListener = DefaultContainerImpl.class$("org.netbeans.core.windows.frames.FrameTypeListener")) : class$org$netbeans$core$windows$frames$FrameTypeListener), (EventListener)this, (Object)newFrame);
            newFrame.addFrameTypeListener(this.weakFrameL);
        }
    }

    public TopComponent[] getTopComponents() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            TopComponent[] topComponentArray = this.topComponents.toArray(new TopComponent[this.topComponents.size()]);
            return topComponentArray;
        }
    }

    public boolean addTopComponent(TopComponent tc, boolean selectExisting) {
        return this.addTopComponent(tc, selectExisting, null);
    }

    public boolean addTopComponent(TopComponent tc, boolean selectExisting, Object constr) {
        return this.addTopComponent(tc, selectExisting, constr, Integer.MAX_VALUE);
    }

    public boolean addTopComponent(TopComponent tc, boolean selectExisting, Object constr, int orderWeight) {
        return this.addTopComponent(tc, selectExisting, constr, orderWeight, null);
    }

    public boolean addTopComponent(TopComponent tc, boolean selectExisting, Object constr, int orderWeight, TopComponentContainer.Area area) {
        if (!this.canAdd(new TopComponent[]{tc})) {
            return false;
        }
        if (this.containsTopComponent(tc)) {
            return false;
        }
        this.insertTopComponent(tc, orderWeight);
        this.tcs2Weights.put(tc, new Integer(orderWeight));
        if (constr == null) {
            this.componentAdded(tc);
        } else {
            this.componentAdded(tc, constr, orderWeight, area);
        }
        if (this.containsTopComponent(tc) && selectExisting) {
            this.setSelectedTopComponent(tc);
        }
        if (this.isAttached()) {
            this.doActivateComponent(tc);
        }
        WindowManagerImpl.findManager(tc).addPropertyChangeListener(this);
        return true;
    }

    private void insertTopComponent(TopComponent tc, int orderWeight) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            int i = 0;
            while (i < this.topComponents.size()) {
                TopComponent curTc = (TopComponent)this.topComponents.get(i);
                int w = this.getOrderWeight(curTc);
                if (orderWeight < w) {
                    this.topComponents.add(i, tc);
                    return;
                }
                ++i;
            }
            this.topComponents.add(tc);
        }
    }

    public int getOrderWeight(TopComponent tc) {
        Integer value = (Integer)this.tcs2Weights.get(tc);
        return value != null ? value : Integer.MAX_VALUE;
    }

    protected final int findPosition(int orderWeight, Object constraint) {
        TopComponentContainer.Area area = this.getArea(constraint);
        if (area == null) {
            return 0;
        }
        List tcList = area.getComponentsList();
        int result = 0;
        TopComponent curTc = null;
        Iterator iter = tcList.iterator();
        while (iter.hasNext()) {
            curTc = (TopComponent)iter.next();
            if (orderWeight < this.getOrderWeight(curTc)) break;
            ++result;
        }
        return result;
    }

    public final int removeTopComponent(TopComponent tc) {
        int count;
        WindowManagerImpl.findManager(tc).removePropertyChangeListener(this);
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            if (!this.topComponents.contains(tc)) {
                int n = this.topComponents.size();
                return n;
            }
            this.topComponents.remove(tc);
            count = this.topComponents.size();
        }
        this.tcs2Weights.remove(tc);
        boolean selectedChanged = false;
        if (tc.equals(this.selected)) {
            if (count == 0) {
                this.selected = null;
            }
            selectedChanged = true;
        }
        if (tc.equals(TopComponent.getRegistry().getActivated())) {
            this.doActivateComponent(null);
        }
        this.componentRemoved(tc);
        if (this.isAttached() && selectedChanged) {
            this.reactivateSelectedComponent();
        }
        return count;
    }

    public boolean containsTopComponent(TopComponent tc) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            boolean bl = this.topComponents.contains(tc);
            return bl;
        }
    }

    public TopComponent getSelectedTopComponent() {
        return this.selected;
    }

    public void requestFocus(TopComponent tc) {
        this.setSelectedTopComponent(tc);
    }

    public Container getContentPane() {
        return this;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        String propName = ev.getPropertyName();
        Object source = ev.getSource();
        DoPropertyChange doPropChange = null;
        if (source instanceof WindowManagerImpl.TopComponentManager) {
            TopComponent tc = ((WindowManagerImpl.TopComponentManager)source).getComponent();
            if ("name".equals(propName)) {
                doPropChange = new DoPropertyChange(0, tc, ev);
            } else if ("icon".equals(propName)) {
                doPropChange = new DoPropertyChange(1, tc, ev);
            } else if (this.propChangeSupport != null && this.propChangeSupport.hasListeners(propName)) {
                doPropChange = new DoPropertyChange(2, null, ev);
            }
        } else if (source instanceof ModeImpl && "frameInstance".equals(propName)) {
            doPropChange = new DoPropertyChange(3, null, ev);
        }
        if (doPropChange == null) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            doPropChange.run();
        } else {
            EventQueue.invokeLater(doPropChange);
        }
    }

    public void performAction(SystemAction action) {
        this.doPerformAction(action, null);
    }

    private void doPerformAction(final SystemAction action, TopComponent tc) {
        TopComponent selected;
        TopComponent topComponent = selected = tc != null ? tc : this.getSelectedTopComponent();
        if (selected == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.doPerformAction(selected, action);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DefaultContainerImpl.this.doPerformAction(selected, action);
                }
            });
        }
    }

    private void doPerformAction(TopComponent selected, SystemAction action) {
        if (action instanceof CloseViewAction) {
            selected.close();
            this.actionPerformed(selected, action, true);
        } else if (action instanceof CloneViewAction) {
            WindowUtils.dockIntoNewMode(selected, true);
            this.actionPerformed(selected, action, true);
        } else if (action instanceof UndockAction) {
            WindowUtils.dockIntoNewMode(selected, false);
            this.actionPerformed(selected, action, true);
        } else {
            this.actionPerformed(selected, action, false);
        }
    }

    protected boolean isAttached() {
        return this.attached;
    }

    public void setAttached(boolean attached) {
        if (this.attached == attached) {
            return;
        }
        this.attached = attached;
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            if (attached) {
                this.attachComponents();
            } else {
                this.detachComponents();
            }
        }
        if (attached) {
            this.mode.updateTitle();
            this.hangUpFocusListener();
        } else {
            this.hangDownFocusListener();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propChangeSupport == null) {
            this.propChangeSupport = new PropertyChangeSupport(this);
        }
        this.propChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propChangeSupport != null) {
            this.propChangeSupport.removePropertyChangeListener(listener);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.propChangeSupport != null) {
            this.propChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        if (this.propChangeSupport != null) {
            this.propChangeSupport.firePropertyChange(evt);
        }
    }

    protected void doActivateComponent(TopComponent tc) {
        if (this.hasFocus && (tc == null || ((WorkspaceImpl)this.mode.getWorkspace()).getShownTcs().contains(tc))) {
            this.wm.activateComponent(tc);
        }
        if (!(tc instanceof NbNodeOperation.Sheet)) {
            RegistryImpl rimpl = (RegistryImpl)TopComponent.getRegistry();
            Node[] nodes = tc == null ? new Node[]{} : tc.getActivatedNodes();
            rimpl.selectedNodesChanged(new SelectedNodesChangedEvent(this, tc, nodes));
        }
    }

    void registerPerformers() {
        Workspace curWorkspace;
        Mode compMode;
        this.updateNextAndPreviousState();
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            if (this.topComponents.size() <= 0) {
                return;
            }
        }
        closeView.setActionPerformer((ActionPerformer)this);
        TopComponent selected = this.getSelectedTopComponent();
        if (selected != null && (compMode = (curWorkspace = this.wm.getCurrentWorkspace()).findMode(selected)) != null && !((ModeImpl)compMode).isSingle()) {
            undock.setActionPerformer((ActionPerformer)this);
        }
        if (selected instanceof TopComponent.Cloneable) {
            clone.setActionPerformer((ActionPerformer)this);
        }
    }

    void updateNextAndPreviousState() {
        boolean setPerformer;
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            setPerformer = this.topComponents.size() > 1;
        }
        if (setPerformer) {
            nextTab.setActionPerformer((ActionPerformer)this);
            prevTab.setActionPerformer((ActionPerformer)this);
        } else {
            nextTab.setActionPerformer(null);
            prevTab.setActionPerformer(null);
        }
    }

    public final void setSelectedTopComponent(TopComponent tc) {
        if (this.isSelectedInSync && this.selected == tc) {
            return;
        }
        if (tc != null && !this.containsTopComponent(tc)) {
            throw new IllegalArgumentException("Cannot set " + tc.getName() + " as selected. " + "It's not present in the container.");
        }
        this.selected = tc;
        if (this.isAttached()) {
            List notifyHidden = this.updateShownComponents(this.selected);
            Object object = this.MODE_LOCK;
            synchronized (object) {
                if (this.mode != null) {
                    this.isSelectedInSync = true;
                    this.mode.updateTitle();
                    this.componentSelected(this.selected);
                } else {
                    this.isSelectedInSync = false;
                }
            }
            Iterator it = notifyHidden.iterator();
            while (it.hasNext()) {
                ((WorkspaceImpl)this.mode.getWorkspace()).removeFromShownTcs((TopComponent)it.next());
            }
        } else {
            this.isSelectedInSync = false;
        }
    }

    protected List updateShownComponents(TopComponent showing) {
        WorkspaceImpl ws = (WorkspaceImpl)this.mode.getWorkspace();
        Set shownTcs = ws.getShownTcs();
        if (showing == null || shownTcs.contains(showing)) {
            return Collections.EMPTY_LIST;
        }
        Set pendingShownTcs = ((WorkspaceImpl)this.mode.getWorkspace()).getPendingShownTcs();
        if (pendingShownTcs.contains(showing)) {
            pendingShownTcs.remove(showing);
            shownTcs.add(showing);
            ((WorkspaceImpl)this.mode.getWorkspace()).setShownTcs(shownTcs);
            ws.setPendingShownTcs(pendingShownTcs);
            return Collections.EMPTY_LIST;
        }
        List hidding = this.getHiddingComponents(shownTcs, showing);
        ws.addToShownTcs(showing);
        return hidding == null ? Collections.EMPTY_LIST : hidding;
    }

    protected abstract List getHiddingComponents(Set var1, TopComponent var2);

    public boolean reorder(List newOrder) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            if (this.topComponents.size() != newOrder.size()) {
                boolean bl = false;
                return bl;
            }
            Iterator iter = newOrder.iterator();
            while (iter.hasNext()) {
                if (this.topComponents.contains(iter.next())) continue;
                boolean bl = false;
                return bl;
            }
        }
        if (this.isAttached()) {
            new ReorderPerformer(newOrder);
        } else {
            Object object2 = this.LOCK_TOPCOMPONENTS;
            synchronized (object2) {
                this.topComponents.clear();
                this.topComponents.addAll(newOrder);
            }
        }
        return true;
    }

    protected JPopupMenu createPopupMenu(TopComponent tc) {
        ArrayList<Action> actions = new ArrayList<Action>(Arrays.asList(tc.getActions()));
        if (actions.size() > 0) {
            actions.add(null);
        }
        actions.add((Action)((Object)docking));
        return Utilities.actionsToPopup((Action[])actions.toArray(new Action[0]), (Lookup)new ProxyLookup(new Lookup[]{tc.getLookup(), Lookups.singleton((Object)DefaultContainerImpl.createContainerActionMap(this, tc))}));
    }

    protected void showPopupMenu(JPopupMenu popup, Point p, Component comp) {
        SwingUtilities.convertPointToScreen(p, comp);
        Dimension popupSize = popup.getPreferredSize();
        Rectangle screenBounds = Utilities.getUsableScreenBounds((GraphicsConfiguration)this.getGraphicsConfiguration());
        if (p.x + popupSize.width > screenBounds.x + screenBounds.width) {
            p.x = screenBounds.x + screenBounds.width - popupSize.width;
        }
        if (p.y + popupSize.height > screenBounds.y + screenBounds.height) {
            p.y = screenBounds.y + screenBounds.height - popupSize.height;
        }
        SwingUtilities.convertPointFromScreen(p, comp);
        popup.show(comp, p.x, p.y);
    }

    protected boolean isActivated() {
        return this.hasFocus;
    }

    protected void reactivateSelectedComponent() {
        if (!this.isActivated() || this.mode == null) {
            return;
        }
        TopComponent selected = this.getSelectedTopComponent();
        this.doActivateComponent(selected);
        this.registerPerformers();
        WorkspaceImpl ws = (WorkspaceImpl)this.mode.getWorkspace();
        ws.setLastActivatedMode(this.mode);
        if (selected != null && SwingUtilities.findFocusOwner((Component)selected) == null) {
            WindowManagerImpl wmi = (WindowManagerImpl)WindowManager.getDefault();
            if (wmi.isSwitchingWorkspace()) {
                ws.setSavedActive(selected);
            } else {
                selected.requestFocus();
            }
        }
    }

    private void reactivateWithDelay() {
        Runnable pendingActivator = new Runnable(){

            public void run() {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(this);
                    return;
                }
                if (DefaultContainerImpl.this.isActivated()) {
                    DefaultContainerImpl.this.reactivateSelectedComponent();
                }
            }
        };
        RequestProcessor.getDefault().post(pendingActivator, 100, 10);
    }

    public abstract void requestVisible(TopComponent var1);

    public abstract boolean canAdd(TopComponent[] var1);

    public abstract Object getConstraints(TopComponent var1);

    public abstract void destroy();

    protected abstract void attachComponents();

    protected abstract void detachComponents();

    protected abstract void componentAdded(TopComponent var1);

    protected abstract void componentAdded(TopComponent var1, Object var2, int var3, TopComponentContainer.Area var4);

    protected abstract void componentRemoved(TopComponent var1);

    protected abstract void componentSelected(TopComponent var1);

    protected abstract void componentNameChanged(TopComponent var1);

    protected abstract void componentIconChanged(TopComponent var1, Image var2);

    protected abstract void actionPerformed(TopComponent var1, SystemAction var2, boolean var3);

    protected void componentFocusGained(TopComponent tc, FocusEvent ev) {
        Window window = SwingUtilities.windowForComponent((Component)tc);
        if (window != null && window.getFocusOwner() == null) {
            final Component source = ev.getComponent();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    source.dispatchEvent(new FocusEvent(source, 1005));
                }
            });
        }
    }

    protected void componentFocusLost(TopComponent tc, FocusEvent ev) {
    }

    public void frameDeactivated(FrameTypeEvent fe) {
        this.hasFocus = false;
    }

    public void frameClosed(FrameTypeEvent fe) {
    }

    public void frameDeiconified(FrameTypeEvent fe) {
    }

    public void frameNormalized(FrameTypeEvent fe) {
    }

    public void frameOpened(FrameTypeEvent fe) {
    }

    public void frameIconified(FrameTypeEvent fe) {
    }

    public void frameClosing(FrameTypeEvent fe) {
    }

    public void frameActivated(FrameTypeEvent fe) {
        this.hasFocus = true;
        this.reactivateWithDelay();
    }

    public void frameMaximized(FrameTypeEvent fe) {
    }

    private static JComponent mainContentPane() {
        JFrame main = (JFrame)WindowManager.getDefault().getMainWindow();
        return (JComponent)main.getContentPane();
    }

    public void eventDispatched(AWTEvent ev) {
        if (this.mode == null) {
            return;
        }
        WindowManagerImpl wmi = (WindowManagerImpl)WindowManager.getDefault();
        if (wmi.isSwitchingWorkspaceIgnoreFocusEvent()) {
            return;
        }
        TopComponent tc = this.getFocusedTopComponent((FocusEvent)ev);
        if (tc != null) {
            if (ev.getID() == 1004) {
                this.componentFocusGained(tc, (FocusEvent)ev);
            } else {
                this.componentFocusLost(tc, (FocusEvent)ev);
            }
        }
    }

    private TopComponent getFocusedTopComponent(FocusEvent ev) {
        TopComponent[] tcs = this.getTopComponents();
        int i = 0;
        while (i < tcs.length) {
            if (SwingUtilities.isDescendingFrom(ev.getComponent(), (Component)tcs[i])) {
                return tcs[i];
            }
            ++i;
        }
        return null;
    }

    private void hangUpFocusListener() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 4L);
    }

    private void hangDownFocusListener() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    protected final void attachData(SerializedData serData) {
        this.serData = serData;
    }

    public void validateData() {
        this.validateData(this.serData);
    }

    private void validateData(SerializedData serData) {
        if (serData == null) {
            return;
        }
        ModeImpl ourMode = (ModeImpl)WindowManager.getDefault().findWorkspace(serData.workspaceName).findMode(serData.modeName);
        if (ourMode == null) {
            throw new IllegalStateException("Mode " + serData.modeName + " cannot be found!");
        }
        this.attachToMode(ourMode);
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            this.topComponents.clear();
            this.tcs2Weights.clear();
            TopComponent current = null;
            int i = 0;
            Iterator iter = ((AbstractList)serData.tcManagers).iterator();
            while (iter.hasNext()) {
                WindowManagerImpl.TopComponentManager cur = (WindowManagerImpl.TopComponentManager)iter.next();
                if (cur != null && cur.validateData()) {
                    this.topComponents.add(cur.getComponent());
                    this.tcs2Weights.put(cur.getComponent(), new Integer(i));
                    if (cur.equals(serData.currentTcm)) {
                        current = cur.getComponent();
                    }
                }
                ++i;
            }
            int count = this.topComponents.size();
            if (current == null && count > 0) {
                current = (TopComponent)this.topComponents.get(0);
            }
            this.setSelectedTopComponent(current);
            Iterator iter2 = this.topComponents.iterator();
            while (iter2.hasNext()) {
                TopComponent curTc = (TopComponent)iter2.next();
                WindowManagerImpl.findManager(curTc).addPropertyChangeListener(this);
            }
        }
        serData = null;
    }

    private static ActionMap createContainerActionMap(DefaultContainerImpl container, TopComponent selected) {
        ActionMap am = new ActionMap();
        if (selected instanceof TopComponent.Cloneable) {
            am.put(clone.getActionMapKey(), new PerformerAction(container, 0, selected));
        }
        am.put(undock.getActionMapKey(), new PerformerAction(container, 1, selected));
        am.put(nextTab.getActionMapKey(), new PerformerAction(container, 2, selected));
        am.put(prevTab.getActionMapKey(), new PerformerAction(container, 3, selected));
        am.put(closeView.getActionMapKey(), new PerformerAction(container, 4, selected));
        return am;
    }

    public abstract void checkShownComponents();

    public abstract TopComponentContainer.Area getArea(Object var1);

    public abstract List getAreas();

    public abstract void setConstraintsOrder(List var1);

    public abstract List getConstraintsOrder();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PerformerAction
    extends AbstractAction {
        private final int type;
        private final TopComponent tc;
        private final DefaultContainerImpl container;

        public PerformerAction(DefaultContainerImpl container, int type, TopComponent tc) {
            this.type = type;
            this.tc = tc;
            this.container = container;
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.type == 0) {
                this.container.doPerformAction((SystemAction)clone, this.tc);
            } else if (this.type == 1) {
                this.container.doPerformAction((SystemAction)undock, this.tc);
            } else if (this.type == 2) {
                this.container.doPerformAction((SystemAction)nextTab, this.tc);
            } else if (this.type == 3) {
                this.container.doPerformAction((SystemAction)prevTab, this.tc);
            } else if (this.type == 4) {
                this.container.doPerformAction((SystemAction)closeView, this.tc);
            } else if (this.type == 5) {
                this.container.doPerformAction((SystemAction)docking, this.tc);
            }
        }
    }

    protected static final class SerializedData
    implements Serializable {
        static final long serialVersionUID = 2108673887921434234L;
        public static final String MODE_NAME = "modeName";
        public static final String WORKSPACE_NAME = "workspaceName";
        public static final String MANAGERS_LIST = "tcManagers";
        public static final String CURRENT_MANAGER = "currentTcm";
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("modeName", class$java$lang$String == null ? (class$java$lang$String = SerializedData.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("workspaceName", class$java$lang$String == null ? (class$java$lang$String = SerializedData.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("tcManagers", class$java$util$ArrayList == null ? (class$java$util$ArrayList = SerializedData.class$("java.util.ArrayList")) : class$java$util$ArrayList), new ObjectStreamField("currentTcm", class$org$netbeans$core$windows$WindowManagerImpl$TopComponentManager == null ? (class$org$netbeans$core$windows$WindowManagerImpl$TopComponentManager = SerializedData.class$("org.netbeans.core.windows.WindowManagerImpl$TopComponentManager")) : class$org$netbeans$core$windows$WindowManagerImpl$TopComponentManager)};
        String modeName;
        String workspaceName;
        ArrayList tcManagers;
        WindowManagerImpl.TopComponentManager currentTcm;
        private DefaultContainerImpl source;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$java$util$ArrayList;
        static /* synthetic */ Class class$org$netbeans$core$windows$WindowManagerImpl$TopComponentManager;

        protected SerializedData(DefaultContainerImpl source) {
            this(source, null, null, null, null);
        }

        protected SerializedData(DefaultContainerImpl source, String modeName, String workspaceName, ArrayList tcManagers, WindowManagerImpl.TopComponentManager currentTcm) {
            this.source = source;
            this.modeName = modeName;
            this.workspaceName = workspaceName;
            this.tcManagers = tcManagers;
            this.currentTcm = currentTcm;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            ObjectOutputStream.PutField pf = oos.putFields();
            pf.put(WORKSPACE_NAME, this.source.mode.getWorkspace().getName());
            pf.put(MODE_NAME, this.source.mode.getName());
            TopComponent[] tcs = this.source.getTopComponents();
            ArrayList<WindowManagerImpl.TopComponentManager> tcManagers = new ArrayList<WindowManagerImpl.TopComponentManager>(tcs.length);
            int i = 0;
            while (i < tcs.length) {
                tcManagers.add(WindowManagerImpl.findManager(tcs[i]));
                ++i;
            }
            pf.put(MANAGERS_LIST, tcManagers);
            WindowManagerImpl.TopComponentManager selectedTcm = this.source.selected == null ? null : WindowManagerImpl.findManager(this.source.selected);
            pf.put(CURRENT_MANAGER, selectedTcm);
            oos.writeFields();
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ObjectInputStream.GetField gf = ois.readFields();
            this.modeName = (String)gf.get(MODE_NAME, null);
            this.workspaceName = (String)gf.get(WORKSPACE_NAME, null);
            this.tcManagers = (ArrayList)gf.get(MANAGERS_LIST, null);
            this.currentTcm = (WindowManagerImpl.TopComponentManager)gf.get(CURRENT_MANAGER, null);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private final class DoPropertyChange
    implements Runnable {
        private int type;
        private TopComponent tc;
        private PropertyChangeEvent ev;

        DoPropertyChange(int type, TopComponent tc, PropertyChangeEvent ev) {
            this.type = type;
            this.tc = tc;
            this.ev = ev;
        }

        public void run() {
            if (this.type == 0) {
                if (DefaultContainerImpl.this.isAttached()) {
                    DefaultContainerImpl.this.componentNameChanged(this.tc);
                    DefaultContainerImpl.this.mode.updateTitle();
                }
                DefaultContainerImpl.this.firePropertyChange(this.ev);
            } else if (this.type == 1) {
                if (DefaultContainerImpl.this.isAttached()) {
                    DefaultContainerImpl.this.componentIconChanged(this.tc, (Image)this.ev.getNewValue());
                }
                DefaultContainerImpl.this.firePropertyChange(this.ev);
            } else if (this.type == 2) {
                DefaultContainerImpl.this.firePropertyChange(this.ev);
            } else if (this.type == 3) {
                DefaultContainerImpl.this.changeFrame((FrameType)this.ev.getOldValue(), (FrameType)this.ev.getNewValue());
            }
        }
    }

    private final class ReorderPerformer
    implements Runnable {
        List newOrder;

        ReorderPerformer(List newOrder) {
            this.newOrder = newOrder;
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            Object object = DefaultContainerImpl.this.LOCK_TOPCOMPONENTS;
            synchronized (object) {
                DefaultContainerImpl.this.setAttached(false);
                DefaultContainerImpl.this.topComponents.clear();
                DefaultContainerImpl.this.topComponents.addAll(this.newOrder);
                DefaultContainerImpl.this.setAttached(true);
            }
        }
    }
}

