/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.core.projects.cache.BinaryFS;
import org.netbeans.core.projects.cache.LayerCacheManager;
import org.netbeans.core.projects.cache.ParsingLayerCacheManager;
import org.openide.filesystems.FileSystem;

public class BinaryCacheManager
extends ParsingLayerCacheManager {
    private static final String ALL_LAYERS = "all-layers.dat";
    private File cacheFile;
    private static final String[] ATTR_TYPES = new String[]{"bytevalue", "shortvalue", "intvalue", "longvalue", "floatvalue", "doublevalue", "boolvalue", "charvalue", "stringvalue", "urlvalue", "methodvalue", "newvalue", "serialvalue"};
    private HashMap sizes;

    public BinaryCacheManager(File cacheDir) throws IOException {
        super(cacheDir);
        this.cacheFile = new File(cacheDir, ALL_LAYERS);
    }

    public boolean cacheExists() {
        return this.cacheFile.exists();
    }

    public void cleanupCache() throws IOException {
        if (this.cacheFile.exists() && !this.cacheFile.delete()) {
            throw new IOException("Could not delete: " + this.cacheFile);
        }
    }

    public boolean supportsLoad() {
        return false;
    }

    public FileSystem createLoadedFileSystem() throws IOException {
        if (this.cacheFile.exists()) {
            LayerCacheManager.err.log("Loading from " + this.cacheFile);
            BinaryFS fs = new BinaryFS(this.cacheFile.getAbsolutePath());
            return fs;
        }
        throw new IllegalStateException();
    }

    protected boolean openURLs() {
        return false;
    }

    protected FileSystem store(ParsingLayerCacheManager.MemFolder root) throws IOException {
        if (this.cacheFile.exists()) {
            this.cacheFile.delete();
        }
        FileOutputStream os = new FileOutputStream(this.cacheFile);
        try {
            this.sizes = new HashMap(1000);
            LayerCacheManager.err.log("Writing binary layer cache of length " + (this.computeSize(root) + BinaryFS.MAGIC.length) + " to " + this.cacheFile);
            ((OutputStream)os).write(BinaryFS.MAGIC);
            this.writeFolder(new BinaryWriter(os), root);
            Object var4_3 = null;
            this.sizes = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.sizes = null;
            ((OutputStream)os).close();
            throw throwable;
        }
        ((OutputStream)os).close();
        return this.createLoadedFileSystem();
    }

    private void writeFolder(BinaryWriter bw, ParsingLayerCacheManager.MemFolder folder) throws IOException {
        if (folder.attrs != null) {
            bw.writeInt(folder.attrs.size());
            Iterator it = folder.attrs.iterator();
            while (it.hasNext()) {
                this.writeAttribute(bw, (ParsingLayerCacheManager.MemAttr)it.next());
            }
        } else {
            bw.writeInt(0);
        }
        if (folder.children != null) {
            bw.writeInt(folder.children.size());
            int baseOffset = bw.getPosition();
            Iterator it = folder.children.iterator();
            while (it.hasNext()) {
                ParsingLayerCacheManager.MemFileOrFolder item = (ParsingLayerCacheManager.MemFileOrFolder)it.next();
                baseOffset += this.computeHeaderSize(item);
            }
            Iterator it2 = folder.children.iterator();
            while (it2.hasNext()) {
                ParsingLayerCacheManager.MemFileOrFolder item = (ParsingLayerCacheManager.MemFileOrFolder)it2.next();
                bw.writeString(item.name);
                bw.writeByte(item instanceof ParsingLayerCacheManager.MemFile ? (byte)0 : 1);
                bw.writeInt(baseOffset);
                baseOffset += this.computeSize(item);
            }
            Iterator it3 = folder.children.iterator();
            while (it3.hasNext()) {
                ParsingLayerCacheManager.MemFileOrFolder item = (ParsingLayerCacheManager.MemFileOrFolder)it3.next();
                if (item instanceof ParsingLayerCacheManager.MemFile) {
                    this.writeFile(bw, (ParsingLayerCacheManager.MemFile)item);
                    continue;
                }
                this.writeFolder(bw, (ParsingLayerCacheManager.MemFolder)item);
            }
        } else {
            bw.writeInt(0);
        }
    }

    private void writeFile(BinaryWriter bw, ParsingLayerCacheManager.MemFile file) throws IOException {
        if (file.attrs != null) {
            bw.writeInt(file.attrs.size());
            Iterator it = file.attrs.iterator();
            while (it.hasNext()) {
                this.writeAttribute(bw, (ParsingLayerCacheManager.MemAttr)it.next());
            }
        } else {
            bw.writeInt(0);
        }
        if (file.ref != null) {
            bw.writeInt(-1);
            bw.writeString(file.ref.toString());
        } else if (file.contents != null) {
            bw.writeInt(file.contents.length);
            bw.writeBytes(file.contents);
        } else {
            bw.writeInt(0);
        }
    }

    private void writeAttribute(BinaryWriter bw, ParsingLayerCacheManager.MemAttr attr) throws IOException {
        bw.writeString(attr.name);
        int i = 0;
        while (i < ATTR_TYPES.length) {
            if (ATTR_TYPES[i].equals(attr.type)) break;
            ++i;
        }
        bw.writeByte((byte)i);
        bw.writeString(attr.data);
    }

    private int computeSize(ParsingLayerCacheManager.MemFileOrFolder mf) {
        int size;
        block7: {
            block5: {
                ParsingLayerCacheManager.MemFile file;
                block6: {
                    Integer i = (Integer)this.sizes.get(mf);
                    if (i != null) {
                        return i;
                    }
                    size = 4;
                    if (mf.attrs != null) {
                        Iterator it = mf.attrs.iterator();
                        while (it.hasNext()) {
                            size += this.computeSize((ParsingLayerCacheManager.MemAttr)it.next());
                        }
                    }
                    if (!(mf instanceof ParsingLayerCacheManager.MemFile)) break block5;
                    file = (ParsingLayerCacheManager.MemFile)mf;
                    size += 4;
                    if (file.ref == null) break block6;
                    size += this.computeSize(file.ref.toString());
                    break block7;
                }
                if (file.contents == null) break block7;
                size += file.contents.length;
                break block7;
            }
            ParsingLayerCacheManager.MemFolder folder = (ParsingLayerCacheManager.MemFolder)mf;
            size += 4;
            if (folder.children != null) {
                Iterator it = folder.children.iterator();
                while (it.hasNext()) {
                    ParsingLayerCacheManager.MemFileOrFolder item = (ParsingLayerCacheManager.MemFileOrFolder)it.next();
                    size += this.computeHeaderSize(item);
                    size += this.computeSize(item);
                }
            }
        }
        this.sizes.put(mf, new Integer(size));
        return size;
    }

    private int computeHeaderSize(ParsingLayerCacheManager.MemFileOrFolder mof) {
        return this.computeSize(mof.name) + 1 + 4;
    }

    private int computeSize(String s) {
        try {
            return 4 + s.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            IllegalStateException ise = new IllegalStateException(e.toString());
            LayerCacheManager.err.annotate((Throwable)ise, (Throwable)e);
            throw ise;
        }
    }

    private int computeSize(ParsingLayerCacheManager.MemAttr attr) {
        return this.computeSize(attr.name) + 1 + this.computeSize(attr.data);
    }

    private final class BinaryWriter {
        private OutputStream os;
        private int position;

        BinaryWriter(OutputStream os) {
            this.os = os;
        }

        int getPosition() {
            return this.position;
        }

        void writeByte(byte b) throws IOException {
            this.os.write(b);
            ++this.position;
        }

        void writeBytes(byte[] bytes) throws IOException {
            this.os.write(bytes);
            this.position += bytes.length;
        }

        void writeInt(int num) throws IOException {
            byte[] data = new byte[]{(byte)num, (byte)(num >> 8), (byte)(num >> 16), (byte)(num >> 24)};
            this.writeBytes(data);
        }

        void writeString(String str) throws IOException {
            byte[] data;
            try {
                data = str.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                IllegalStateException ise = new IllegalStateException(e.toString());
                LayerCacheManager.err.annotate((Throwable)ise, (Throwable)e);
                throw ise;
            }
            this.writeInt(data.length);
            this.writeBytes(data);
        }
    }
}

