/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.core.projects.SerialDataConvertor;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListener;

final class ModuleInfoManager {
    private static final ModuleInfoManager mim = new ModuleInfoManager();
    private HashMap modules = null;
    private Lookup.Result modulesResult = null;
    private HashMap mapOfListeners;
    static /* synthetic */ Class class$org$openide$modules$ModuleInfo;

    private ModuleInfoManager() {
    }

    public static final ModuleInfoManager getDefault() {
        return mim;
    }

    public ModuleInfo getModule(String codeBaseName) {
        Collection l = null;
        if (this.modules == null) {
            l = this.getModulesResult().allInstances();
        }
        ModuleInfoManager moduleInfoManager = this;
        synchronized (moduleInfoManager) {
            if (this.modules == null) {
                this.fillModules(l);
            }
            ModuleInfo moduleInfo = (ModuleInfo)this.modules.get(codeBaseName);
            return moduleInfo;
        }
    }

    private Lookup.Result getModulesResult() {
        ModuleInfoManager moduleInfoManager = this;
        synchronized (moduleInfoManager) {
            if (this.modulesResult == null) {
                this.modulesResult = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = ModuleInfoManager.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo));
                this.modulesResult.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent ev) {
                        List reloaded;
                        Collection l = ModuleInfoManager.this.getModulesResult().allInstances();
                        1 var4_3 = this;
                        synchronized (var4_3) {
                            ModuleInfoManager.this.fillModules(l);
                            reloaded = ModuleInfoManager.this.replaceReloadedModules();
                        }
                        ModuleInfoManager.this.notifyReloads(reloaded);
                    }
                });
            }
            Lookup.Result result = this.modulesResult;
            return result;
        }
    }

    private void notifyReloads(List l) {
        Iterator it = l.iterator();
        while (it.hasNext()) {
            PCL lsnr = (PCL)it.next();
            lsnr.notifyReload();
        }
    }

    private void fillModules(Collection l) {
        HashMap<String, ModuleInfo> m = new HashMap<String, ModuleInfo>((l.size() << 2) / 3 + 1);
        Iterator it = l.iterator();
        while (it.hasNext()) {
            ModuleInfo mi = (ModuleInfo)it.next();
            m.put(mi.getCodeNameBase(), mi);
        }
        this.modules = m;
    }

    private List replaceReloadedModules() {
        if (this.mapOfListeners == null) {
            return Collections.EMPTY_LIST;
        }
        Iterator it = ((AbstractList)new ArrayList(this.mapOfListeners.keySet())).iterator();
        ArrayList<PCL> reloaded = new ArrayList<PCL>();
        while (it.hasNext()) {
            ModuleInfo miNew;
            ModuleInfo mi = (ModuleInfo)it.next();
            if (mi == (miNew = (ModuleInfo)this.modules.get(mi.getCodeNameBase())) || miNew == null) continue;
            PCL lsnr = (PCL)this.mapOfListeners.remove(mi);
            lsnr.setModuleInfo(miNew);
            reloaded.add(lsnr);
            this.mapOfListeners.put(miNew, lsnr);
        }
        return reloaded;
    }

    public ModuleInfo getModuleInfo(Class clazz) {
        Iterator it = this.getModulesResult().allInstances().iterator();
        while (it.hasNext()) {
            ModuleInfo mi = (ModuleInfo)it.next();
            if (!mi.owns(clazz)) continue;
            return mi;
        }
        return null;
    }

    public synchronized void registerPropertyChangeListener(SerialDataConvertor sdc, ModuleInfo mi) {
        PCL lsnr;
        if (this.mapOfListeners == null) {
            this.mapOfListeners = new HashMap(this.modules.size());
        }
        if ((lsnr = (PCL)this.mapOfListeners.get(mi)) == null) {
            lsnr = new PCL(mi);
            this.mapOfListeners.put(mi, lsnr);
        }
        PropertyChangeListener pcl = WeakListener.propertyChange((PropertyChangeListener)sdc, (Object)lsnr);
        lsnr.addPropertyChangeListener(sdc, pcl);
    }

    public synchronized void unregisterPropertyChangeListener(SerialDataConvertor sdc, ModuleInfo mi) {
        if (this.mapOfListeners == null) {
            return;
        }
        PCL lsnr = (PCL)this.mapOfListeners.get(mi);
        if (lsnr != null) {
            lsnr.removePropertyChangeListener(sdc);
        }
    }

    public synchronized boolean isReloaded(ModuleInfo mi) {
        if (this.mapOfListeners == null) {
            return false;
        }
        PCL lsnr = (PCL)this.mapOfListeners.get(mi);
        return lsnr != null && lsnr.isReloaded();
    }

    public synchronized boolean isReloaded(String codeBaseName) {
        if (this.mapOfListeners == null) {
            return false;
        }
        return this.isReloaded(this.getModule(codeBaseName));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class PCL
    implements PropertyChangeListener {
        private boolean aModuleHasBeenChanged = false;
        private boolean wasModuleEnabled;
        private ModuleInfo mi;
        private PropertyChangeSupport changeSupport;
        private Map origs;

        public PCL(ModuleInfo mi) {
            this.mi = mi;
            this.wasModuleEnabled = mi.isEnabled();
            mi.addPropertyChangeListener((PropertyChangeListener)this);
        }

        void setModuleInfo(ModuleInfo mi) {
            this.mi.removePropertyChangeListener((PropertyChangeListener)this);
            this.aModuleHasBeenChanged = true;
            this.mi = mi;
            mi.addPropertyChangeListener((PropertyChangeListener)this);
        }

        void notifyReload() {
            this.firePropertyChange();
        }

        boolean isReloaded() {
            return this.aModuleHasBeenChanged;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("enabled".equals(evt.getPropertyName())) {
                boolean change;
                if (!Boolean.TRUE.equals(evt.getNewValue())) {
                    this.aModuleHasBeenChanged = true;
                    change = this.wasModuleEnabled;
                } else {
                    change = !this.wasModuleEnabled;
                }
                this.wasModuleEnabled = this.mi.isEnabled();
                if (change) {
                    this.firePropertyChange();
                }
            }
        }

        public void addPropertyChangeListener(SerialDataConvertor sdc, PropertyChangeListener listener) {
            PCL pCL = this;
            synchronized (pCL) {
                PropertyChangeListener old;
                if (this.changeSupport == null) {
                    this.changeSupport = new PropertyChangeSupport(this);
                    this.origs = new WeakHashMap();
                }
                if ((old = (PropertyChangeListener)this.origs.get(sdc)) != null) {
                    return;
                }
                this.origs.put(sdc, listener);
            }
            this.changeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            if (this.changeSupport != null) {
                this.changeSupport.removePropertyChangeListener(listener);
            }
        }

        public void removePropertyChangeListener(SerialDataConvertor sdc) {
            PCL pCL = this;
            synchronized (pCL) {
                if (this.origs == null) {
                    return;
                }
                PropertyChangeListener pcl = (PropertyChangeListener)this.origs.remove(sdc);
                if (pcl != null) {
                    this.removePropertyChangeListener(pcl);
                }
            }
        }

        private void firePropertyChange() {
            if (this.changeSupport != null) {
                this.changeSupport.firePropertyChange("enabled", null, null);
            }
        }
    }
}

