/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Hashtable;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.netbeans.core.IDESettings;
import org.netbeans.core.NbTheme;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.NonGui;
import org.netbeans.core.ShortcutsFolder;
import org.netbeans.core.Splash;
import org.netbeans.core.TopThreadGroup;
import org.netbeans.core.WarmUpSupport;
import org.netbeans.core.perftool.PerformanceMeter;
import org.netbeans.core.perftool.PerformanceMeterFactory;
import org.netbeans.core.perftool.StartLog;
import org.netbeans.core.perftool.Util;
import org.netbeans.core.ui.WelcomePanel;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.frames.NbFocusManager;
import org.netbeans.core.xml.NbSAXParserFactoryImpl;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.windows.WindowManager;

public final class Main
extends NonGui {
    private static Splash.SplashOutput splash;
    static /* synthetic */ Class class$javax$swing$ToolTipManager;
    static /* synthetic */ Class class$org$netbeans$core$Main;

    public static void setSplashMaxSteps(int maxSteps) {
        if (Boolean.getBoolean("netbeans.splash.nobar") || NonGui.noSplash || splash == null) {
            return;
        }
        splash.setMaxSteps(maxSteps);
    }

    public static void addToSplashMaxSteps(int steps) {
        if (Boolean.getBoolean("netbeans.splash.nobar") || NonGui.noSplash || splash == null) {
            return;
        }
        splash.addToMaxSteps(steps);
    }

    public static void addAndSetSplashMaxSteps(int steps) {
        if (Boolean.getBoolean("netbeans.splash.nobar") || NonGui.noSplash || splash == null) {
            return;
        }
        splash.addAndSetMaxSteps(steps);
    }

    public static void incrementSplashProgressBar() {
        Main.incrementSplashProgressBar(1);
    }

    public static void incrementSplashProgressBar(int steps) {
        if (Boolean.getBoolean("netbeans.splash.nobar") || NonGui.noSplash || splash == null) {
            return;
        }
        splash.increment(steps);
    }

    public static void main(String[] argv) {
        TopThreadGroup tg = new TopThreadGroup("IDE Main", argv);
        StartLog.logStart("Forwarding to topThreadGroup");
        tg.start();
    }

    public void run() {
        StartLog.logStart("TopManager initialization (org.netbeans.core.Main.run())");
        NbFocusManager.install();
        if (NonGui.uiClass != null) {
            try {
                LookAndFeel customUI = (LookAndFeel)NonGui.uiClass.newInstance();
                UIManager.setLookAndFeel(customUI);
            }
            catch (Exception e) {
                System.out.println(Main.getString("ERR_UIError"));
            }
        } else {
            NbTheme nbTheme = new NbTheme();
            MetalLookAndFeel.setCurrentTheme(nbTheme);
            try {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            }
            catch (Exception ex) {
                System.out.println("Failed loading Metal look and feel");
                System.out.println(ex);
                NonGui.uiFontSize = 11;
            }
        }
        StartLog.logProgress("Theme set");
        try {
            ToolTipManager ttm = ToolTipManager.sharedInstance();
            Field heavyWeight = (class$javax$swing$ToolTipManager == null ? (class$javax$swing$ToolTipManager = Main.class$("javax.swing.ToolTipManager")) : class$javax$swing$ToolTipManager).getDeclaredField("heavyWeightPopupEnabled");
            ((AccessibleObject)heavyWeight).setAccessible(true);
            heavyWeight.setBoolean(ttm, true);
        }
        catch (Exception e) {
            ErrorManager.getDefault().annotate((Throwable)e, 1, "Can not set ToolTipManager.heavyWeightPopupEnabled to true", null, null, null);
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        if (NonGui.uiFontSize > 0) {
            FontUIResource nbDialogPlain = new FontUIResource("Dialog", 0, NonGui.uiFontSize);
            FontUIResource nbDialogBold = new FontUIResource("Dialog", 1, NonGui.uiFontSize);
            FontUIResource nbSerifPlain = new FontUIResource("Serif", 0, NonGui.uiFontSize);
            FontUIResource nbSansSerifPlain = new FontUIResource("SansSerif", 0, NonGui.uiFontSize);
            FontUIResource nbMonospacedPlain = new FontUIResource("Monospaced", 0, NonGui.uiFontSize);
            UIManager.getDefaults().put("Button.font", nbDialogPlain);
            UIManager.getDefaults().put("ToggleButton.font", nbDialogPlain);
            UIManager.getDefaults().put("RadioButton.font", nbDialogPlain);
            UIManager.getDefaults().put("CheckBox.font", nbDialogPlain);
            UIManager.getDefaults().put("ColorChooser.font", nbDialogPlain);
            UIManager.getDefaults().put("ComboBox.font", nbDialogPlain);
            UIManager.getDefaults().put("Label.font", nbDialogPlain);
            UIManager.getDefaults().put("List.font", nbDialogPlain);
            UIManager.getDefaults().put("MenuBar.font", nbDialogPlain);
            UIManager.getDefaults().put("MenuItem.font", nbDialogPlain);
            UIManager.getDefaults().put("MenuItem.acceleratorFont", nbDialogPlain);
            UIManager.getDefaults().put("RadioButtonMenuItem.font", nbDialogPlain);
            UIManager.getDefaults().put("CheckBoxMenuItem.font", nbDialogPlain);
            UIManager.getDefaults().put("Menu.font", nbDialogPlain);
            UIManager.getDefaults().put("PopupMenu.font", nbDialogPlain);
            UIManager.getDefaults().put("OptionPane.font", nbDialogPlain);
            UIManager.getDefaults().put("Panel.font", nbDialogPlain);
            UIManager.getDefaults().put("ProgressBar.font", nbDialogPlain);
            UIManager.getDefaults().put("ScrollPane.font", nbDialogPlain);
            UIManager.getDefaults().put("Viewport.font", nbDialogPlain);
            UIManager.getDefaults().put("TabbedPane.font", nbDialogPlain);
            UIManager.getDefaults().put("Table.font", nbDialogPlain);
            UIManager.getDefaults().put("TableHeader.font", nbDialogPlain);
            UIManager.getDefaults().put("TextField.font", nbSansSerifPlain);
            UIManager.getDefaults().put("PasswordField.font", nbMonospacedPlain);
            UIManager.getDefaults().put("TextArea.font", nbMonospacedPlain);
            UIManager.getDefaults().put("TextPane.font", nbSerifPlain);
            UIManager.getDefaults().put("EditorPane.font", nbSerifPlain);
            UIManager.getDefaults().put("TitledBorder.font", nbDialogPlain);
            UIManager.getDefaults().put("ToolBar.font", nbDialogPlain);
            UIManager.getDefaults().put("ToolTip.font", nbSansSerifPlain);
            UIManager.getDefaults().put("Tree.font", nbDialogPlain);
            UIManager.getDefaults().put("InternalFrame.titleFont", nbDialogBold);
        }
        StartLog.logProgress("Fonts updated");
        try {
            Object lockObject;
            Hashtable<String, String> newTable = new Hashtable<String, String>();
            newTable.put("monospaced", "Monospaced");
            newTable.put("Monospaced", "Monospaced");
            newTable.put("serif", "Serif");
            newTable.put("Serif", "Serif");
            newTable.put("sansserif", "SansSerif");
            newTable.put("SansSerif", "SansSerif");
            Class<?> cls = Class.forName("javax.swing.text.html.CSS");
            Field lock = cls.getDeclaredField("fontMappingLock");
            Field table = cls.getDeclaredField("fontMapping");
            ((AccessibleObject)lock).setAccessible(true);
            ((AccessibleObject)table).setAccessible(true);
            Object object = lockObject = lock.get(null);
            synchronized (object) {
                if (table.get(null) == null) {
                    table.set(null, newTable);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        StartLog.logProgress("CSS fontMapping hacked");
        Object inputMap = UIManager.getDefaults().get("Desktop.ancestorInputMap");
        if (inputMap instanceof InputMapUIResource) {
            ((InputMapUIResource)inputMap).remove(KeyStroke.getKeyStroke(116, 2));
        }
        StartLog.logProgress("Desktop shortcuts updated");
        super.run();
        StartLog.logProgress("NonGui part done");
        StartLog.logEnd("TopManager initialization (org.netbeans.core.Main.run())");
    }

    protected void initializeMainWindow() {
        StartLog.logStart("Main window initialization");
        StatusDisplayer.getDefault().setStatusText(Main.getString("MSG_MainWindowInit"));
        final MainWindow mainWindow = MainWindow.getDefault();
        mainWindow.initialize();
        Main.incrementSplashProgressBar(10);
        StartLog.logProgress("Main window initialized");
        Timer timerInit = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
            }
        });
        timerInit.setRepeats(false);
        timerInit.start();
        Main.incrementSplashProgressBar(10);
        StartLog.logProgress("Timer initialized");
        StatusDisplayer.getDefault().setStatusText(Main.getString("MSG_DefaultWorkspaceInit"));
        WindowManager.getDefault();
        Main.incrementSplashProgressBar();
        StartLog.logProgress("Workspaces initialized");
        if (System.getProperty("netbeans.kill") == null && System.getProperty("netbeans.close") == null) {
            ShortcutsFolder.initShortcuts();
        }
        Main.incrementSplashProgressBar();
        StartLog.logProgress("Shortcuts initialized");
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject fo = fs.findResource("Welcome");
        if (fo != null && fo.getChildren().length > 0 && System.getProperty("netbeans.full.hack") == null && System.getProperty("netbeans.close") == null) {
            mainWindow.addComponentListener(new ComponentAdapter(){
                static /* synthetic */ Class class$org$netbeans$core$IDESettings;

                public void componentShown(ComponentEvent evt) {
                    mainWindow.removeComponentListener(this);
                    IDESettings ideSettings = (IDESettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = 2.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
                    if (ideSettings.getShowTipsOnStartup()) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                WelcomePanel.showGettingStarted();
                            }
                        });
                        StartLog.logProgress("Welcome dialog fired");
                    }
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            });
        }
        if (System.getProperty("netbeans.warmup.skip") == null && System.getProperty("netbeans.close") == null) {
            mainWindow.addComponentListener(new ComponentAdapter(){

                public void componentShown(ComponentEvent evt) {
                    mainWindow.removeComponentListener(this);
                    WarmUpSupport.warmUp();
                }
            });
        }
        StatusDisplayer.getDefault().setStatusText(Main.getString("MSG_WindowShowInit"));
        mainWindow.showWindow();
        StatusDisplayer.getDefault().setStatusText("");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Thread.currentThread().setContextClassLoader(Main.this.getModuleSystem().getManager().getClassLoader());
            }
        });
        StartLog.logProgress("Main window opened");
        StartLog.logEnd("Main window initialization");
    }

    private static void checkDoubleBuffering() {
        RepaintManager rm;
        if (Boolean.getBoolean("openide.windows.nodoublebuffer") && (rm = RepaintManager.currentManager(null)) != null) {
            rm.setDoubleBufferingEnabled(false);
        }
    }

    static void start(String[] args) throws SecurityException {
        long time = System.currentTimeMillis();
        StartLog.logEnd("Forwarding to topThreadGroup");
        StartLog.logStart("Preparation");
        if (((Hashtable)System.getProperties()).get("org.openide.TopManager") == null) {
            ((Hashtable)System.getProperties()).put("org.openide.TopManager", "org.netbeans.core.Main");
        }
        NbSAXParserFactoryImpl.install();
        StartLog.logProgress("Basic properties set");
        NonGui.parseCommandLine(args);
        StartLog.logProgress("Command line parsed");
        Main.checkDoubleBuffering();
        StartLog.logProgress("Double buffering checked");
        if (!NonGui.noSplash) {
            splash = Splash.showSplash();
        }
        StartLog.logProgress("Splash shown");
        StartLog.logStart("Creation of TopManager");
        NbTopManager.get();
        StartLog.logEnd("Creation of TopManager");
        if (splash != null) {
            Splash.hideSplash(splash);
            splash = null;
        }
        StartLog.logProgress("Splash hidden");
        if (Util.isRunning()) {
            Main.measureStart(time);
        }
        StartLog.logProgress("Startup memory and time measured");
        if (System.getProperty("netbeans.kill") != null) {
            NonGui.doExit(5);
        }
        if (System.getProperty("netbeans.close") != null) {
            if (Boolean.getBoolean("netbeans.warm.close")) {
                ShortcutsFolder.initShortcuts();
                new WarmUpSupport().run();
            }
            LifecycleManager.getDefault().exit();
        }
        StartLog.logEnd("Preparation");
    }

    private static void measureStart(long time) {
        Util.waitForSystemThreads();
        PerformanceMeter pm = PerformanceMeterFactory.getPerformanceMeter();
        pm.notifyTime("Total startup time:", System.currentTimeMillis() - time);
        Runtime rt = Runtime.getRuntime();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        int i = 0;
        while (i < 5) {
            rt.gc();
            ++i;
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        int i2 = 0;
        while (i2 < 5) {
            rt.gc();
            ++i2;
        }
        long mem = rt.totalMemory();
        long free = rt.freeMemory();
        pm.notifyMemory("Total heap:", mem);
        pm.notifyMemory("Used heap:", mem - free);
    }

    static String getString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$core$Main == null ? (class$org$netbeans$core$Main = Main.class$("org.netbeans.core.Main")) : class$org$netbeans$core$Main), (String)s);
    }

    protected Splash.SplashOutput getSplash() {
        return splash;
    }

    protected void showSplashAgain() {
        if (!NonGui.noSplash) {
            if (splash != null) {
                if (Splash.isVisible(splash)) {
                    return;
                }
                splash = null;
            }
            splash = Splash.showSplash();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

