/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import junit.extensions.jfcunit.xml.XMLRecorder;
import junit.extensions.xml.XMLTestSuite;
import junit.extensions.xml.XMLUtil;
import junit.framework.Test;
import junit.textui.TestRunner;

public class XMLRoot
extends XMLTestSuite {
    public static final String DOCUMENT_FACTORY = "javax.xml.parsers.DocumentBuilderFactory";
    public static final String XMLROOT_CLASSNAME = "jfcunit.xmlroot.classname";
    public static final String XMLROOT_ARGS = "jfcunit.xmlroot.args";
    public static final String XMLROOT_RECORD = "jfcunit.xmlroot.record";
    public static final String XMLROOT_TESTSUITE = "jfcunit.xmlroot.testsuite";
    public static final String XMLROOT_CREATE = "jfcunit.xmlroot.create";
    static /* synthetic */ Class array$Ljava$lang$String;

    public XMLRoot() throws Exception {
        this(XMLRoot.getClassName(), XMLRoot.getArgs(), XMLRoot.getTestSuite());
    }

    public XMLRoot(final String classname, String[] args, String filename) throws Exception {
        super(filename, XMLRoot.getInputStream(classname.trim(), args, filename));
        Class<?> applClass = this.getClass().getClassLoader().loadClass(classname.trim());
        Class[] parameterSpec = new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = XMLRoot.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
        final Method mainMethod = applClass.getMethod("main", parameterSpec);
        XMLRecorder.setReplay(!XMLRoot.getRecord());
        String[] appArgs = args == null ? new String[]{} : args;
        final Object[] parameters = new Object[]{appArgs};
        new Thread(new Runnable(){

            public void run() {
                try {
                    mainMethod.invoke(null, parameters);
                }
                catch (IllegalAccessException ex) {
                    System.err.println("Exception occured while invoking application:" + classname);
                    ex.printStackTrace();
                }
                catch (IllegalArgumentException ex) {
                    System.err.println("Exception occured while invoking application:" + classname);
                    ex.printStackTrace();
                }
                catch (InvocationTargetException ex) {
                    System.err.println("Exception occured while invoking application:" + classname);
                    ex.printStackTrace();
                }
            }
        }).start();
    }

    public static void main(String[] args) throws Exception {
        XMLRoot.updateDocFactory();
        if (args.length < 2) {
            TestRunner.run((Test)XMLRoot.suite());
        } else if (args.length >= 2) {
            System.out.println("Application Class = " + args[0]);
            String[] progArgs = new String[args.length - 2];
            for (int i = 1; i < args.length - 1; ++i) {
                progArgs[i - 1] = args[i];
            }
            System.out.println("Test Suite = " + args[args.length - 1]);
            TestRunner.run((Test)XMLRoot.suite(args[0], progArgs, args[args.length - 1]));
        } else {
            System.out.println("Usage: junit.extensions.jfcunit.tools.XMLRoot mainclass  [class arguments...] [xml file]");
            System.exit(1);
        }
    }

    public static Test suite() throws Exception {
        XMLRoot.updateDocFactory();
        return new XMLRoot();
    }

    public static Test suite(String classname, String[] args, String filename) throws Exception {
        XMLRoot.updateDocFactory();
        return new XMLRoot(classname, args, filename);
    }

    protected static final String[] getArgs() {
        String args = System.getProperty(XMLROOT_ARGS);
        if (args == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(args, " ");
        String[] tokens = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            tokens[i++] = st.nextToken();
        }
        return tokens;
    }

    protected static final String getClassName() {
        String classname = System.getProperty(XMLROOT_CLASSNAME);
        if (classname == null) {
            throw new RuntimeException("Could not find system property:jfcunit.xmlroot.classname");
        }
        return classname;
    }

    protected static final String getCommand(String classname, String[] args) {
        StringBuffer buf = new StringBuffer(1000);
        buf.append(classname);
        buf.append(" ");
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                buf.append(args[i]);
                buf.append(" ");
            }
        }
        return buf.toString();
    }

    protected static final boolean getCreate() {
        if (XMLRoot.getRecord()) {
            return Boolean.getBoolean(XMLROOT_CREATE);
        }
        return false;
    }

    protected static InputStream getInputStream(String classname, String[] args, String fileName) {
        InputStream is = null;
        try {
            is = XMLUtil.readFileFromClasspath(fileName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (is != null) {
            return is;
        }
        File file = new File(fileName);
        if (file.exists()) {
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException ex) {
                System.err.println("Error opening local file." + fileName);
                is = null;
            }
            return is;
        }
        if (!XMLRoot.getCreate()) {
            System.err.println("File not found:" + fileName);
        } else {
            try {
                file.createNewFile();
                FileOutputStream os = new FileOutputStream(file);
                PrintWriter pw = new PrintWriter(os);
                pw.println("<?xml version=\"1.0\" ?>");
                pw.println("<!-- An example test suite template              -->");
                pw.println("<!-- The first step in creating the test case is -->");
                pw.println("<!-- to document what is going to be tested.     -->");
                pw.println("<!-- To do this, create the test suites and      -->");
                pw.println("<!-- test cases which are to be recorded.        -->");
                pw.println("<!-- 2. Setup the JFCXMLTestCase extension,      -->");
                pw.println("<!-- to startup your application.                -->");
                pw.println("<!-- 3. Run the JFCXMLTestCase defined above.    -->");
                pw.println("<!-- 4. While the test case is running each      -->");
                pw.println("<!-- \"record\" element will add to the XML.       -->");
                pw.print("<suite name=\"");
                pw.print(XMLRoot.getCommand(classname, args));
                pw.println("\">");
                pw.println("    <!-- definition of a local suite -->");
                pw.println("    <suite name=\"Recording test suite\">");
                pw.println("        <test name=\"Recording test\" robot=\"true\">");
                pw.print("             <record encoding=\"UTF-8\" file=\"");
                pw.print(fileName);
                pw.println("\"/>");
                pw.println("        </test>");
                pw.println("    </suite>");
                pw.println("</suite>");
                pw.close();
                os.close();
                return new FileInputStream(file);
            }
            catch (IOException ex1) {
                System.err.println("Error creating new XML file." + fileName);
                ex1.printStackTrace();
            }
        }
        return null;
    }

    protected static final boolean getRecord() {
        return Boolean.getBoolean(XMLROOT_RECORD);
    }

    protected static final String getTestSuite() {
        String testsuite = System.getProperty(XMLROOT_TESTSUITE);
        if (testsuite == null) {
            throw new RuntimeException("Could not find system property: jfcunit.xmlroot.testsuite");
        }
        return testsuite;
    }

    private static void updateDocFactory() {
        String version = System.getProperty("java.version");
        if ((version.startsWith("1.2") || version.startsWith("1.3")) && System.getProperty(DOCUMENT_FACTORY) == null) {
            System.setProperty(DOCUMENT_FACTORY, "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

