/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.taskDemo;

import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class SFib
extends FJTask {
    static int sequentialThreshold = 0;
    volatile int number;

    public static void main(String[] args) {
        try {
            int procs;
            try {
                procs = Integer.parseInt(args[0]);
                if (args.length > 2) {
                    sequentialThreshold = Integer.parseInt(args[2]);
                }
            }
            catch (Exception e) {
                System.out.println("Usage: java SFib <threads> <number> [<sequntialThreshold>]");
                return;
            }
            FJTaskRunnerGroup group = new FJTaskRunnerGroup(procs);
            ServerSocket socket = new ServerSocket(1618);
            while (true) {
                Socket connection = socket.accept();
                group.execute(new Handler(connection));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    SFib(int n) {
        this.number = n;
    }

    int getAnswer() {
        if (!this.isDone()) {
            throw new Error("Not yet computed");
        }
        return this.number;
    }

    public void run() {
        int n = this.number;
        if (n > 1) {
            if (n <= sequentialThreshold) {
                this.number = SFib.seqFib(n);
            } else {
                SFib f1 = new SFib(n - 1);
                SFib f2 = new SFib(n - 2);
                FJTask.coInvoke(f1, f2);
                this.number = f1.number + f2.number;
            }
        }
    }

    static int seqFib(int n) {
        if (n <= 1) {
            return n;
        }
        return SFib.seqFib(n - 1) + SFib.seqFib(n - 2);
    }

    static class Handler
    extends FJTask {
        final Socket s;

        Handler(Socket s) {
            this.s = s;
        }

        public void run() {
            try {
                DataInputStream i = new DataInputStream(this.s.getInputStream());
                DataOutputStream o = new DataOutputStream(this.s.getOutputStream());
                int n = i.readInt();
                SFib f = new SFib(n);
                FJTask.invoke(f);
                o.writeInt(f.getAnswer());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

